/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.util;

import com.jaspersoft.jasperserver.api.common.util.CharacterEncodingProvider;
import com.jaspersoft.jasperserver.war.util.HttpUtils;
import com.jaspersoft.jasperserver.war.util.StringEncoder;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class DefaultHttpUtils
implements HttpUtils {
    private CharacterEncodingProvider characterEncodingProvider;
    private HeaderEncoder[] headerEncoders;

    @Override
    public String encodeContentFilename(HttpServletRequest request, String filename) {
        String encodedFilename = filename;
        String userAgent = request.getHeader("User-Agent").toLowerCase();
        String charset = this.characterEncodingProvider.getCharacterEncoding();
        for (int i = 0; i < this.headerEncoders.length; ++i) {
            HeaderEncoder encoder = this.headerEncoders[i];
            if (!encoder.matches(userAgent)) continue;
            encodedFilename = encoder.encodeHeader(filename, charset);
            break;
        }
        return encodedFilename;
    }

    public CharacterEncodingProvider getCharacterEncodingProvider() {
        return this.characterEncodingProvider;
    }

    public void setCharacterEncodingProvider(CharacterEncodingProvider characterEncodingProvider) {
        this.characterEncodingProvider = characterEncodingProvider;
    }

    public HeaderEncoder[] getHeaderEncoders() {
        return this.headerEncoders;
    }

    public void setHeaderEncoders(HeaderEncoder[] headerEncoders) {
        this.headerEncoders = headerEncoders;
    }

    public static class HeaderEncoder {
        private Pattern userAgentPattern;
        private StringEncoder headerEncoder;

        public boolean matches(String userAgent) {
            return this.userAgentPattern.matcher(userAgent).matches();
        }

        public String encodeHeader(String text, String charset) {
            return this.headerEncoder.encode(text, charset);
        }

        public Pattern getUserAgentPattern() {
            return this.userAgentPattern;
        }

        public void setUserAgentPattern(Pattern userAgentPattern) {
            this.userAgentPattern = userAgentPattern;
        }

        public StringEncoder getHeaderEncoder() {
            return this.headerEncoder;
        }

        public void setHeaderEncoder(StringEncoder headerEncoder) {
            this.headerEncoder = headerEncoder;
        }
    }
}

