/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.themes.action;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.domain.TenantQualified;
import com.jaspersoft.jasperserver.api.metadata.user.service.TenantService;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.themes.ThemeFolderExistsException;
import com.jaspersoft.jasperserver.war.themes.ThemeService;
import com.jaspersoft.jasperserver.war.util.JSONConverterBase;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ThemeAction
extends FormAction {
    public static final String AJAX_RESPONSE_MODEL = "ajaxResponseModel";
    public static final String DOWNLOAD_FILE_NAME = "downloadFileName";
    public static final String CONTENT_TYPE = "contentType";
    public static final String AJAX_ERROR = "ajaxerror";
    public static final String FOLDER_URI = "folderUri";
    public static final String FILE_CONTENT = "fileContent";
    public static final String SUCCESSFUL = "Successful";
    public static final String IGNORED = "Ignored";
    public static final String REFRESH = "refresh";
    public static final String THEMES_NOT_A_THEME = "repository.themes.notATheme";
    public static final String THEMES_CANNOT_DOWNLOAD = "repository.themes.cannotDownloadTheme";
    public static final String THEMES_CANNOT_UPLOAD = "repository.themes.cannotUploadTheme";
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private TenantService tenantService;
    protected MessageSource messages;
    private ThemeService themeService;
    private ThemeResolver themeResolver;
    private RepositoryService repositoryService;

    public Event setActiveTheme(RequestContext context) throws Exception {
        String folderUri = context.getRequestParameters().get(FOLDER_URI);
        if (this.themeService.isThemeFolder(null, folderUri)) {
            String userTenantId;
            String themeName = folderUri.substring(folderUri.lastIndexOf("/") + 1);
            Tenant tenant = this.tenantService.getTenantBasedOnRepositoryUri(null, folderUri);
            if (tenant == null) {
                tenant = this.tenantService.getTenant(null, "organizations");
            }
            this.themeService.setActiveTheme(null, tenant.getId(), themeName);
            JSONObject ret = new JSONConverterBase().createOKJSONResponse(SUCCESSFUL);
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            if (auth != null && auth.getPrincipal() != null && auth.getPrincipal() instanceof TenantQualified && ((userTenantId = ((TenantQualified)auth.getPrincipal()).getTenantId()) == null && tenant.getId().equals("organizations") || tenant.getId().equals(userTenantId))) {
                this.themeResolver.setThemeName((HttpServletRequest)context.getExternalContext().getNativeRequest(), (HttpServletResponse)context.getExternalContext().getNativeResponse(), null);
                JSONObject data = new JSONObject();
                data.put(REFRESH, true);
                ret.put(JSONConverterBase.RESPONSE_DATA, (Object)data);
            }
            context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)ret.toString());
            return this.success();
        }
        JSONObject ret = new JSONConverterBase().createErrorJSONResponse(IGNORED);
        context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)ret.toString());
        return this.success();
    }

    public Event downloadTheme(RequestContext context) throws Exception {
        String folderUri = context.getRequestParameters().get(FOLDER_URI);
        if (folderUri == null) {
            this.log.error((Object)"cannot download theme : folderURI is null");
            String errorMsg = this.messages.getMessage(THEMES_CANNOT_DOWNLOAD, new Object[]{"folderURI is null"}, LocaleContextHolder.getLocale());
            JSONObject ret = new JSONConverterBase().createErrorJSONResponse(errorMsg);
            context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)ret.toString());
            return this.error();
        }
        if (this.themeService.isThemeFolder(null, folderUri)) {
            try {
                String themeName = folderUri.substring(folderUri.lastIndexOf("/") + 1);
                ExecutionContext executionContext = JasperServerUtil.getExecutionContext(context);
                byte[] buffer = this.themeService.getZipedTheme(executionContext, folderUri);
                context.getRequestScope().put(DOWNLOAD_FILE_NAME, (Object)(themeName + ".zip"));
                context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)buffer);
                context.getRequestScope().put(CONTENT_TYPE, (Object)"application/zip");
                return this.success();
            }
            catch (Exception ex) {
                this.log.error((Object)"cannot download theme", (Throwable)ex);
                String errorMsg = this.messages.getMessage(THEMES_CANNOT_DOWNLOAD, new Object[]{ex.getMessage()}, LocaleContextHolder.getLocale());
                JSONObject ret = new JSONConverterBase().createErrorJSONResponse(errorMsg);
                context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)ret.toString());
                return this.error();
            }
        }
        String errorMsg = this.messages.getMessage(THEMES_NOT_A_THEME, null, LocaleContextHolder.getLocale());
        JSONObject ret = new JSONConverterBase().createErrorJSONResponse(errorMsg);
        context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)ret.toString());
        return this.error();
    }

    public Event reuploadTheme(RequestContext context) throws Exception {
        String themeName = context.getRequestParameters().get("themeName");
        String folderUri = context.getRequestParameters().get(FOLDER_URI);
        try {
            byte[] fileContent;
            ExecutionContext executionContext = JasperServerUtil.getExecutionContext(context);
            MultipartFile multipartFile = context.getRequestParameters().getMultipartFile("themeZip");
            if (multipartFile != null) {
                fileContent = multipartFile.getBytes();
            } else {
                fileContent = (byte[])context.getFlowScope().get(FILE_CONTENT);
                context.getFlowScope().remove(FILE_CONTENT);
            }
            this.themeService.addZippedTheme(executionContext, folderUri, themeName, fileContent, true);
            String themeUri = folderUri + "/" + themeName;
            boolean isActiveTheme = this.themeService.isActiveThemeFolder(executionContext, themeUri);
            JSONObject jsonObject = new JSONObject().put("isActiveTheme", isActiveTheme);
            jsonObject.put("themeUri", (Object)themeUri);
            JSONObject ret = new JSONConverterBase().createJSONResponse(jsonObject);
            context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)ret.toString());
            return this.success();
        }
        catch (Exception ex) {
            this.log.error((Object)"cannot reupload theme", (Throwable)ex);
            String errorMsg = this.messages.getMessage(THEMES_CANNOT_UPLOAD, new Object[]{ex.getMessage()}, LocaleContextHolder.getLocale());
            JSONObject ret = new JSONConverterBase().createErrorJSONResponse(errorMsg);
            context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)ret.toString());
            return this.error();
        }
    }

    public Event uploadTheme(RequestContext context) throws Exception {
        String themeName = context.getRequestParameters().get("themeName");
        String folderUri = context.getRequestParameters().get(FOLDER_URI);
        byte[] fileContent = (byte[])context.getFlowScope().get(FILE_CONTENT);
        try {
            ExecutionContext executionContext = JasperServerUtil.getExecutionContext(context);
            this.themeService.addZippedTheme(executionContext, folderUri, themeName, fileContent);
            String themeUri = folderUri + "/" + themeName;
            boolean isActiveTheme = this.themeService.isActiveThemeFolder(executionContext, themeUri);
        }
        catch (ThemeFolderExistsException ex) {
            this.log.info((Object)"theme folder already exists");
            JSONObject jsonObject = new JSONObject().put("themeExist", (Object)"themeExist");
            JSONObject ret = new JSONConverterBase().createJSONResponse(jsonObject);
            context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)ret.toString());
            return this.success();
        }
        catch (Exception ex) {
            this.log.error((Object)"cannot upload theme", (Throwable)ex);
            String errorMsg = this.messages.getMessage(THEMES_CANNOT_UPLOAD, new Object[]{ex.getMessage()}, LocaleContextHolder.getLocale());
            JSONObject ret = new JSONConverterBase().createErrorJSONResponse(errorMsg);
            context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)ret.toString());
            return this.error();
        }
        return this.success();
    }

    public byte[] getFileContent(RequestContext context) throws Exception {
        MultipartFile multipartFile = context.getRequestParameters().getMultipartFile("themeZip");
        return multipartFile.getBytes();
    }

    public TenantService getTenantService() {
        return this.tenantService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public MessageSource getMessages() {
        return this.messages;
    }

    public void setMessages(MessageSource messages) {
        this.messages = messages;
    }

    public ThemeService getThemeService() {
        return this.themeService;
    }

    public void setThemeService(ThemeService themeService) {
        this.themeService = themeService;
    }

    public ThemeResolver getThemeResolver() {
        return this.themeResolver;
    }

    public void setThemeResolver(ThemeResolver themeResolver) {
        this.themeResolver = themeResolver;
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }
}

