/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.themes;

import com.jaspersoft.jasperserver.war.themes.ThemeCache;
import com.jaspersoft.jasperserver.war.themes.ThemeResource;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ThemeResolverServlet
extends HttpServlet {
    public static final String DATE_FORMAT_PATTERN = "EEE, d MMM yyyy HH:mm:ss z";
    public static final String EXPIRES_AFTER_ACCESS_IN_SECS = "expiresAfterAccessInSecs";
    protected static final Log log = LogFactory.getLog(ThemeResolverServlet.class);
    private ThemeCache themeCache;
    private ServletContext servletContext;
    private int expiresInSecs = 0;
    private static final ThreadLocal<Map<Locale, DateFormat>> lastDateFormat = new ThreadLocal();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String contentType;
        String resPath = req.getRequestURI().substring(req.getContextPath().length() + 1);
        ThemeResource themeResource = this.themeCache.getThemeResource(resPath);
        if (themeResource == null) {
            resp.sendError(404);
            return;
        }
        String filename = resPath;
        if (filename.indexOf("/") >= 0) {
            filename = filename.substring(filename.lastIndexOf("/") + 1);
        }
        if ((contentType = this.servletContext.getMimeType(filename)) == null) {
            log.error((Object)("Cannot detect a response content type for the file : " + filename));
            resp.sendError(404);
            return;
        }
        resp.setContentType(contentType);
        Date lastModified = themeResource.getLastModified();
        lastModified.setTime(lastModified.getTime() / 1000L * 1000L);
        DateFormat df = this.getFormat(req.getLocale());
        resp.setHeader("Cache-Control", "max-age=" + this.expiresInSecs + ", public");
        resp.setHeader("Pragma", "");
        resp.setHeader("Last-Modified", df.format(lastModified));
        resp.setHeader("Expires", df.format(new Date(new Date().getTime() + (long)(this.expiresInSecs * 1000))));
        String ifModSince = req.getHeader("If-Modified-Since");
        try {
            Date modDate = df.parse(ifModSince);
            if (!lastModified.after(modDate)) {
                resp.setStatus(304);
                return;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        resp.setContentLength(themeResource.getContent().length);
        ServletOutputStream os = resp.getOutputStream();
        os.write(themeResource.getContent());
        os.flush();
        os.close();
    }

    private DateFormat getFormat(Locale locale) {
        DateFormat dateFormat;
        Map<Locale, DateFormat> map = lastDateFormat.get();
        if (map == null) {
            map = new HashMap<Locale, DateFormat>();
            lastDateFormat.set(map);
        }
        if ((dateFormat = map.get(locale)) == null) {
            dateFormat = new SimpleDateFormat(DATE_FORMAT_PATTERN, locale);
            map.put(locale, dateFormat);
        }
        return dateFormat;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.servletContext = config.getServletContext();
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)config.getServletContext());
        this.themeCache = (ThemeCache)ctx.getBean("themeCache");
        String value = config.getInitParameter(EXPIRES_AFTER_ACCESS_IN_SECS);
        try {
            this.expiresInSecs = Integer.parseInt(value);
            log.debug((Object)("Expires in seconds set : " + this.expiresInSecs));
        }
        catch (Exception ex) {
            log.error((Object)"expiresAfterAccessInSecs should be a non-negative integer", (Throwable)ex);
        }
    }
}

