/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.model.impl;

import com.jaspersoft.jasperserver.war.model.JSONObject;
import com.jaspersoft.jasperserver.war.model.TreeDataProvider;
import com.jaspersoft.jasperserver.war.model.TreeNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;

public class TreeNodeImpl
implements TreeNode {
    public static final Logger log = Logger.getLogger(TreeNodeImpl.class);
    protected String id;
    protected String label;
    protected String type;
    protected String uri;
    protected String fontStyle;
    protected String fontWeight;
    protected String fontColor;
    protected String cssClass;
    protected int order = Integer.MIN_VALUE;
    protected String tooltip;
    protected JSONObject extraProperty;
    protected List children = new ArrayList();
    protected TreeDataProvider dataProvider;

    public TreeNodeImpl(TreeDataProvider dataProvider, String id, String label, String type, String uri) {
        this.dataProvider = dataProvider;
        this.id = id;
        this.label = label;
        this.type = type;
        this.uri = uri;
    }

    public TreeNodeImpl(TreeDataProvider dataProvider, String id, String label, String type, String uri, int order) {
        this(dataProvider, id, label, type, uri);
        this.order = order;
    }

    public TreeNodeImpl(TreeDataProvider dataProvider, String id, String label, String type, String uri, JSONObject extraProperty) {
        this(dataProvider, id, label, type, uri);
        this.extraProperty = extraProperty;
    }

    public TreeNodeImpl(TreeDataProvider dataProvider, String id, String label, String type, String uri, int order, JSONObject extraProperty) {
        this(dataProvider, id, label, type, uri, order);
        this.extraProperty = extraProperty;
    }

    @Override
    public List getChildren() {
        return this.children;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getUriString() {
        return this.uri;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    @Deprecated
    public String getFontStyle() {
        return this.fontStyle;
    }

    @Override
    @Deprecated
    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
    }

    @Override
    @Deprecated
    public String getFontWeight() {
        return this.fontWeight;
    }

    @Override
    @Deprecated
    public void setFontWeight(String fontWeight) {
        this.fontWeight = fontWeight;
    }

    @Override
    @Deprecated
    public String getFontColor() {
        return this.fontColor;
    }

    @Override
    @Deprecated
    public void setFontColor(String fontColor) {
        this.fontColor = fontColor;
    }

    @Override
    public String getCssClass() {
        return this.cssClass != null ? this.cssClass : "";
    }

    @Override
    public void setCssClass(String cssClassName) {
        this.cssClass = cssClassName;
    }

    @Override
    public String getTooltip() {
        return this.tooltip;
    }

    @Override
    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public JSONObject getExtraProperty() {
        return this.extraProperty;
    }

    public void setExtraProperty(JSONObject extraProperty) {
        this.extraProperty = extraProperty;
    }

    @Override
    public String toJSONString() {
        org.json.JSONObject jsonObject = new org.json.JSONObject();
        try {
            jsonObject.put("id", (Object)this.id);
            jsonObject.put("label", (Object)this.label);
            jsonObject.put("type", (Object)this.type);
            jsonObject.put("uri", (Object)this.uri);
            if (this.fontStyle != null) {
                jsonObject.put("fontStyle", (Object)this.fontStyle);
            }
            if (this.fontWeight != null) {
                jsonObject.put("fontWeight", (Object)this.fontWeight);
            }
            if (this.fontColor != null) {
                jsonObject.put("fontColor", (Object)this.fontColor);
            }
            if (this.cssClass != null) {
                jsonObject.put("cssClass", (Object)this.cssClass);
            }
            if (this.order > Integer.MIN_VALUE) {
                jsonObject.put("order", this.order);
            }
            if (this.tooltip != null) {
                jsonObject.put("tooltip", (Object)this.tooltip);
            }
            if (this.extraProperty != null) {
                jsonObject.put("extra", (Object)new org.json.JSONObject(this.extraProperty.toJSONString()));
            }
            if (!this.children.isEmpty()) {
                JSONArray jsonArray = new JSONArray();
                for (Object child : this.children) {
                    jsonArray.put((Object)new org.json.JSONObject(((TreeNode)child).toJSONString()));
                }
                jsonObject.put("children", (Object)jsonArray);
            }
        }
        catch (JSONException e) {
            log.warn((Object)"Failed to build JSON String", (Throwable)e);
        }
        return jsonObject.toString();
    }

    protected String escape(String str) {
        return str == null ? null : str.replace("\"", "\\\"").replace("<", "&lt;").replace(">", "&gt;").replace("&", "&amp;");
    }

    @Override
    public TreeNode clone(boolean deep) {
        TreeNodeImpl cn = new TreeNodeImpl(this.dataProvider, this.id, this.label, this.type, this.uri, this.order);
        cn.setFontColor(this.fontColor);
        cn.setFontWeight(this.fontWeight);
        cn.setFontWeight(this.fontWeight);
        cn.setCssClass(this.cssClass);
        cn.setTooltip(this.tooltip);
        if (deep) {
            if (this.children != null && this.children.size() > 0) {
                Iterator iter = this.children.iterator();
                while (iter.hasNext()) {
                    TreeNode chClone = ((TreeNode)iter.next()).clone(deep);
                    cn.getChildren().add(chClone);
                }
            }
            if (this.extraProperty != null) {
                cn.setExtraProperty(new ClonedExtraProperty(this.extraProperty.toJSONString()));
            }
        } else {
            cn.extraProperty = this.extraProperty;
            cn.children = new ArrayList(this.children);
        }
        return cn;
    }

    static class ClonedExtraProperty
    implements JSONObject {
        String json;

        public ClonedExtraProperty(String json) {
            this.json = json;
        }

        @Override
        public String toJSONString() {
            return this.json;
        }
    }
}

