/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.model.impl;

import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.war.model.TreeDataFilter;
import com.jaspersoft.jasperserver.war.model.TreeNode;
import java.util.List;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.context.SecurityContextHolder;

public class RepositoryExplorerTreeDataFilterImpl
implements TreeDataFilter {
    private List uriList;
    private UserAuthorityService userService;
    private String roleToShowTempFolder;

    @Override
    public boolean filter(TreeNode node) {
        if (this.uriList != null) {
            String nodeUri = node.getUriString();
            for (String uri : this.uriList) {
                if (!nodeUri.equalsIgnoreCase(uri) && nodeUri.indexOf(uri + "/") != 0) continue;
                Authentication existingAuth = SecurityContextHolder.getContext().getAuthentication();
                GrantedAuthority[] grantedAuthorities = existingAuth.getAuthorities();
                if (grantedAuthorities != null) {
                    for (GrantedAuthority grantedAuthority : grantedAuthorities) {
                        if (!this.roleToShowTempFolder.equals(grantedAuthority.getAuthority())) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        return true;
    }

    public List getUriList() {
        return this.uriList;
    }

    public void setUriList(List uriList) {
        this.uriList = uriList;
    }

    public UserAuthorityService getUserService() {
        return this.userService;
    }

    public void setUserService(UserAuthorityService service) {
        this.userService = service;
    }

    public String getRoleToShowTempFolder() {
        return this.roleToShowTempFolder;
    }

    public void setRoleToShowTempFolder(String folder) {
        this.roleToShowTempFolder = folder;
    }
}

