/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.model.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.war.model.TreeDataProvider;
import com.jaspersoft.jasperserver.war.model.TreeNode;
import com.jaspersoft.jasperserver.war.model.impl.BaseTreeDataProvider;
import com.jaspersoft.jasperserver.war.model.impl.TreeNodeImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class FileResourcesTreeDataProvider
extends BaseTreeDataProvider {
    private static final Logger log = Logger.getLogger(FileResourcesTreeDataProvider.class);
    private List<String> fileTypes;

    @Override
    protected TreeNode createRoot(ExecutionContext executionContext) {
        ArrayList<ResourceLookup> lookups = new ArrayList<ResourceLookup>();
        for (String fileType : this.fileTypes) {
            FilterCriteria criteria = FilterCriteria.createFilter(FileResource.class);
            criteria.addFilterElement((FilterElement)FilterCriteria.createPropertyEqualsFilter((String)"fileType", (Object)fileType));
            ResourceLookup[] lookupsArray = this.getRepositoryService().findResource(executionContext, criteria);
            if (lookupsArray == null) continue;
            lookups.addAll(Arrays.asList(lookupsArray));
        }
        Folder rootFolder = this.getRepositoryService().getFolder(executionContext, "/");
        TreeNodeImpl root = new TreeNodeImpl((TreeDataProvider)this, rootFolder.getName(), rootFolder.getLabel(), rootFolder.getResourceType(), rootFolder.getURIString(), 1);
        for (ResourceLookup realm : lookups) {
            TreeNode parent = this.getParentFolderNode(root, realm.getURIString());
            parent.getChildren().add(new TreeNodeImpl(this, realm.getName(), realm.getLabel(), realm.getResourceType(), realm.getURIString()));
        }
        return root;
    }

    public void setFileTypes(List<String> fileTypes) {
        this.fileTypes = fileTypes;
    }
}

