/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.mail.impl;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.util.CharacterEncodingProvider;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.war.mail.MailService;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class MailServiceImpl
implements MailService {
    private static final Log log = LogFactory.getLog(MailServiceImpl.class);
    private JavaMailSender javaMailSender;
    private String mailFromAddress;
    private UserAuthorityService userAuthorityService;
    private CharacterEncodingProvider encodingProvider;

    @Override
    public void sendEmailNotification(String subject, String body, String mailTo) {
        try {
            MimeMessage message = this.javaMailSender.createMimeMessage();
            MimeMessageHelper messageHelper = new MimeMessageHelper(message, true, this.encodingProvider.getCharacterEncoding());
            messageHelper.setFrom(this.mailFromAddress);
            messageHelper.setSubject(subject);
            StringBuffer messageText = new StringBuffer();
            messageText.append(body);
            messageHelper.setTo(mailTo);
            messageHelper.setText(messageText.toString());
            this.javaMailSender.send(message);
        }
        catch (MessagingException e) {
            log.error((Object)"Error while sending mail", (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    public CharacterEncodingProvider getEncodingProvider() {
        return this.encodingProvider;
    }

    public void setEncodingProvider(CharacterEncodingProvider encodingProvider) {
        this.encodingProvider = encodingProvider;
    }

    public JavaMailSender getJavaMailSender() {
        return this.javaMailSender;
    }

    public void setJavaMailSender(JavaMailSender javaMailSender) {
        this.javaMailSender = javaMailSender;
    }

    public String getMailFromAddress() {
        return this.mailFromAddress;
    }

    public void setMailFromAddress(String mailFromAddress) {
        this.mailFromAddress = mailFromAddress;
    }

    public UserAuthorityService getUserAuthorityService() {
        return this.userAuthorityService;
    }

    public void setUserAuthorityService(UserAuthorityService userAuthorityService) {
        this.userAuthorityService = userAuthorityService;
    }
}

