/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.helper;

import com.jaspersoft.jasperserver.api.metadata.user.domain.ProfileAttribute;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.RoleImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.UserImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONHelper {
    protected static final String AJAX_RESPONSE_SUCCESS = "success";
    protected static final String ERROR_TITLE = "title";
    protected static final String ERROR_MESSAGE = "message";
    protected static final String ERROR_DESC = "description";
    protected static final String USER_USER_NAME = "userName";
    protected static final String USER_FULL_NAME = "fullName";
    public static final String USER_PASSWORD = "password";
    protected static final String USER_EMAIL = "email";
    protected static final String USER_ENABLED = "enabled";
    protected static final String USER_EXTERNAL = "external";
    protected static final String USER_ROLES = "roles";
    protected static final String USER_ATTRIBUTES = "attributes";
    protected static final String USER_TENANT_ID = "tenantId";
    protected static final String ATTRIBUTE_NAME = "name";
    protected static final String ATTRIBUTE_VALUE = "value";
    protected static final String ROLE_ROLE_NAME = "roleName";
    protected static final String ROLE_EXTERNAL = "external";
    protected static final String ROLE_TENANT_ID = "tenantId";
    public static final String EXIST = "exist";
    protected static final String ENTITIES = "entities";

    protected String getPropertyIfHas(JSONObject userJson, String property) throws JSONException {
        if (userJson.has(property)) {
            return userJson.getString(property);
        }
        return null;
    }

    protected JSONObject getJsonObjectIfHas(JSONObject userJson, String property) throws JSONException {
        if (userJson.has(property)) {
            return userJson.getJSONObject(property);
        }
        return null;
    }

    public JSONObject createUnexpectedExceptionJson(String title, String message, String errorDescription) throws JSONException {
        JSONObject errorObject = new JSONObject();
        errorObject.put(ERROR_TITLE, (Object)title);
        errorObject.put(ERROR_MESSAGE, (Object)message);
        errorObject.put(ERROR_DESC, (Object)errorDescription);
        return errorObject;
    }

    public String createDataResponseModel(JSONObject data) throws JSONException {
        JSONObject responseModel = new JSONObject();
        responseModel.put("data", (Object)data);
        return responseModel.toString();
    }

    public String createErrorResponseModel(JSONObject error) throws JSONException {
        JSONObject responseModel = new JSONObject();
        responseModel.put("data", (Object)new JSONObject());
        if (error != null) {
            responseModel.put("error", (Object)error);
        }
        return responseModel.toString();
    }

    public String createSuccessResponseModel() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("status", (Object)AJAX_RESPONSE_SUCCESS);
        return this.createDataResponseModel(json);
    }

    public JSONObject createRolesResponseJson(List roles) throws JSONException {
        JSONObject data = new JSONObject();
        data.put(ENTITIES, (Object)this.convertRoleListToJson(roles, new String[]{ROLE_ROLE_NAME, "tenantId"}));
        return data;
    }

    public JSONObject createExistJson(boolean isRoleExist) throws JSONException {
        JSONObject isUserExistJson = new JSONObject();
        isUserExistJson.put(EXIST, isRoleExist);
        return isUserExistJson;
    }

    public JSONObject convertRoleToJson(Role user, String[] fields) throws JSONException {
        String roleName = user.getRoleName();
        Boolean external = user.isExternallyDefined();
        String tenantId = user.getTenantId();
        String[] allUserFields = new String[]{ROLE_ROLE_NAME, "external", "tenantId"};
        Object[] allFieldValues = new Object[]{roleName, external, tenantId};
        List<String> convertFields = fields != null ? Arrays.asList(fields) : Arrays.asList(allUserFields);
        JSONObject roleJson = new JSONObject();
        for (int i = 0; i < allUserFields.length; ++i) {
            String userField = allUserFields[i];
            Object fieldValue = allFieldValues[i];
            if (!convertFields.contains(userField)) continue;
            roleJson.put(userField, fieldValue);
        }
        return roleJson;
    }

    public JSONArray convertRoleListToJson(List roleList, String[] fields) throws JSONException {
        JSONArray userListJson = new JSONArray();
        for (Object aRoleList : roleList) {
            Role role = (Role)aRoleList;
            userListJson.put((Object)this.convertRoleToJson(role, fields));
        }
        return userListJson;
    }

    public Role convertJsonToRole(JSONObject roleJson) throws JSONException {
        JSONArray userJson;
        RoleImpl role = new RoleImpl();
        role.setRoleName(this.getPropertyIfHas(roleJson, ROLE_ROLE_NAME));
        role.setTenantId(this.getPropertyIfHas(roleJson, "tenantId"));
        String external = this.getPropertyIfHas(roleJson, "external");
        role.setExternallyDefined(external != null ? Boolean.valueOf(external) : false);
        if (roleJson.has(ENTITIES) && (userJson = roleJson.getJSONArray(ENTITIES)) != null && userJson.length() > 0) {
            for (int i = 0; i < userJson.length(); ++i) {
                User user = this.convertJsonToUser(userJson.getJSONObject(i));
                role.addUser(user);
            }
        }
        return role;
    }

    public Role convertJsonToRole(String json) throws JSONException {
        return this.convertJsonToRole(new JSONObject(json));
    }

    public Set<Role> convertJsonArrayToRoles(String json) throws JSONException {
        JSONArray array = new JSONArray(json);
        HashSet<Role> roles = new HashSet<Role>();
        for (int i = 0; i < array.length(); ++i) {
            roles.add(this.convertJsonToRole(array.getJSONObject(i)));
        }
        return roles;
    }

    public Set<User> convertJsonArrayToUsers(String json) throws JSONException {
        JSONArray array = new JSONArray(json);
        HashSet<User> users = new HashSet<User>();
        for (int i = 0; i < array.length(); ++i) {
            users.add(this.convertJsonToUser(array.getJSONObject(i)));
        }
        return users;
    }

    public JSONObject createUsersResponseJson(List users) throws JSONException {
        JSONObject data = new JSONObject();
        data.put(ENTITIES, (Object)this.convertUserListToJson(users, new String[]{USER_USER_NAME, USER_FULL_NAME, "tenantId", USER_ENABLED}));
        return data;
    }

    public JSONObject createEmptyUserListResponseJson() throws JSONException {
        ArrayList<UserImpl> tempUserList = new ArrayList<UserImpl>();
        UserImpl tempUser = new UserImpl();
        tempUser.setFullName("");
        tempUser.setEmailAddress("");
        tempUser.setPassword("");
        tempUser.setEnabled(false);
        tempUser.setExternallyDefined(false);
        tempUserList.add(tempUser);
        return this.createUsersResponseJson(tempUserList);
    }

    public JSONObject convertUserToJson(User user, String[] fields) throws JSONException {
        String userName = user.getUsername();
        String fullName = user.getFullName() != null ? user.getFullName() : "";
        String emailAddress = user.getEmailAddress() != null ? user.getEmailAddress() : "";
        Boolean enabled = user.isEnabled();
        Boolean external = user.isExternallyDefined();
        String tenantId = user.getTenantId();
        ArrayList roles = user.getRoles() != null ? new ArrayList(user.getRoles()) : Collections.emptyList();
        JSONArray attributes = this.convertUserAttributesToJson(user.getAttributes());
        JSONArray rolesJson = this.convertRoleListToJson(roles, new String[]{ROLE_ROLE_NAME, "external", "tenantId"});
        String[] allUserFields = new String[]{USER_USER_NAME, USER_FULL_NAME, USER_EMAIL, USER_ENABLED, USER_ROLES, "tenantId", "external", USER_ATTRIBUTES};
        Object[] allFieldValues = new Object[]{userName, fullName, emailAddress, enabled, rolesJson, tenantId, external, attributes};
        List<String> convertFields = fields != null ? Arrays.asList(fields) : Arrays.asList(allUserFields);
        JSONObject userJson = new JSONObject();
        for (int i = 0; i < allUserFields.length; ++i) {
            String userField = allUserFields[i];
            Object fieldValue = allFieldValues[i];
            if (!convertFields.contains(userField)) continue;
            userJson.put(userField, fieldValue);
        }
        return userJson;
    }

    public JSONArray convertUserAttributesToJson(List userAttributes) throws JSONException {
        List attributes = userAttributes != null ? userAttributes : new ArrayList();
        JSONArray attributesJson = new JSONArray();
        for (Object attribute1 : attributes) {
            ProfileAttribute attribute = (ProfileAttribute)attribute1;
            JSONObject attributeJson = new JSONObject();
            attributeJson.put(ATTRIBUTE_NAME, (Object)attribute.getAttrName());
            attributeJson.put(ATTRIBUTE_VALUE, (Object)attribute.getAttrValue());
            attributesJson.put((Object)attributeJson);
        }
        return attributesJson;
    }

    public JSONArray convertUserListToJson(List userList, String[] fields) throws JSONException {
        JSONArray userListJson = new JSONArray();
        for (Object anUserList : userList) {
            User user = (User)anUserList;
            userListJson.put((Object)this.convertUserToJson(user, fields));
        }
        return userListJson;
    }

    public User convertJsonToUser(String json) throws JSONException {
        return this.convertJsonToUser(new JSONObject(json));
    }

    public User convertJsonToUser(JSONObject userJson) throws JSONException {
        JSONArray rolesJson;
        UserImpl user = new UserImpl();
        user.setUsername(this.getPropertyIfHas(userJson, USER_USER_NAME));
        user.setFullName(this.getPropertyIfHas(userJson, USER_FULL_NAME));
        user.setEmailAddress(this.getPropertyIfHas(userJson, USER_EMAIL));
        String enabled = this.getPropertyIfHas(userJson, USER_ENABLED);
        user.setEnabled(enabled != null ? Boolean.valueOf(enabled) : false);
        String external = this.getPropertyIfHas(userJson, "external");
        user.setExternallyDefined(external != null ? Boolean.valueOf(external) : false);
        user.setPassword(this.getPropertyIfHas(userJson, USER_PASSWORD));
        user.setTenantId(this.getPropertyIfHas(userJson, "tenantId"));
        if (userJson.has(USER_ROLES) && (rolesJson = userJson.getJSONArray(USER_ROLES)) != null && rolesJson.length() > 0) {
            for (int i = 0; i < rolesJson.length(); ++i) {
                Role role = this.convertJsonToRole(rolesJson.getJSONObject(i));
                user.addRole(role);
            }
        }
        return user;
    }
}

