/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.control;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.MessageUtil;
import net.sf.jasperreports.web.util.VelocityUtil;
import net.sf.jasperreports.web.util.WebUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.Controller;
import org.springframework.web.servlet.view.AbstractView;

public class ReportResourceController
implements Controller {
    private static final Log log = LogFactory.getLog(ReportResourceController.class);
    private JasperReportsContext jasperReportsContext;
    private List<Pattern> resourcePatterns;

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws JRException {
        byte[] data = null;
        String mimeType = null;
        WebUtil webUtil = WebUtil.getInstance((JasperReportsContext)this.getJasperReportsContext());
        String resourceName = webUtil.getResourceUri(request);
        this.checkResourceName(resourceName);
        boolean isDynamicResource = webUtil.isDynamicResource(request);
        String resourceBundleName = webUtil.getResourceBundleForResource(request);
        Locale locale = webUtil.getResourceLocale(request);
        if (resourceName != null && resourceName.indexOf(".vm.") != -1 && (isDynamicResource || resourceBundleName != null || locale != null)) {
            HashMap<String, String> contextMap = new HashMap<String, String>();
            contextMap.put("path", request.getContextPath() + webUtil.getResourcesBasePath());
            locale = locale == null ? Locale.getDefault() : locale;
            contextMap.put("msgProvider", (String)MessageUtil.getInstance((JasperReportsContext)this.getJasperReportsContext()).getLocalizedMessageProvider(resourceBundleName, locale));
            String resourceString = VelocityUtil.processTemplate((String)resourceName, contextMap);
            if (resourceString != null) {
                try {
                    data = resourceString.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (resourceName != null) {
            data = JRLoader.loadBytesFromResource((String)resourceName);
        }
        if (resourceName.endsWith(".js")) {
            response.setContentType("text/javascript; charset=UTF-8");
        } else if (resourceName.endsWith(".css")) {
            response.setContentType("text/css");
        }
        ResourceView view = new ResourceView(mimeType, data);
        return new ModelAndView((View)view);
    }

    protected void checkResourceName(String resourceName) {
        boolean matched = false;
        for (Pattern resourcePattern : this.resourcePatterns) {
            if (!resourcePattern.matcher(resourceName).matches()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("resource " + resourceName + " matched pattern " + resourcePattern));
            }
            matched = true;
            break;
        }
        if (!matched) {
            throw new JRRuntimeException("Resource " + resourceName + " does not matched any allowed pattern");
        }
    }

    public JasperReportsContext getJasperReportsContext() {
        return this.jasperReportsContext;
    }

    public void setJasperReportsContext(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public List<Pattern> getResourcePatterns() {
        return this.resourcePatterns;
    }

    public void setResourcePatterns(List<Pattern> resourcePatterns) {
        this.resourcePatterns = resourcePatterns;
    }

    protected static class ResourceView
    extends AbstractView {
        private final String mimeType;
        private final byte[] data;

        public ResourceView(String mimeType, byte[] data) {
            this.mimeType = mimeType;
            this.data = data;
        }

        protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
            if (this.data != null && this.data.length > 0) {
                if (this.mimeType != null) {
                    response.setHeader("Content-Type", this.mimeType);
                }
                response.setContentLength(this.data.length);
                ServletOutputStream ouputStream = response.getOutputStream();
                ouputStream.write(this.data, 0, this.data.length);
                ouputStream.flush();
                ouputStream.close();
            } else {
                response.getOutputStream().close();
            }
        }
    }
}

