/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.control;

import com.jaspersoft.jasperserver.api.common.properties.Log4jPropertyChanger;
import com.jaspersoft.jasperserver.api.common.properties.PropertiesManagementService;
import com.jaspersoft.jasperserver.api.logging.diagnostic.service.impl.LogSettingsDiagnosticService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class LogSettingsController
implements Controller,
ResourceLoaderAware,
InitializingBean {
    static final String PROPERTY_PREFIX = "log4j.";
    private static Logger log = Logger.getLogger(LogSettingsController.class);
    private Map<Locale, Map<String, String>> loggerDescriptionsByLocale = Collections.synchronizedMap(new HashMap());
    private Map<String, String> loggers = Collections.synchronizedMap(new LinkedHashMap());
    private List<String> loggerDescriptionFiles;
    private ResourceLoader resourceLoader;
    private MessageSource messageSource;
    protected PropertiesManagementService propertiesManagementService;
    protected LogSettingsDiagnosticService logSettingsDiagnosticService;

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String loggerArg = request.getParameter("logger");
        String levelArg = request.getParameter("level");
        if (loggerArg != null && levelArg != null) {
            this.getPropertiesManagementService().setProperty(PROPERTY_PREFIX + loggerArg, levelArg);
            this.loggers.put(loggerArg, levelArg);
        }
        this.loggers = Collections.synchronizedMap(new LinkedHashMap());
        this.afterPropertiesSet();
        ModelAndView mav = new ModelAndView("modules/administer/logSettings");
        mav.addObject("loggers", this.loggers);
        mav.addObject("loggerDesc", this.loggerDescriptionsByLocale.get(LocaleContextHolder.getLocale()));
        return mav;
    }

    private void initLoggersFromPropFiles() {
        if (this.loggers.isEmpty()) {
            if (this.loggerDescriptionFiles == null || this.loggerDescriptionFiles.isEmpty()) {
                throw new IllegalStateException("No logger description files specified.");
            }
            for (String file : this.loggerDescriptionFiles) {
                try {
                    String props = this.loadWebappFile(file);
                    if (props == null) continue;
                    Properties p = new Properties();
                    p.load(new ByteArrayInputStream(props.getBytes()));
                    for (Object key : p.keySet()) {
                        this.loggers.put((String)key, null);
                    }
                }
                catch (IOException e) {
                    log.warn((Object)"problem loading log descriptions", (Throwable)e);
                }
            }
        }
    }

    private void initLocalizedDescriptions() {
        Locale locale = LocaleContextHolder.getLocale();
        if (!this.loggerDescriptionsByLocale.containsKey(locale)) {
            LinkedHashMap<String, String> loggerDescriptions = new LinkedHashMap<String, String>();
            for (String key : this.loggers.keySet()) {
                loggerDescriptions.put(key, this.messageSource.getMessage(key, null, "", locale));
            }
            this.loggerDescriptionsByLocale.put(locale, loggerDescriptions);
        }
    }

    private String loadWebappFile(String path) throws IOException {
        int n;
        Resource test = this.resourceLoader.getResource(path);
        InputStream is = test.getInputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        while ((n = is.read(bytes)) > 0) {
            baos.write(bytes, 0, n);
        }
        return baos.toString();
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setLoggerDescriptionFiles(List<String> loggerDescriptionFiles) {
        this.loggerDescriptionFiles = loggerDescriptionFiles;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public PropertiesManagementService getPropertiesManagementService() {
        return this.propertiesManagementService;
    }

    public void setPropertiesManagementService(PropertiesManagementService propertiesManagementService) {
        this.propertiesManagementService = propertiesManagementService;
    }

    public void setLogSettingsDiagnosticService(LogSettingsDiagnosticService logSettingsDiagnosticService) {
        this.logSettingsDiagnosticService = logSettingsDiagnosticService;
    }

    public void afterPropertiesSet() throws Exception {
        this.initLoggersFromPropFiles();
        this.initLocalizedDescriptions();
        for (String logKey : this.loggers.keySet()) {
            Logger log = Logger.getLogger((String)logKey);
            String level = log.getEffectiveLevel().toString();
            this.loggers.put(logKey, level);
        }
        this.updateLoggersFromPropMgmtService();
        this.logSettingsDiagnosticService.initLoggers(this.loggers);
    }

    private void updateLoggersFromPropMgmtService() {
        for (Map.Entry entry : this.getPropertiesManagementService().entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(PROPERTY_PREFIX)) continue;
            this.loggers.put(Log4jPropertyChanger.parseKey((String)key), (String)entry.getValue());
        }
    }
}

