/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.common;

import com.jaspersoft.jasperserver.api.engine.jasperreports.util.AwsEc2MetadataClient;
import com.jaspersoft.jasperserver.war.common.HeartbeatContributor;
import org.apache.commons.httpclient.methods.PostMethod;

public class HeartbeatAwsEc2Contributor
implements HeartbeatContributor {
    protected AwsEc2MetadataClient awsEc2MetadataClient;
    private String ceProductCode;
    public static String CE = "CE";
    public static String NOT_EC2 = "NOT_EC2";
    public static String AMI = "AMI";
    public static String EC2 = "EC2";

    @Override
    public void contributeToHttpCall(PostMethod post) {
        String awsEc2Instance;
        if (this.awsEc2MetadataClient.isEc2Instance()) {
            String awsEc2InstanceType = this.awsEc2MetadataClient.getEc2InstanceMetadataItem("/latest/meta-data/instance-type");
            awsEc2Instance = this.generateAwsInstanceInfo(true);
            post.addParameter("ec2InstanceType", awsEc2InstanceType);
        } else {
            awsEc2Instance = this.generateAwsInstanceInfo(false);
        }
        post.addParameter("ec2Instance", awsEc2Instance);
    }

    protected String generateAwsInstanceInfo(Boolean isEc2Instance) {
        if (isEc2Instance.booleanValue()) {
            if (this.hasJSAwsProductCode().booleanValue()) {
                return AMI + "_" + this.getServerEdition();
            }
            return EC2;
        }
        return NOT_EC2;
    }

    protected String getServerEdition() {
        return CE;
    }

    protected Boolean hasJSAwsProductCode() {
        return this.awsEc2MetadataClient.hasAwsProductCode(this.ceProductCode);
    }

    public void setAwsEc2MetadataClient(AwsEc2MetadataClient awsEc2MetadataClient) {
        this.awsEc2MetadataClient = awsEc2MetadataClient;
    }

    public void setCeProductCode(String ceProductCode) {
        this.ceProductCode = ceProductCode;
    }
}

