/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade.handlers.converters;

import com.jaspersoft.jasperserver.api.common.util.rd.DateRangeFactory;
import com.jaspersoft.jasperserver.war.cascade.handlers.converters.DataConverter;
import com.jaspersoft.jasperserver.war.cascade.handlers.converters.DateRangeDataConverter;
import com.jaspersoft.jasperserver.war.cascade.handlers.converters.TimestampDataConverter;
import com.jaspersoft.jasperserver.war.util.CalendarFormatProvider;
import java.sql.Timestamp;
import javax.annotation.Resource;
import net.sf.jasperreports.types.date.DateRangeExpression;
import net.sf.jasperreports.types.date.TimestampRange;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class TimestampRangeDataConverter
implements DataConverter<TimestampRange> {
    @Resource(name="messagesCalendarFormatProvider")
    protected CalendarFormatProvider calendarFormatProvider;

    @Override
    public TimestampRange stringToValue(String rawData) throws Exception {
        if (StringUtils.isEmpty((String)rawData)) {
            return null;
        }
        return (TimestampRange)DateRangeFactory.getInstance((String)rawData, Timestamp.class, (String)DateRangeDataConverter.getStringDatePattern(this.calendarFormatProvider.getDatetimeFormat()));
    }

    @Override
    public String valueToString(TimestampRange value) {
        if (value == null) {
            return "";
        }
        if (value instanceof DateRangeExpression) {
            return ((DateRangeExpression)value).getExpression();
        }
        return TimestampDataConverter.getDateFormatWithTimeZone(this.calendarFormatProvider.getDatetimeFormat()).format(value.getStart());
    }
}

