/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade.handlers.converters;

import com.jaspersoft.jasperserver.war.cascade.handlers.converters.DataConverter;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class NumberDataConverter
implements DataConverter<Number> {
    @Override
    public String valueToString(Number value) {
        if (value == null) {
            return "";
        }
        DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(LocaleContextHolder.getLocale());
        df.setGroupingUsed(false);
        df.setMaximumFractionDigits(Integer.MAX_VALUE);
        return df.format(value);
    }

    @Override
    public Number stringToValue(String rawData) throws ParseException {
        return rawData != null && !"".equals(rawData) ? new BigDecimal(rawData.replace(",", ".")).stripTrailingZeros() : null;
    }
}

