/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sf.jasperreports.engine.ReportContext;
import org.springframework.binding.collection.MapAdaptable;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.execution.RequestContext;

public class WebflowReportContext
implements ReportContext {
    private static final String SESSION_ATTRIBUTE_REPORT_CONTEXT_ID_PREFIX = "net.sf.jasperreports.web.report.context_";
    public static final String PARAMETER_FLOW_REPORT_CONTEXT = "rptCtx";
    public static final String REQUEST_PARAMETER_REPORT_CONTEXT_ID = "jr.ctxid";
    public static final String REPORT_CONTEXT_PARAMETER_JASPER_PRINT = "net.sf.jasperreports.web.jasper_print";
    public static final String REPORT_CONTEXT_PARAMETER_JASPER_REPORT = "net.sf.jasperreports.web.jasper_report";
    private Map<String, Object> requestParameters;
    private Map<String, Object> requestAttributes;
    private Map<String, Object> flowAttributes;
    private Map<String, Object> parameterValues = new HashMap<String, Object>();
    private Map flowValues;
    private String id;

    public static final WebflowReportContext getInstance(RequestContext requestContext) {
        return WebflowReportContext.getInstance(requestContext, true);
    }

    public static final WebflowReportContext getInstance(Map flowValues) {
        WebflowReportContext webflowReportContext = new WebflowReportContext();
        webflowReportContext.setFlowValues(flowValues);
        return webflowReportContext;
    }

    public static final void initFlowScope(RequestContext requestContext) {
        HashMap flowValues = new HashMap();
        requestContext.getRequestParameters().asMap();
        flowValues.putAll(requestContext.getRequestParameters().asMap());
        Map oldFlowMap = (Map)requestContext.getFlowScope().get(PARAMETER_FLOW_REPORT_CONTEXT);
        if (oldFlowMap != null) {
            flowValues.put(REQUEST_PARAMETER_REPORT_CONTEXT_ID, oldFlowMap.get(REQUEST_PARAMETER_REPORT_CONTEXT_ID));
        }
        requestContext.getFlowScope().put(PARAMETER_FLOW_REPORT_CONTEXT, flowValues);
    }

    public static final WebflowReportContext getInstance(RequestContext requestContext, boolean create) {
        ExternalContext ec = requestContext.getExternalContext();
        HttpServletRequest request = (HttpServletRequest)ec.getNativeRequest();
        HttpSession session = request.getSession();
        WebflowReportContext webflowReportContext = null;
        Map flowMap = (Map)requestContext.getFlowScope().get(PARAMETER_FLOW_REPORT_CONTEXT);
        String reportContextId = null;
        if (flowMap != null) {
            reportContextId = (String)flowMap.get(REQUEST_PARAMETER_REPORT_CONTEXT_ID);
        }
        if (reportContextId != null) {
            webflowReportContext = (WebflowReportContext)session.getAttribute(WebflowReportContext.getSessionAttributeName(reportContextId));
        }
        if (webflowReportContext == null) {
            webflowReportContext = new WebflowReportContext();
            session.setAttribute(webflowReportContext.getSessionAttributeName(), (Object)webflowReportContext);
            if (flowMap != null) {
                flowMap.put(REQUEST_PARAMETER_REPORT_CONTEXT_ID, webflowReportContext.getId());
                requestContext.getFlowScope().put(PARAMETER_FLOW_REPORT_CONTEXT, (Object)flowMap);
            }
        }
        if (webflowReportContext != null) {
            webflowReportContext.setRequestContext(requestContext);
            webflowReportContext.setFlowValues(flowMap);
            webflowReportContext.setParameterValue("REPORT_CONTEXT", webflowReportContext);
        }
        return webflowReportContext;
    }

    public static final WebflowReportContext getInstance(HttpSession session, Map flowMap) {
        WebflowReportContext webflowReportContext = null;
        String reportContextId = null;
        if (flowMap != null) {
            reportContextId = (String)flowMap.get(REQUEST_PARAMETER_REPORT_CONTEXT_ID);
        }
        if (reportContextId != null) {
            webflowReportContext = (WebflowReportContext)session.getAttribute(WebflowReportContext.getSessionAttributeName(reportContextId));
        }
        if (webflowReportContext == null) {
            webflowReportContext = new WebflowReportContext();
            webflowReportContext.setFlowValues(flowMap);
            webflowReportContext.setParameterValue("REPORT_CONTEXT", webflowReportContext);
            session.setAttribute(webflowReportContext.getSessionAttributeName(), (Object)webflowReportContext);
        }
        return webflowReportContext;
    }

    private WebflowReportContext() {
        this.parameterValues.put("REPORT_CONTEXT", this);
    }

    public String getId() {
        if (this.id == null) {
            this.id = String.valueOf(System.currentTimeMillis());
        }
        return this.id;
    }

    public void setRequestContext(RequestContext request) {
        this.requestParameters = this.copyContextMap((MapAdaptable)request.getRequestParameters());
        this.requestAttributes = this.copyContextMap((MapAdaptable)request.getRequestScope());
        this.flowAttributes = this.copyContextMap((MapAdaptable)request.getFlowScope());
    }

    protected Map<String, Object> copyContextMap(MapAdaptable contextMapAdaptable) {
        Map contextMap;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (contextMapAdaptable != null && (contextMap = contextMapAdaptable.asMap()) != null) {
            for (Map.Entry entry : contextMap.entrySet()) {
                map.put(String.valueOf(entry.getKey()), entry.getValue());
            }
        }
        return map;
    }

    public Map getFlowValues() {
        return this.flowValues;
    }

    public void setFlowValues(Map flowValues) {
        this.flowValues = flowValues;
    }

    public String getSessionAttributeName() {
        return WebflowReportContext.getSessionAttributeName(this.getId());
    }

    public Object getParameterValue(String parameterName) {
        Object requestParameterValue = null;
        if (this.requestParameters != null && (requestParameterValue = this.requestParameters.get(parameterName)) != null) {
            return requestParameterValue;
        }
        if (this.requestAttributes != null && (requestParameterValue = this.requestAttributes.get(parameterName)) != null) {
            return requestParameterValue;
        }
        if (this.flowAttributes != null && (requestParameterValue = this.flowAttributes.get(parameterName)) != null) {
            return requestParameterValue;
        }
        if (this.flowValues != null && (requestParameterValue = this.flowValues.get(parameterName)) != null) {
            return requestParameterValue;
        }
        return this.parameterValues.get(parameterName);
    }

    public boolean containsParameter(String parameterName) {
        boolean contains = this.requestParameters != null && this.requestParameters.containsKey(parameterName);
        return contains ? contains : this.parameterValues.containsKey(parameterName);
    }

    public void setParameterValue(String parameterName, Object value) {
        this.parameterValues.put(parameterName, value);
    }

    public void setParameterValues(Map<String, Object> newValues) {
        this.parameterValues.putAll(newValues);
    }

    public Map<String, Object> getParameterValues() {
        return this.parameterValues;
    }

    private static final String getSessionAttributeName(String id) {
        return SESSION_ATTRIBUTE_REPORT_CONTEXT_ID_PREFIX + id;
    }
}

