/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportSchedulingService;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import java.util.List;
import javax.annotation.Resource;
import org.json.JSONObject;
import org.springframework.context.MessageSource;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ReportSchedulingListAction
extends MultiAction {
    public static final String AJAX_RESPONSE_MODEL = "ajaxResponseModel";
    private String reportUnitURIAttrName;
    private String jobListAttrName;
    private String selectedJobsParamName;
    private String attributeOwnerURI;
    private ReportSchedulingService schedulingService;
    @Resource
    protected MessageSource messages;

    public ReportSchedulingService getSchedulingService() {
        return this.schedulingService;
    }

    public void setSchedulingService(ReportSchedulingService schedulingService) {
        this.schedulingService = schedulingService;
    }

    public String getJobListAttrName() {
        return this.jobListAttrName;
    }

    public void setJobListAttrName(String jobListAttrName) {
        this.jobListAttrName = jobListAttrName;
    }

    public String getReportUnitURIAttrName() {
        return this.reportUnitURIAttrName;
    }

    public void setReportUnitURIAttrName(String reportUnitURIAttrName) {
        this.reportUnitURIAttrName = reportUnitURIAttrName;
    }

    public String getSelectedJobsParamName() {
        return this.selectedJobsParamName;
    }

    public void setSelectedJobsParamName(String selectedJobsParamName) {
        this.selectedJobsParamName = selectedJobsParamName;
    }

    public Event listJobs(RequestContext context) {
        this.setRequestErrorMessage(context);
        List jobs = this.loadJobList(context);
        context.getRequestScope().put(this.getJobListAttrName(), (Object)jobs);
        context.getRequestScope().put(this.getAttributeOwnerURI(), (Object)this.getOwnerURI(context));
        return this.success();
    }

    public Event formatException(RequestContext context) {
        String formattedMsg;
        Exception e = (Exception)context.getFlashScope().get("rootCauseException");
        if (e instanceof JSException) {
            ExecutionContext ctx = this.getExecutionContext(context);
            formattedMsg = this.messages.getMessage(e.getMessage(), ((JSException)((Object)e)).getArgs(), ctx.getLocale());
        } else {
            formattedMsg = e.getMessage();
        }
        context.getRequestScope().put("errorPopupMessage", (Object)formattedMsg);
        return this.success();
    }

    protected String getOwnerURI(RequestContext context) {
        return context.getFlowScope().getRequiredString(this.getReportUnitURIAttrName());
    }

    protected List loadJobList(RequestContext context) {
        String reportUnitURI = context.getFlowScope().getString(this.getReportUnitURIAttrName());
        if (reportUnitURI == null) {
            reportUnitURI = (String)context.getRequestScope().get("reportUnitURI");
        }
        List jobs = this.schedulingService.getScheduledJobSummaries(this.getExecutionContext(context), reportUnitURI);
        return jobs;
    }

    protected void setRequestErrorMessage(RequestContext context) {
        MutableAttributeMap flowScope = context.getFlowScope();
        if (flowScope.contains("errorMessage")) {
            String message = (String)flowScope.remove("errorMessage");
            Object args = flowScope.remove("errorArguments");
            MutableAttributeMap requestScope = context.getRequestScope();
            requestScope.put("errorMessage", (Object)message);
            requestScope.put("errorArguments", args);
        }
    }

    public Event deleteJobs(RequestContext context) throws Exception {
        String jobId = context.getRequestParameters().get(this.getSelectedJobsParamName());
        if (jobId != null && jobId.length() > 0) {
            long id = Long.parseLong(jobId);
            this.schedulingService.removeScheduledJob(this.getExecutionContext(context), id);
        }
        JSONObject json = new JSONObject();
        json.put("result", true);
        json.put("id", (Object)jobId);
        if (this.schedulingService.getScheduledJobSummaries(this.getExecutionContext(context)).size() == 0) {
            json.put("empty", true);
        }
        context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)json.toString());
        return this.success();
    }

    protected ExecutionContext getExecutionContext(RequestContext context) {
        return JasperServerUtil.getExecutionContext(context);
    }

    public String getAttributeOwnerURI() {
        return this.attributeOwnerURI;
    }

    public void setAttributeOwnerURI(String attributeOwnerURI) {
        this.attributeOwnerURI = attributeOwnerURI;
    }

    public Event redirectAfterEdit(RequestContext context) {
        context.getExternalContext().requestFlowExecutionRedirect();
        return this.success();
    }
}

