/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.JSValidationException;
import com.jaspersoft.jasperserver.api.common.domain.ValidationError;
import com.jaspersoft.jasperserver.api.common.util.TimeZonesList;
import com.jaspersoft.jasperserver.api.engine.common.service.SecurityContextProvider;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobAlert;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobCalendarTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobMailNotification;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobRepositoryDestination;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSimpleTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSource;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobNotFoundException;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportSchedulingService;
import com.jaspersoft.jasperserver.api.logging.audit.context.AuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.domain.AuditEvent;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.common.LocalesList;
import com.jaspersoft.jasperserver.war.common.UserLocale;
import com.jaspersoft.jasperserver.war.dto.ByteEnum;
import com.jaspersoft.jasperserver.war.util.ValidationErrorsUtils;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.propertyeditors.CustomCollectionEditor;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.DataBinder;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ReportJobEditAction
extends FormAction {
    protected static final Log log = LogFactory.getLog(ReportJobEditAction.class);
    public static final byte RECURRENCE_TYPE_NONE = 1;
    public static final byte RECURRENCE_TYPE_SIMPLE = 2;
    public static final byte RECURRENCE_TYPE_CALENDAR = 3;
    public static final String ATTR_NAME_TRIGGER_RECURRENCE_TYPE = "triggerRecurrenceType";
    public static final String ATTR_NAME_TRIGGER_ALL_WEEK_DAYS = "allWeekDays";
    public static final String ATTR_NAME_TRIGGER_ALL_MONTHS = "allMonths";
    public static final String ATTR_NAME_ORGANIZATION_ID = "organizationId";
    public static final String ATTR_NAME_PUBLIC_FOLDER_URI = "publicFolderUri";
    public static final String EVENT_DETAILS_ERROR = "detailsError";
    public static final String EVENT_TRIGGER_ERROR = "triggerError";
    public static final String EVENT_OUTPUT_ERROR = "outputError";
    public static final String[] VALIDATION_FIELDS_DETAILS = new String[]{"label", "description"};
    public static final String[] VALIDATION_FIELDS_TRIGGER = new String[]{"trigger"};
    public static final String[] VALIDATION_FIELDS_OUTPUT = new String[]{"baseOutputFilename", "outputFormats", "contentRepositoryDestination", "mailNotification"};
    protected static final Map VALIDATION_FIELDS_MAPPINGS = new LinkedHashMap();
    private MessageSource messageSource;
    private RepositoryService repositoryService;
    private ReportSchedulingService schedulingService;
    private SecurityContextProvider securityContextProvider;
    private String isNewModeAttrName;
    private String reportUnitURIAttrName;
    private String editJobIdParamName;
    private String contentFoldersAttrName;
    private String outputFormatsAttrName;
    private String intervalUnitsAttrName;
    private LocalesList localesList;
    private String localesAttrName;
    private TimeZonesList timeZonesList;
    private String timeZonesAttrName;
    private ConfigurationBean configuration;
    private AuditContext auditContext;
    private ValidationErrorsUtils validationUtils = ValidationErrorsUtils.instance();
    private Pattern addressSeparatorPattern = Pattern.compile("[,;]");
    private String addressDefaultSeparator = ", ";
    private MailAddressesEditor mailAddressesEditor;
    private CustomNumberEditor customNumberEditor;
    private CustomCollectionEditor byteSetEditor;
    private CustomCollectionEditor byteSortedSetEditor;
    private List recurrenceIntervalUnits;
    private List allOutputFormats;
    private final List weekDays = this.getWeekDays();
    private final List months = this.getMonths();

    protected List getOutputFormats() {
        return this.allOutputFormats;
    }

    protected List getWeekDays() {
        ArrayList<ByteEnum> weekDaysList = new ArrayList<ByteEnum>();
        weekDaysList.add(new ByteEnum(2, "week.days.label.mon"));
        weekDaysList.add(new ByteEnum(3, "week.days.label.tue"));
        weekDaysList.add(new ByteEnum(4, "week.days.label.wen"));
        weekDaysList.add(new ByteEnum(5, "week.days.label.thu"));
        weekDaysList.add(new ByteEnum(6, "week.days.label.fri"));
        weekDaysList.add(new ByteEnum(7, "week.days.label.sat"));
        weekDaysList.add(new ByteEnum(1, "week.days.label.sun"));
        return weekDaysList;
    }

    protected List getMonths() {
        ArrayList<ByteEnum> monthsList = new ArrayList<ByteEnum>();
        monthsList.add(new ByteEnum(1, "monts.label.jan"));
        monthsList.add(new ByteEnum(2, "monts.label.feb"));
        monthsList.add(new ByteEnum(3, "monts.label.mar"));
        monthsList.add(new ByteEnum(4, "monts.label.apr"));
        monthsList.add(new ByteEnum(5, "monts.label.may"));
        monthsList.add(new ByteEnum(6, "monts.label.jun"));
        monthsList.add(new ByteEnum(7, "monts.label.jul"));
        monthsList.add(new ByteEnum(8, "monts.label.aug"));
        monthsList.add(new ByteEnum(9, "monts.label.sep"));
        monthsList.add(new ByteEnum(10, "monts.label.oct"));
        monthsList.add(new ByteEnum(11, "monts.label.nov"));
        monthsList.add(new ByteEnum(12, "monts.label.dec"));
        return monthsList;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.mailAddressesEditor = new MailAddressesEditor();
        this.customNumberEditor = new CustomNumberEditor(Integer.class, true);
        this.byteSetEditor = new ByteCollectionEditor(Set.class);
        this.byteSortedSetEditor = new ByteCollectionEditor(SortedSet.class);
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public ReportSchedulingService getSchedulingService() {
        return this.schedulingService;
    }

    public void setSchedulingService(ReportSchedulingService schedulingService) {
        this.schedulingService = schedulingService;
    }

    public void setSecurityContextProvider(SecurityContextProvider securityContextProvider) {
        this.securityContextProvider = securityContextProvider;
    }

    public String getEditJobIdParamName() {
        return this.editJobIdParamName;
    }

    public void setEditJobIdParamName(String editJobIdParamName) {
        this.editJobIdParamName = editJobIdParamName;
    }

    public String getIsNewModeAttrName() {
        return this.isNewModeAttrName;
    }

    public void setIsNewModeAttrName(String isNewModeAttrName) {
        this.isNewModeAttrName = isNewModeAttrName;
    }

    public String getReportUnitURIAttrName() {
        return this.reportUnitURIAttrName;
    }

    public void setReportUnitURIAttrName(String reportUnitURIAttrName) {
        this.reportUnitURIAttrName = reportUnitURIAttrName;
    }

    public String getContentFoldersAttrName() {
        return this.contentFoldersAttrName;
    }

    public void setContentFoldersAttrName(String contentFoldersAttrName) {
        this.contentFoldersAttrName = contentFoldersAttrName;
    }

    public String getOutputFormatsAttrName() {
        return this.outputFormatsAttrName;
    }

    public void setOutputFormatsAttrName(String outputFormatsAttrName) {
        this.outputFormatsAttrName = outputFormatsAttrName;
    }

    public String getIntervalUnitsAttrName() {
        return this.intervalUnitsAttrName;
    }

    public void setIntervalUnitsAttrName(String intervalUnitsAttrName) {
        this.intervalUnitsAttrName = intervalUnitsAttrName;
    }

    public String getLocalesAttrName() {
        return this.localesAttrName;
    }

    public void setLocalesAttrName(String localesAttrName) {
        this.localesAttrName = localesAttrName;
    }

    public LocalesList getLocalesList() {
        return this.localesList;
    }

    public void setLocalesList(LocalesList localesList) {
        this.localesList = localesList;
    }

    public String getTimeZonesAttrName() {
        return this.timeZonesAttrName;
    }

    public void setTimeZonesAttrName(String timeZonesAttrName) {
        this.timeZonesAttrName = timeZonesAttrName;
    }

    public TimeZonesList getTimeZonesList() {
        return this.timeZonesList;
    }

    public void setTimeZonesList(TimeZonesList timeZonesList) {
        this.timeZonesList = timeZonesList;
    }

    public ValidationErrorsUtils getValidationUtils() {
        return this.validationUtils;
    }

    public void setValidationUtils(ValidationErrorsUtils validationUtils) {
        this.validationUtils = validationUtils;
    }

    public AuditContext getAuditContext() {
        return this.auditContext;
    }

    public void setAuditContext(AuditContext auditContext) {
        this.auditContext = auditContext;
    }

    protected void initBinder(RequestContext context, DataBinder binder) {
        super.initBinder(context, binder);
        binder.registerCustomEditor(List.class, "mailNotification.toAddresses", (PropertyEditor)this.mailAddressesEditor);
        binder.registerCustomEditor(List.class, "mailNotification.ccAddresses", (PropertyEditor)this.mailAddressesEditor);
        binder.registerCustomEditor(List.class, "mailNotification.bccAddresses", (PropertyEditor)this.mailAddressesEditor);
        CustomDateEditor customDateEditor = new CustomDateEditor(JasperServerUtil.createCalendarDateTimeFormat(this.getMessageSource()), true);
        binder.registerCustomEditor(Date.class, (PropertyEditor)customDateEditor);
        binder.registerCustomEditor(Integer.class, (PropertyEditor)this.customNumberEditor);
        binder.registerCustomEditor(Set.class, "outputFormats", (PropertyEditor)this.byteSetEditor);
        binder.registerCustomEditor(SortedSet.class, "trigger.weekDays", (PropertyEditor)this.byteSortedSetEditor);
        binder.registerCustomEditor(SortedSet.class, "trigger.months", (PropertyEditor)this.byteSortedSetEditor);
        binder.registerCustomEditor(String.class, "contentRepositoryDestination.timestampPattern", (PropertyEditor)new StringTrimmerEditor(true));
    }

    public Event setupForm(RequestContext context) throws Exception {
        context.getFlowScope().put(ATTR_NAME_ORGANIZATION_ID, (Object)this.securityContextProvider.getContextUser().getTenantId());
        context.getFlowScope().put(ATTR_NAME_PUBLIC_FOLDER_URI, (Object)this.configuration.getPublicFolderUri());
        String isRunNowMode = context.getRequestParameters().get("isRunNowModeRequest");
        if (isRunNowMode != null) {
            Boolean isRunNow = null;
            if ("true".equalsIgnoreCase(isRunNowMode)) {
                isRunNow = new Boolean(true);
            } else if ("false".equalsIgnoreCase(isRunNowMode)) {
                isRunNow = new Boolean(false);
            }
            context.getFlowScope().put("isRunNowMode", (Object)isRunNow);
        }
        try {
            return super.setupForm(context);
        }
        catch (ReportJobNotFoundException e) {
            context.getFlowScope().put("errorMessage", (Object)"report.job.edit.not.found");
            context.getFlowScope().put("errorArguments", (Object)new Long(e.getJobId()));
            return new Event((Object)this, "notFound");
        }
    }

    protected Object createFormObject(RequestContext context) {
        ReportJob job;
        if (this.isNewMode(context)) {
            job = this.createNewReportJob(context);
        } else {
            Long jobIdParam = context.getRequestParameters().getRequiredLong(this.getEditJobIdParamName());
            long jobId = jobIdParam;
            job = this.schedulingService.getScheduledJob(JasperServerUtil.getExecutionContext(context), jobId);
            if (job == null) {
                throw new ReportJobNotFoundException(jobId);
            }
        }
        if (job.getMailNotification() == null) {
            job.setMailNotification(new ReportJobMailNotification());
        }
        return job;
    }

    protected ReportJob createNewReportJob(RequestContext context) {
        ReportJob job = new ReportJob();
        ReportJobSimpleTrigger trigger = new ReportJobSimpleTrigger();
        job.setTrigger((ReportJobTrigger)trigger);
        job.setSource(new ReportJobSource());
        String ownerURI = this.newJobOwnerURI(context);
        job.getSource().setReportUnitURI(ownerURI);
        int lastSepIdx = ownerURI.lastIndexOf("/");
        if (lastSepIdx < 0) {
            String quotedURI = "\"" + ownerURI + "\"";
            throw new JSException("jsexception.no.values.to.enumerate", new Object[]{quotedURI});
        }
        String reportName = ownerURI.substring(lastSepIdx + Folder.SEPARATOR_LENGTH);
        job.setBaseOutputFilename(reportName);
        trigger.setStartType((byte)1);
        trigger.setOccurrenceCount(1);
        ReportJobRepositoryDestination repositoryDestination = new ReportJobRepositoryDestination();
        job.setContentRepositoryDestination(repositoryDestination);
        job.addOutputFormat((byte)1);
        return job;
    }

    protected String newJobOwnerURI(RequestContext context) {
        String reportUnitURI = context.getFlowScope().getString(this.getReportUnitURIAttrName());
        if (reportUnitURI == null) {
            reportUnitURI = context.getRequestParameters().get(this.getReportUnitURIAttrName() + "Request");
            context.getFlowScope().put(this.getReportUnitURIAttrName(), (Object)reportUnitURI);
        }
        return reportUnitURI;
    }

    protected ReportJob getReportJob(RequestContext context) throws Exception {
        return (ReportJob)this.getFormObject(context);
    }

    protected boolean isNewMode(RequestContext context) {
        Boolean isNewMode = context.getFlowScope().getBoolean(this.getIsNewModeAttrName());
        String newModeFromRequest = context.getRequestParameters().get(this.getIsNewModeAttrName() + "Request");
        if (newModeFromRequest != null) {
            if ("true".equalsIgnoreCase(newModeFromRequest)) {
                isNewMode = new Boolean(true);
            } else if ("false".equalsIgnoreCase(newModeFromRequest)) {
                isNewMode = new Boolean(false);
            }
            context.getFlowScope().put(this.getIsNewModeAttrName(), (Object)isNewMode);
        }
        return isNewMode != null && isNewMode != false;
    }

    public Event setNowModeDefaults(RequestContext context) throws Exception {
        ReportJob job = this.getReportJob(context);
        String jobLabel = this.messageSource.getMessage("report.scheduling.job.runNow.label", null, "Run once job", this.getUserLocale());
        job.setLabel(jobLabel);
        return this.success();
    }

    public Event setOutputReferenceData(RequestContext context) {
        UserLocale[] userLocales;
        List folders = this.repositoryService.getAllFolders(JasperServerUtil.getExecutionContext(context));
        this.filterOutputFolders(folders);
        context.getRequestScope().put(this.getContentFoldersAttrName(), (Object)folders);
        context.getFlowScope().put(this.getOutputFormatsAttrName(), (Object)this.allOutputFormats);
        if (this.getLocalesList() != null && (userLocales = this.getLocalesList().getUserLocales(this.getUserLocale())) != null && userLocales.length > 0) {
            context.getRequestScope().put(this.getLocalesAttrName(), (Object)userLocales);
        }
        this.setTimeZoneData(context);
        return this.success();
    }

    protected void filterOutputFolders(List folders) {
        List filters = this.configuration.getOutputFolderFilterPatterns();
        if (filters == null || filters.isEmpty()) {
            return;
        }
        if (folders != null && !folders.isEmpty()) {
            Iterator it = folders.iterator();
            while (it.hasNext()) {
                Folder folder = (Folder)it.next();
                String folderURI = folder.getURIString();
                boolean matchedFilter = false;
                for (Pattern filter : filters) {
                    if (!filter.matcher(folderURI).matches()) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Folder " + folderURI + " matched filter " + filter + ", excluding from list"));
                    }
                    matchedFilter = true;
                    break;
                }
                if (!matchedFilter) continue;
                it.remove();
            }
        }
    }

    protected Locale getUserLocale() {
        return LocaleContextHolder.getLocale();
    }

    public Event setTriggerReferenceData(RequestContext context) throws Exception {
        context.getRequestScope().put(this.getIntervalUnitsAttrName(), (Object)this.recurrenceIntervalUnits);
        ReportJob reportJob = this.getReportJob(context);
        byte triggerRecurrenceType = this.getTriggerRecurrenceType(reportJob.getTrigger());
        context.getRequestScope().put(ATTR_NAME_TRIGGER_RECURRENCE_TYPE, (Object)new Byte(triggerRecurrenceType));
        if (triggerRecurrenceType == 3) {
            context.getRequestScope().put(ATTR_NAME_TRIGGER_ALL_WEEK_DAYS, (Object)this.weekDays);
            context.getRequestScope().put(ATTR_NAME_TRIGGER_ALL_MONTHS, (Object)this.months);
        }
        this.setTimeZoneData(context);
        return this.success();
    }

    protected void setTimeZoneData(RequestContext context) {
        if (this.getTimeZonesList() != null) {
            List timeZones = this.getTimeZonesList().getTimeZones(this.getUserLocale());
            context.getRequestScope().put(this.getTimeZonesAttrName(), (Object)timeZones);
            TimeZone userTz = JasperServerUtil.getTimezone(context);
            context.getRequestScope().put("preferredTimezone", (Object)userTz.getID());
        }
    }

    protected byte getTriggerRecurrenceType(ReportJobTrigger trigger) {
        int type;
        if (trigger instanceof ReportJobSimpleTrigger) {
            ReportJobSimpleTrigger simpleTrigger = (ReportJobSimpleTrigger)trigger;
            type = simpleTrigger.getOccurrenceCount() == 1 ? 1 : 2;
        } else if (trigger instanceof ReportJobCalendarTrigger) {
            type = 3;
        } else {
            String quotedTriggerType = "\"" + trigger.getClass().getName() + "\"";
            throw new JSException("jsexception.job.unknown.trigger.type", new Object[]{quotedTriggerType});
        }
        return (byte)type;
    }

    public Event setTriggerRecurrenceNone(RequestContext context) throws Exception {
        ReportJob job = this.getReportJob(context);
        ReportJobSimpleTrigger trigger = new ReportJobSimpleTrigger();
        this.copyCommonTriggerAttributes((ReportJobTrigger)trigger, job.getTrigger());
        trigger.setOccurrenceCount(1);
        job.setTrigger((ReportJobTrigger)trigger);
        return this.success();
    }

    public Event setTriggerRecurrenceSimple(RequestContext context) throws Exception {
        ReportJob job = this.getReportJob(context);
        ReportJobSimpleTrigger trigger = new ReportJobSimpleTrigger();
        this.copyCommonTriggerAttributes((ReportJobTrigger)trigger, job.getTrigger());
        trigger.setOccurrenceCount(-1);
        trigger.setRecurrenceInterval(1);
        trigger.setRecurrenceIntervalUnit((byte)3);
        job.setTrigger((ReportJobTrigger)trigger);
        return this.success();
    }

    public Event setTriggerRecurrenceCalendar(RequestContext context) throws Exception {
        ReportJob job = this.getReportJob(context);
        ReportJobCalendarTrigger trigger = new ReportJobCalendarTrigger();
        this.copyCommonTriggerAttributes((ReportJobTrigger)trigger, job.getTrigger());
        trigger.setMinutes("0");
        trigger.setHours("0");
        trigger.setDaysType((byte)1);
        TreeSet<Byte> selectedMonths = new TreeSet<Byte>();
        for (ByteEnum month : this.months) {
            selectedMonths.add(new Byte(month.getCode()));
        }
        trigger.setMonths(selectedMonths);
        job.setTrigger((ReportJobTrigger)trigger);
        return this.success();
    }

    protected void copyCommonTriggerAttributes(ReportJobTrigger newTrigger, ReportJobTrigger trigger) {
        newTrigger.setTimezone(trigger.getTimezone());
        newTrigger.setStartType(trigger.getStartType());
        newTrigger.setStartDate(trigger.getStartDate());
        newTrigger.setEndDate(trigger.getEndDate());
        newTrigger.setCalendarName(trigger.getCalendarName());
    }

    public void createAuditReportSchedulingEvent(final String jobType) {
        this.auditContext.doInAuditContext(new AuditContext.AuditContextCallback(){

            public void execute() {
                ReportJobEditAction.this.auditContext.createAuditEvent(jobType);
            }
        });
    }

    public void closeReportSchedulingAuditEvent(String jobType) {
        this.auditContext.doInAuditContext(jobType, new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                ReportJobEditAction.this.auditContext.closeAuditEvent(auditEvent);
            }
        });
    }

    public Event saveJob(RequestContext context) throws Exception {
        block13: {
            ReportJob job = this.getReportJob(context);
            if (job.getMailNotification().isEmpty()) {
                job.setMailNotification(null);
            }
            try {
                if (this.isNewMode(context)) {
                    job.setCreationDate(new Timestamp(GregorianCalendar.getInstance().getTimeInMillis()));
                    job.setAlert(new ReportJobAlert());
                    this.createAuditReportSchedulingEvent("scheduleReport");
                    this.schedulingService.scheduleJob(JasperServerUtil.getExecutionContext(context), job);
                    this.closeReportSchedulingAuditEvent("scheduleReport");
                    break block13;
                }
                try {
                    this.createAuditReportSchedulingEvent("updateReportScheduling");
                    this.schedulingService.updateScheduledJob(JasperServerUtil.getExecutionContext(context), job);
                    this.closeReportSchedulingAuditEvent("updateReportScheduling");
                }
                catch (ReportJobNotFoundException e) {
                    context.getFlowScope().put("errorMessage", (Object)"report.job.save.not.found");
                    context.getFlowScope().put("errorArguments", (Object)new Long(e.getJobId()));
                    Event event = this.result("notFound");
                    if (job.getMailNotification() == null) {
                        job.setMailNotification(new ReportJobMailNotification());
                    }
                    return event;
                }
            }
            catch (JSValidationException e) {
                String errorEvent = this.resolveValidationErrorEvent(e);
                if (errorEvent != null) {
                    this.validationUtils.setErrors(this.getFormErrors(context), e.getErrors(), null);
                    Event event = this.result(errorEvent);
                    return event;
                }
                throw e;
            }
            finally {
                if (job.getMailNotification() == null) {
                    job.setMailNotification(new ReportJobMailNotification());
                }
            }
        }
        return this.success();
    }

    protected String resolveValidationErrorEvent(JSValidationException e) {
        String event = null;
        block0: for (ValidationError error : e.getErrors().getErrors()) {
            String field = error.getField();
            if (field == null) continue;
            for (Map.Entry entry : VALIDATION_FIELDS_MAPPINGS.entrySet()) {
                String[] prefixes = (String[])entry.getValue();
                if (!this.fieldMatches(field, prefixes)) continue;
                event = (String)entry.getKey();
                break block0;
            }
        }
        return event;
    }

    protected boolean fieldMatches(String field, String[] fieldPrefixes) {
        boolean matches = false;
        for (int i = 0; i < fieldPrefixes.length; ++i) {
            if (!field.startsWith(fieldPrefixes[i])) continue;
            matches = true;
            break;
        }
        return matches;
    }

    public Pattern getAddressSeparatorPattern() {
        return this.addressSeparatorPattern;
    }

    public void setAddressSeparatorPattern(Pattern addressSeparatorPattern) {
        this.addressSeparatorPattern = addressSeparatorPattern;
    }

    public String getAddressDefaultSeparator() {
        return this.addressDefaultSeparator;
    }

    public void setAddressDefaultSeparator(String addressDefaultSeparator) {
        this.addressDefaultSeparator = addressDefaultSeparator;
    }

    public List getRecurrenceIntervalUnits() {
        return this.recurrenceIntervalUnits;
    }

    public void setRecurrenceIntervalUnits(List recurrenceIntervalUnits) {
        this.recurrenceIntervalUnits = recurrenceIntervalUnits;
    }

    public ConfigurationBean getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ConfigurationBean configuration) {
        this.configuration = configuration;
    }

    public List getAllOutputFormats() {
        return this.allOutputFormats;
    }

    public void setAllOutputFormats(List allOutputFormats) {
        this.allOutputFormats = allOutputFormats;
    }

    static {
        VALIDATION_FIELDS_MAPPINGS.put(EVENT_DETAILS_ERROR, VALIDATION_FIELDS_DETAILS);
        VALIDATION_FIELDS_MAPPINGS.put(EVENT_TRIGGER_ERROR, VALIDATION_FIELDS_TRIGGER);
        VALIDATION_FIELDS_MAPPINGS.put(EVENT_OUTPUT_ERROR, VALIDATION_FIELDS_OUTPUT);
    }

    protected static class ByteCollectionEditor
    extends CustomCollectionEditor {
        public ByteCollectionEditor(Class collectionClass) {
            super(collectionClass);
        }

        protected Object convertElement(Object val) {
            if (val == null || val instanceof Byte) {
                return val;
            }
            try {
                return Byte.valueOf(val.toString());
            }
            catch (NumberFormatException e) {
                log.error((Object)"error parsing byte value", (Throwable)e);
                throw new JSExceptionWrapper((Exception)e);
            }
        }
    }

    protected class MailAddressesEditor
    extends PropertyEditorSupport {
        protected MailAddressesEditor() {
        }

        @Override
        public String getAsText() {
            StringBuffer sb = new StringBuffer();
            List addresses = (List)this.getValue();
            if (addresses != null && !addresses.isEmpty()) {
                Iterator it = addresses.iterator();
                String address = (String)it.next();
                sb.append(address);
                while (it.hasNext()) {
                    sb.append(ReportJobEditAction.this.getAddressDefaultSeparator());
                    address = (String)it.next();
                    sb.append(address);
                }
            }
            return sb.toString();
        }

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            ArrayList<String> addressList = new ArrayList<String>();
            if (text != null && text.trim().length() > 0) {
                String[] addresses = ReportJobEditAction.this.addressSeparatorPattern.split(text.trim());
                for (int i = 0; i < addresses.length; ++i) {
                    String address = addresses[i].trim();
                    if (address.length() <= 0) continue;
                    addressList.add(address);
                }
            }
            this.setValue(addressList);
        }
    }
}

