/*
 * Decompiled with CFR 0.152.
 */
package jmxlogger.tools;

import java.io.File;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ErrorManager;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolBox {
    public static final String KEY_CONFIG_LOG_LEVEL = "level";
    public static final String KEY_CONFIG_JMX_OBJECTNAME = "jmxObjectName";
    public static final String KEY_CONFIG_JMX_SERVER = "jmxServer";
    public static final String KEY_CONFIG_FILTER_EXP = "filterExpression";
    public static final String KEY_CONFIG_FILTER_SCRIPT = "filterScript";
    public static final String KEY_CONFIG_SERVER_ADDR = "serverAddress";
    public static final String KEY_EVENT_TYPE = "jmxlogger.log.event";
    public static final String KEY_EVENT_SOURCE = "source";
    public static final String KEY_EVENT_LOGGER = "loggerName";
    public static final String KEY_EVENT_LEVEL = "logLevel";
    public static final String KEY_EVENT_SOURCE_CLASS = "sourceClassName";
    public static final String KEY_EVENT_SOURCE_METHOD = "sourceMethodName";
    public static final String KEY_EVENT_SOURCE_THREAD = "threadId";
    public static final String KEY_EVENT_SEQ_NUM = "sequenceNumber";
    public static final String KEY_EVENT_TIME_STAMP = "timestamp";
    public static final String KEY_EVENT_FORMATTED_MESSAGE = "formattedMessage";
    public static final String KEY_EVENT_RAW_MESSAGE = "rawMessage";
    public static final String KEY_EVENT_THROWABLE = "exceptionName";
    public static final String KEY_EVENT_LOG_STAT = "logStats";
    public static final String KEY_EVENT_LOG_COUNT_ATTEMPTED = "totalLogAttempted";
    public static final String KEY_EVENT_LOG_COUNTED = "totalLogCounted";
    public static final String KEY_EVENT_START_TIME = "startTime";
    public static final String KEY_EVENT_SYS_STAT = "systemStats";
    private static final ErrorManager EM = new ErrorManager();
    private static final String DEFAULT_NAME = "jmxlogger:type=LogEmitter";

    public static String getDefaultEventType() {
        return KEY_EVENT_TYPE;
    }

    public static MBeanServer findMBeanServer(String agentId) {
        MBeanServer server = null;
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(agentId);
        server = servers.size() > 0 ? servers.get(0) : ((servers = MBeanServerFactory.findMBeanServer(null)).size() > 0 ? servers.get(0) : ManagementFactory.getPlatformMBeanServer());
        return server;
    }

    public static ObjectName buildObjectName(String name) {
        ObjectName objName = null;
        try {
            objName = new ObjectName(name);
        }
        catch (MalformedObjectNameException ex) {
            throw new RuntimeException(ex);
        }
        catch (NullPointerException ex) {
            throw new RuntimeException(ex);
        }
        return objName;
    }

    public static ObjectName buildDefaultObjectName(String id) {
        String seed = id != null ? id : Long.toString(System.currentTimeMillis());
        return ToolBox.buildObjectName("jmxlogger:type=LogEmitter@" + seed);
    }

    public static void registerMBean(MBeanServer server, ObjectName beanName, Object object) {
        try {
            if (server.isRegistered(beanName)) {
                server.unregisterMBean(beanName);
            }
            server.registerMBean(object, beanName);
        }
        catch (InstanceAlreadyExistsException ex) {
            throw new RuntimeException(ex);
        }
        catch (NotCompliantMBeanException ex) {
            throw new RuntimeException(ex);
        }
        catch (InstanceNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (MBeanRegistrationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void unregisterMBean(MBeanServer server, ObjectName beanName) {
        try {
            if (server.isRegistered(beanName)) {
                server.unregisterMBean(beanName);
            }
        }
        catch (InstanceNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (MBeanRegistrationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void reportError(String error, Exception ex) {
        EM.error(error, ex, 0);
    }

    public static boolean isFileValid(File f) {
        return f != null && f.exists() && !f.isDirectory();
    }

    public static JMXServiceURL createServiceUrlFromString(String url) {
        String[] urlParts = url.split(":");
        String urlString = url;
        if (urlParts.length == 2) {
            urlString = "service:jmx:rmi:///jndi/rmi://" + urlParts[0] + ":" + urlParts[1] + "/jmxrmi";
        }
        JMXServiceURL svcUrl = null;
        try {
            svcUrl = new JMXServiceURL(urlString);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        return svcUrl;
    }

    public static Map<String, Long> getSystemInfo() {
        HashMap<String, Long> info = new HashMap<String, Long>();
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        info.put(KEY_EVENT_START_TIME, new Long(runtime.getStartTime()));
        info.put("uptime", new Long(runtime.getUptime()));
        ClassLoadingMXBean cl = ManagementFactory.getClassLoadingMXBean();
        info.put("loadedClassCount", new Long(cl.getLoadedClassCount()));
        info.put("unloadedClassCount", new Long(cl.getUnloadedClassCount()));
        MemoryMXBean memPool = ManagementFactory.getMemoryMXBean();
        info.put("heapMemCommitted", new Long(memPool.getHeapMemoryUsage().getCommitted()));
        info.put("heapMemInit", new Long(memPool.getHeapMemoryUsage().getInit()));
        info.put("heapMemMax", new Long(memPool.getHeapMemoryUsage().getMax()));
        info.put("heapMemUsed", new Long(memPool.getHeapMemoryUsage().getUsed()));
        info.put("nonHeapMemCommitted", new Long(memPool.getNonHeapMemoryUsage().getCommitted()));
        info.put("nonHeapMemInit", new Long(memPool.getNonHeapMemoryUsage().getInit()));
        info.put("nonHeapMemMax", new Long(memPool.getNonHeapMemoryUsage().getMax()));
        info.put("nonHeapMemUsed", new Long(memPool.getNonHeapMemoryUsage().getUsed()));
        ThreadMXBean thread = ManagementFactory.getThreadMXBean();
        info.put("threadCount", new Long(thread.getThreadCount()));
        info.put("deamonThreadCount", new Long(thread.getDaemonThreadCount()));
        info.put("peakThreadCount", new Long(thread.getPeakThreadCount()));
        return info;
    }
}

