/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.intersyscache;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.ConvertModifier;
import org.teiid.translator.jdbc.EscapeSyntaxModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.JDBCExecutionFactory;

@Translator(name="intersystems-cache", description="A translator for Intersystems Cache Database")
public class InterSystemsCacheExecutionFactory
extends JDBCExecutionFactory {
    private static final String INTER_CACHE = "intersystems-cache";
    protected ConvertModifier convert = new ConvertModifier();

    @Override
    public void start() throws TranslatorException {
        super.start();
        this.convert.addTypeMapping("tinyint", 3);
        this.convert.addTypeMapping("smallint", 4);
        this.convert.addTypeMapping("integer", 5);
        this.convert.addTypeMapping("bigint", 6);
        this.convert.addTypeMapping("decimal(38,19)", 10);
        this.convert.addTypeMapping("decimal(19,0)", 7);
        this.convert.addTypeMapping("character", 1);
        this.convert.addTypeMapping("varchar(4000)", 0);
        this.convert.addTypeMapping("date", 11);
        this.convert.addTypeMapping("time", 12);
        this.convert.addTypeMapping("timestamp", 13);
        this.convert.addNumericBooleanConversions();
        this.registerFunctionModifier("convert", this.convert);
        this.registerFunctionModifier("ifnull", new AliasModifier("nvl"));
        this.registerFunctionModifier("concat", new EscapeSyntaxModifier());
        this.registerFunctionModifier("acos", new EscapeSyntaxModifier());
        this.registerFunctionModifier("asin", new EscapeSyntaxModifier());
        this.registerFunctionModifier("atan", new EscapeSyntaxModifier());
        this.registerFunctionModifier("cos", new EscapeSyntaxModifier());
        this.registerFunctionModifier("cot", new EscapeSyntaxModifier());
        this.registerFunctionModifier("curdate", new EscapeSyntaxModifier());
        this.registerFunctionModifier("curtime", new EscapeSyntaxModifier());
        this.registerFunctionModifier("dayname", new EscapeSyntaxModifier());
        this.registerFunctionModifier("dayofmonth", new EscapeSyntaxModifier());
        this.registerFunctionModifier("dayofweek", new EscapeSyntaxModifier());
        this.registerFunctionModifier("dayofyear", new EscapeSyntaxModifier());
        this.registerFunctionModifier("exp", new EscapeSyntaxModifier());
        this.registerFunctionModifier("hour", new EscapeSyntaxModifier());
        this.registerFunctionModifier("log", new EscapeSyntaxModifier());
        this.registerFunctionModifier("log10", new EscapeSyntaxModifier());
        this.registerFunctionModifier("left", new EscapeSyntaxModifier());
        this.registerFunctionModifier("minute", new EscapeSyntaxModifier());
        this.registerFunctionModifier("month", new EscapeSyntaxModifier());
        this.registerFunctionModifier("monthname", new EscapeSyntaxModifier());
        this.registerFunctionModifier("mod", new EscapeSyntaxModifier());
        this.registerFunctionModifier("now", new EscapeSyntaxModifier());
        this.registerFunctionModifier("pi", new EscapeSyntaxModifier());
        this.registerFunctionModifier("quarter", new EscapeSyntaxModifier());
        this.registerFunctionModifier("right", new EscapeSyntaxModifier());
        this.registerFunctionModifier("sin", new EscapeSyntaxModifier());
        this.registerFunctionModifier("second", new EscapeSyntaxModifier());
        this.registerFunctionModifier("sqrt", new EscapeSyntaxModifier());
        this.registerFunctionModifier("tan", new EscapeSyntaxModifier());
        this.registerFunctionModifier("timestampadd", new EscapeSyntaxModifier());
        this.registerFunctionModifier("timestampdiff", new EscapeSyntaxModifier());
        this.registerFunctionModifier("truncate", new EscapeSyntaxModifier());
        this.registerFunctionModifier("week", new EscapeSyntaxModifier());
        this.registerFunctionModifier("/", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                if (function.getType() == TypeFacility.RUNTIME_TYPES.INTEGER || function.getType() == TypeFacility.RUNTIME_TYPES.LONG) {
                    Function result = ConvertModifier.createConvertFunction(InterSystemsCacheExecutionFactory.this.getLanguageFactory(), (Expression)function, TypeFacility.getDataTypeName((Class)function.getType()));
                    function.setType(TypeFacility.RUNTIME_TYPES.BIG_DECIMAL);
                    return Arrays.asList(result);
                }
                return null;
            }
        });
        this.addPushDownFunction(INTER_CACHE, "CHARACTER_LENGTH", "integer", new String[]{"string"});
        this.addPushDownFunction(INTER_CACHE, "CHAR_LENGTH", "integer", new String[]{"string"});
        this.addPushDownFunction(INTER_CACHE, "CHARINDEX", "integer", new String[]{"string", "string"});
        this.addPushDownFunction(INTER_CACHE, "CHARINDEX", "integer", new String[]{"string", "string", "integer"});
        this.addPushDownFunction(INTER_CACHE, "INSTR", "integer", new String[]{"string", "string"});
        this.addPushDownFunction(INTER_CACHE, "INSTR", "integer", new String[]{"string", "string", "integer"});
        this.addPushDownFunction(INTER_CACHE, "IS_NUMERIC", "integer", new String[]{"string"});
        this.addPushDownFunction(INTER_CACHE, "REPLICATE", "string", new String[]{"string", "integer"});
        this.addPushDownFunction(INTER_CACHE, "REVERSE", "string", new String[]{"string"});
        this.addPushDownFunction(INTER_CACHE, "STUFF", "string", new String[]{"string", "string", "integer", "string"});
        this.addPushDownFunction(INTER_CACHE, "TRIM", "string", new String[]{"string"});
    }

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("abs");
        supportedFunctions.add("acos");
        supportedFunctions.add("asin");
        supportedFunctions.add("atan");
        supportedFunctions.add("ascii");
        supportedFunctions.add("ceiling");
        supportedFunctions.add("char");
        supportedFunctions.add("coalesce");
        supportedFunctions.add("concat");
        supportedFunctions.add("convert");
        supportedFunctions.add("cos");
        supportedFunctions.add("cot");
        supportedFunctions.add("curdate");
        supportedFunctions.add("curtime");
        supportedFunctions.add("dayname");
        supportedFunctions.add("dayofmonth");
        supportedFunctions.add("dayofweek");
        supportedFunctions.add("dayofyear");
        supportedFunctions.add("exp");
        supportedFunctions.add("floor");
        supportedFunctions.add("hour");
        supportedFunctions.add("ifnull");
        supportedFunctions.add("lcase");
        supportedFunctions.add("length");
        supportedFunctions.add("lpad");
        supportedFunctions.add("ltrim");
        supportedFunctions.add("log");
        supportedFunctions.add("log10");
        supportedFunctions.add("left");
        supportedFunctions.add("minute");
        supportedFunctions.add("month");
        supportedFunctions.add("monthname");
        supportedFunctions.add("mod");
        supportedFunctions.add("nullif");
        supportedFunctions.add("now");
        supportedFunctions.add("pi");
        supportedFunctions.add("power");
        supportedFunctions.add("quarter");
        supportedFunctions.add("right");
        supportedFunctions.add("repeat");
        supportedFunctions.add("replace");
        supportedFunctions.add("round");
        supportedFunctions.add("rpad");
        supportedFunctions.add("rtrim");
        supportedFunctions.add("sign");
        supportedFunctions.add("substring");
        supportedFunctions.add("sin");
        supportedFunctions.add("second");
        supportedFunctions.add("sqrt");
        supportedFunctions.add("tan");
        supportedFunctions.add("timestampadd");
        supportedFunctions.add("timestampdiff");
        supportedFunctions.add("truncate");
        supportedFunctions.add("ucase");
        supportedFunctions.add("xmlconcat");
        supportedFunctions.add("week");
        return supportedFunctions;
    }

    @Override
    public String translateLiteralDate(Date dateValue) {
        return "to_date('" + this.formatDateValue(dateValue) + "', 'yyyy-mm-dd')";
    }

    @Override
    public String translateLiteralTime(Time timeValue) {
        return "to_date('" + this.formatDateValue(timeValue) + "', 'hh:mi:ss')";
    }

    @Override
    public String translateLiteralTimestamp(Timestamp timestampValue) {
        return "to_timestamp('" + this.formatDateValue(timestampValue) + "', 'yyyy-mm-dd hh:mi:ss.fffffffff')";
    }

    @Override
    public ExecutionFactory.NullOrder getDefaultNullOrder() {
        return ExecutionFactory.NullOrder.LAST;
    }

    @Override
    public boolean supportsInlineViews() {
        return true;
    }
}

