/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services.impl;

import com.jaspersoft.jasperserver.api.metadata.user.domain.ProfileAttribute;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.services.AttributesRemoteService;
import com.jaspersoft.jasperserver.remote.services.GenericAttributesService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Component;

@Component(value="userAttributesService")
public class UserAttributesServiceImpl
implements GenericAttributesService<User> {
    @Resource(name="attributesRemoteService")
    private AttributesRemoteService service;

    @Override
    public void deleteAttribute(User principal, ProfileAttribute pa) {
        this.service.deleteAttribute(principal.getUsername(), pa);
    }

    @Override
    public List<ProfileAttribute> getAttributes(User principal) throws ServiceException {
        return this.service.getAttributesOfUser(principal.getUsername());
    }

    @Override
    public ProfileAttribute getAttribute(User principal, String name) throws ServiceException {
        List<ProfileAttribute> attributes = this.getAttributes(principal);
        for (ProfileAttribute p : attributes) {
            if (!p.getAttrName().equals(name)) continue;
            return p;
        }
        return null;
    }

    @Override
    public void putAttribute(User principal, ProfileAttribute pa) throws IllegalParameterValueException {
        try {
            this.service.putAttribute(principal.getUsername(), pa);
        }
        catch (DataIntegrityViolationException dive) {
            throw new IllegalParameterValueException("value", pa.getAttrValue());
        }
    }
}

