/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services.impl;

import com.jaspersoft.jasperserver.api.logging.diagnostic.domain.DiagnosticAttribute;
import com.jaspersoft.jasperserver.api.logging.diagnostic.helper.DiagnosticAttributeBuilder;
import com.jaspersoft.jasperserver.api.logging.diagnostic.service.Diagnostic;
import com.jaspersoft.jasperserver.api.logging.diagnostic.service.DiagnosticCallback;
import com.jaspersoft.jasperserver.remote.common.ServerInfo;
import com.jaspersoft.jasperserver.remote.services.ServerInfoService;
import com.jaspersoft.jasperserver.war.util.CalendarFormatProvider;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component(value="serverInfoService")
public class ServerInfoServiceImpl
implements ServerInfoService,
Diagnostic {
    private static final String JS_VERSION = "JS_VERSION";
    private static final String BUILD_DATE_STAMP = "BUILD_DATE_STAMP";
    private static final String BUILD_TIME_STAMP = "BUILD_TIME_STAMP";
    @Resource
    protected MessageSource messageSource;
    @Resource(name="messagesCalendarFormatProvider")
    private CalendarFormatProvider calendarFormatProvider;

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Override
    public ServerInfo getServerInfo() {
        ServerInfo serverInfo = new ServerInfo();
        serverInfo.setVersion(this.getServerVersion());
        serverInfo.setBuild(this.getServerBuild());
        serverInfo.setEdition(this.getServerEdition());
        serverInfo.setDateFormatPattern(this.calendarFormatProvider.getDatePattern());
        serverInfo.setDatetimeFormatPattern(this.calendarFormatProvider.getDatetimePattern());
        return serverInfo;
    }

    protected ServerInfo.ServerEdition getServerEdition() {
        return ServerInfo.ServerEdition.CE;
    }

    protected String getMessageVersionId() {
        return JS_VERSION;
    }

    protected String getServerVersion() {
        return this.messageSource.getMessage(this.getMessageVersionId(), new Object[0], Locale.getDefault());
    }

    protected String getServerBuild() {
        return this.messageSource.getMessage(BUILD_DATE_STAMP, new Object[0], Locale.getDefault()) + "_" + this.messageSource.getMessage(BUILD_TIME_STAMP, new Object[0], Locale.getDefault());
    }

    public Map<DiagnosticAttribute, DiagnosticCallback> getDiagnosticData() {
        return new DiagnosticAttributeBuilder().addDiagnosticAttribute("Version", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return ServerInfoServiceImpl.this.getServerInfo().getVersion();
            }
        }).addDiagnosticAttribute("SourceEdition", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return ServerInfoServiceImpl.this.getServerInfo().getEdition().toString();
            }
        }).addDiagnosticAttribute("Build", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return ServerInfoServiceImpl.this.getServerInfo().getBuild();
            }
        }).build();
    }
}

