/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.engine.common.domain.Request;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitRequest;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitResult;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.DataCacheProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.DataSnapshotService;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControlsContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.remote.ReportExporter;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.ServicesConfiguration;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.exception.ResourceNotFoundException;
import com.jaspersoft.jasperserver.remote.exception.xml.ErrorDescriptor;
import com.jaspersoft.jasperserver.remote.services.ReportExecutionOptions;
import com.jaspersoft.jasperserver.remote.services.ReportExecutor;
import com.jaspersoft.jasperserver.remote.utils.AuditHelper;
import com.jaspersoft.jasperserver.remote.utils.RepositoryHelper;
import com.jaspersoft.jasperserver.war.cascade.CachedRepositoryService;
import com.jaspersoft.jasperserver.war.cascade.CascadeResourceNotFoundException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.SimpleReportContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class ReportExecutorImpl
implements ReportExecutor {
    private static final Log log = LogFactory.getLog(ReportExecutorImpl.class);
    @javax.annotation.Resource
    private AuditHelper auditHelper;
    @javax.annotation.Resource(name="engineService")
    private EngineService engine;
    @javax.annotation.Resource(name="remoteServiceConfiguration")
    private ServicesConfiguration servicesConfiguration;
    @javax.annotation.Resource(name="engineServiceDataCacheProvider")
    private DataCacheProvider dataCacheProvider;
    @javax.annotation.Resource(name="dataSnapshotService")
    private DataSnapshotService dataSnapshotService;
    @javax.annotation.Resource
    private JasperReportsContext jasperReportsRemoteContext;
    @javax.annotation.Resource
    private CachedRepositoryService cachedRepositoryService;

    @Override
    public ReportUnitResult runReport(String reportUnitUri, Map<String, Object> parameters, ReportExecutionOptions reportExecutionOptions) throws RemoteException {
        InputControlsContainer report = this.getResource(InputControlsContainer.class, reportUnitUri);
        long currentTime = System.currentTimeMillis();
        this.auditHelper.createAuditEvent("runReport");
        RunReportStrategy strategy = this.getStrategyForReport((Resource)report);
        if (strategy == null) {
            throw new RemoteException(new ErrorDescriptor.Builder().setErrorCode("webservices.error.errorExecutingReportUnit").setParameters(report.getURI()).getErrorDescriptor());
        }
        parameters.put("IS_IGNORE_PAGINATION", reportExecutionOptions.isIgnorePagination());
        ReportUnitResult reportUnitResult = strategy.runReport((Resource)report, parameters, this.engine, reportExecutionOptions);
        if (reportUnitResult == null) {
            throw new RemoteException(new ErrorDescriptor.Builder().setErrorCode("webservices.error.errorExecutingReportUnit").setParameters(report.getURI()).getErrorDescriptor());
        }
        this.auditHelper.addPropertyToAuditEvent("runReport", "reportExecutionStartTime", new Date(currentTime));
        this.auditHelper.addPropertyToAuditEvent("runReport", "reportExecutionTime", System.currentTimeMillis() - currentTime);
        return reportUnitResult;
    }

    protected <T extends Resource> T getResource(Class<T> resourceClass, String resourceUri) throws ResourceNotFoundException {
        try {
            return (T)((Resource)this.cachedRepositoryService.getResource(resourceClass, resourceUri));
        }
        catch (CascadeResourceNotFoundException e) {
            throw new ResourceNotFoundException(resourceUri);
        }
    }

    protected ExecutionContext createExecutionContext() {
        ExecutionContextImpl ctx = new ExecutionContextImpl();
        ctx.setLocale(LocaleContextHolder.getLocale());
        ctx.setTimeZone(TimeZone.getDefault());
        return ctx;
    }

    @Override
    public Map<JRExporterParameter, Object> exportReport(String reportUnitURI, JasperPrint jasperPrint, String format, OutputStream output, HashMap exportParameters) throws ServiceException {
        ReportExporter exporter = this.servicesConfiguration.getExporter(format.toLowerCase());
        if (exporter == null) {
            throw new ServiceException(3, "Export format " + format.toLowerCase() + " not supported or misconfigured");
        }
        try {
            InputControlsContainer report = this.getResource(InputControlsContainer.class, reportUnitURI);
            RunReportStrategy strategyForReport = this.getStrategyForReport((Resource)report);
            return exporter.exportReport(jasperPrint, output, this.engine, exportParameters, this.createExecutionContext(), strategyForReport.getConcreteReportURI((Resource)report));
        }
        catch (Exception ex) {
            throw new ServiceException(3, ex.getMessage() + " (while exporting the report)");
        }
    }

    protected RunReportStrategy getStrategyForReport(Resource report) {
        return report instanceof ReportUnit ? new RunReportUnitStrategy() : null;
    }

    @Override
    public JasperReportsContext getJasperReportsContext(Boolean interactive) {
        return this.jasperReportsRemoteContext;
    }

    @Override
    public String getContentType(String outputFormat) {
        return this.servicesConfiguration.getExporter(outputFormat.toLowerCase()).getContentType();
    }

    protected static interface RunReportStrategy {
        public ReportUnitResult runReport(Resource var1, Map<String, Object> var2, EngineService var3, ReportExecutionOptions var4);

        public ReportUnit getReportUnit(Resource var1);

        public String getConcreteReportURI(Resource var1);
    }

    protected class RunReportUnitStrategy
    extends GenericRunReportStrategy<ReportUnit> {
        protected RunReportUnitStrategy() {
        }

        @Override
        public String getConcreteReportURI(Resource reportResource) {
            return reportResource.getURI();
        }

        @Override
        public ReportUnit getReportUnit(Resource report) {
            return (ReportUnit)report;
        }
    }

    protected abstract class GenericRunReportStrategy<ReportType extends Resource>
    implements RunReportStrategy {
        protected GenericRunReportStrategy() {
        }

        @Override
        public ReportUnitResult runReport(Resource reportResource, Map<String, Object> parameters, EngineService engine, ReportExecutionOptions options) {
            Resource report = reportResource;
            HashMap<String, Object> convertedParameters = parameters != null ? RepositoryHelper.convertParameterValues(this.getConcreteReportURI(report), parameters, engine) : new HashMap<String, Object>();
            ReportUnitRequest request = this.getReportUnitRequest(report, convertedParameters, options);
            request.setAsynchronous(options.isAsync().booleanValue());
            ExecutionContext executionContext = ReportExecutorImpl.this.createExecutionContext();
            ReportUnitResult result = (ReportUnitResult)engine.execute(executionContext, (Request)request);
            this.persistDataSnapshot(executionContext, options, reportResource, request.getReportContext());
            return result;
        }

        protected void persistDataSnapshot(ExecutionContext executionContext, ReportExecutionOptions options, Resource reportResource, ReportContext reportContext) {
            DataCacheProvider.SnapshotSaveStatus snapshotSaveStatus = ReportExecutorImpl.this.dataCacheProvider.getSnapshotSaveStatus(reportContext);
            switch (snapshotSaveStatus) {
                case NEW: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("saving initial data snapshot for " + reportResource.getURIString()));
                    }
                    this.saveAutoDataSnapshot(executionContext, reportResource, reportContext);
                    break;
                }
                case UPDATED: {
                    if (!options.isSaveDataSnapshot().booleanValue()) break;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("saving updated data snapshot for " + reportResource.getURIString()));
                    }
                    this.saveDataSnapshot(executionContext, reportResource, reportContext);
                    break;
                }
            }
        }

        protected void saveAutoDataSnapshot(ExecutionContext executionContext, Resource reportResource, ReportContext reportContext) {
            ReportUnit reportUnit = this.getReportUnit(reportResource);
            try {
                ReportExecutorImpl.this.dataSnapshotService.saveAutoReportDataSnapshot(executionContext, reportContext, reportUnit);
            }
            catch (Exception e) {
                log.error((Object)("Error while saving data snapshot for " + reportUnit.getURIString()), (Throwable)e);
            }
        }

        protected void saveDataSnapshot(ExecutionContext executionContext, Resource reportResource, ReportContext reportContext) {
            ReportUnit reportUnit = this.getReportUnit(reportResource);
            try {
                ReportExecutorImpl.this.dataSnapshotService.saveReportDataSnapshot(executionContext, reportContext, reportUnit);
            }
            catch (Exception e) {
                log.error((Object)("Error while saving data snapshot for " + reportUnit.getURIString()), (Throwable)e);
            }
        }

        protected ReportUnitRequest getReportUnitRequest(ReportType reportResource, Map<String, Object> parameters, ReportExecutionOptions options) {
            HashMap<String, Object> requestParams = new HashMap<String, Object>();
            requestParams.putAll(parameters);
            SimpleReportContext reportContext = new SimpleReportContext();
            requestParams.put("REPORT_CONTEXT", reportContext);
            ReportUnitRequest request = new ReportUnitRequest(this.getConcreteReportURI((Resource)reportResource), requestParams);
            request.setReportContext((ReportContext)reportContext);
            request.setJasperReportsContext(ReportExecutorImpl.this.getJasperReportsContext(options.isInteractive()));
            request.setRecordDataSnapshot(ReportExecutorImpl.this.dataSnapshotService.isSnapshotPersistenceEnabled());
            request.setUseDataSnapshot(options.isFreshData() == false && options.isSaveDataSnapshot() == false);
            return request;
        }
    }
}

