/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InternalURI;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.PersistentObjectResolver;
import com.jaspersoft.jasperserver.api.metadata.security.JasperServerAclEntry;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.ObjectPermissionImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.RoleImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.UserImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client.MetadataUserDetails;
import com.jaspersoft.jasperserver.api.metadata.user.service.ObjectPermissionService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.api.metadata.user.service.impl.ObjectPermissionServiceImpl;
import com.jaspersoft.jasperserver.remote.exception.AccessDeniedException;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.exception.ModificationNotAllowedException;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.exception.ResourceAlreadyExistsException;
import com.jaspersoft.jasperserver.remote.exception.ResourceNotFoundException;
import com.jaspersoft.jasperserver.remote.helpers.PermissionsRecipientIdentity;
import com.jaspersoft.jasperserver.remote.services.PermissionsService;
import com.jaspersoft.jasperserver.remote.services.ResourcesManagementRemoteService;
import com.jaspersoft.jasperserver.remote.utils.AuditHelper;
import com.jaspersoft.jasperserver.search.model.permission.Permission;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.acl.AclProvider;
import org.springframework.security.acl.basic.BasicAclEntry;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="permissionsService")
@Transactional(rollbackFor={Exception.class})
public class PermissionsServiceImpl
implements PermissionsService {
    protected static final Set<Integer> ALLOWED_MASKS;
    @javax.annotation.Resource(name="concreteObjectPermissionsService")
    protected ObjectPermissionService objectPermissionService;
    @javax.annotation.Resource(name="concreteObjectPermissionsService")
    protected AclProvider aclService;
    @javax.annotation.Resource(name="concreteObjectPermissionsService")
    protected PersistentObjectResolver persistentObjectResolver;
    @javax.annotation.Resource(name="concreteRepository")
    protected RepositoryService repositoryService;
    @javax.annotation.Resource
    private AuditHelper auditHelper;
    @javax.annotation.Resource
    private ResourcesManagementRemoteService resourcesManagementRemoteService;
    @javax.annotation.Resource(name="mappingResourceFactory")
    private ResourceFactory resourceFactory;
    @javax.annotation.Resource(name="concreteUserAuthorityService")
    protected UserAuthorityService userAuthorityService;
    @javax.annotation.Resource(name="administrativeRoles")
    protected List<String> administrativeRolesNames;
    protected Comparator<BasicAclEntry> aclCompartor = new Comparator<BasicAclEntry>(){

        @Override
        public int compare(BasicAclEntry o1, BasicAclEntry o2) {
            int mask2;
            int mask1 = o1.getMask() == 1 ? 100 : o1.getMask();
            int result = mask1 - (mask2 = o2.getMask() == 1 ? 100 : o2.getMask());
            if (result == 0) {
                result = ((ObjectPermissionServiceImpl.URIObjectIdentity)o1.getAclObjectIdentity()).getURI().length() - ((ObjectPermissionServiceImpl.URIObjectIdentity)o2.getAclObjectIdentity()).getURI().length();
            }
            return result;
        }
    };

    public void setResourcesManagementRemoteService(ResourcesManagementRemoteService resourcesManagementRemoteService) {
        this.resourcesManagementRemoteService = resourcesManagementRemoteService;
    }

    public void setAuditHelper(AuditHelper auditHelper) {
        this.auditHelper = auditHelper;
    }

    @Override
    public List<ObjectPermission> getPermissions(String resourceURI) throws RemoteException {
        Resource resource = this.resourcesManagementRemoteService.locateResource(resourceURI);
        return this.objectPermissionService.getObjectPermissionsForObject(this.makeExecutionContext(), (Object)resource);
    }

    @Override
    public List<ObjectPermission> getPermissions(String resourceURI, Class<?> recipientType, String recipientId, boolean effectivePermissions, boolean resolveAll) throws RemoteException {
        List<ObjectPermission> result;
        if (resolveAll) {
            result = this.resolveAll(resourceURI, recipientType, recipientId, effectivePermissions);
        } else {
            Resource resource = this.resolveResource(resourceURI);
            result = effectivePermissions ? this.toPermission((BasicAclEntry[])this.aclService.getAcls((Object)resource)) : this.objectPermissionService.getObjectPermissionsForObject(this.makeExecutionContext(), (Object)resource);
            if (recipientType != null) {
                result = this.filterByType(result, recipientType);
                if (recipientId != null) {
                    this.resolveRecipientObject(recipientType, recipientId);
                    result = this.filterById(result, recipientId);
                }
            }
        }
        return result;
    }

    @Override
    public ObjectPermission getPermission(String resourceURI, Class<?> recipientType, String recipientId) throws RemoteException {
        Object recipient = this.resolveRecipientObject(recipientType, recipientId);
        Resource object = this.resolveResource(resourceURI);
        List permissions = this.objectPermissionService.getObjectPermissionsForObjectAndRecipient(this.makeExecutionContext(), (Object)object, recipient);
        return permissions.size() > 0 ? (ObjectPermission)permissions.get(0) : null;
    }

    @Override
    public ObjectPermission getEffectivePermission(Resource resource, Role role) {
        Authentication authentication = this.createAuthentication(role);
        ObjectPermission permission = this.getEffectivePermission(resource, authentication);
        permission.setPermissionRecipient((Object)role);
        return permission;
    }

    @Override
    public ObjectPermission getEffectivePermission(Resource resource, User user) {
        Authentication authentication = this.createAuthentication(user);
        return this.getEffectivePermission(resource, authentication);
    }

    @Override
    public ObjectPermission getEffectivePermission(Resource resource, Authentication authentication) {
        ObjectPermissionImpl permission = new ObjectPermissionImpl();
        permission.setPermissionRecipient(authentication.getPrincipal());
        BasicAclEntry[] effectiveAcls = (BasicAclEntry[])this.aclService.getAcls((Object)resource, authentication);
        if (effectiveAcls != null) {
            BasicAclEntry entry = Collections.max(Arrays.asList(effectiveAcls), this.aclCompartor);
            permission.setPermissionMask(entry.getMask());
            permission.setURI(((ObjectPermissionServiceImpl.URIObjectIdentity)entry.getAclObjectIdentity()).getURI());
        } else {
            permission.setPermissionMask(0);
        }
        return permission;
    }

    @Override
    public List<ObjectPermission> getPermissionsForObject(String targetURI) throws RemoteException {
        if (!this.objectPermissionService.isObjectAdministrable(this.makeExecutionContext(), (Object)targetURI)) {
            throw new AccessDeniedException("Access is denied");
        }
        Resource res = this.repositoryService.getResource(this.makeExecutionContext(), targetURI);
        if (res == null && (res = this.repositoryService.getFolder(this.makeExecutionContext(), targetURI)) == null) {
            throw new RemoteException("There is no resource or folder for target URI \"" + targetURI + "\"");
        }
        return this.objectPermissionService.getObjectPermissionsForObject(this.makeExecutionContext(), (Object)res);
    }

    @Override
    public ObjectPermission createPermission(ObjectPermission objectPermission) throws RemoteException {
        return this.doPutPermission(objectPermission, false);
    }

    @Override
    public ObjectPermission putPermission(ObjectPermission objectPermission) throws RemoteException {
        return this.doPutPermission(objectPermission, true);
    }

    @Override
    public List<ObjectPermission> putPermissions(String uri, List<ObjectPermission> objectPermissions) throws RemoteException {
        for (ObjectPermission permission : objectPermissions) {
            permission.setURI("repo:" + uri);
        }
        return this.doPutPermissions("repo:" + uri, objectPermissions, false);
    }

    @Override
    public List<ObjectPermission> createPermissions(List<ObjectPermission> objectPermissions) throws RemoteException {
        return this.doPutPermissions(null, objectPermissions, true);
    }

    @Override
    public void deletePermission(ObjectPermission objectPermission) throws RemoteException {
        this.changePermissionConsistencyCheck(objectPermission);
        this.auditHelper.createAuditEvent("deletePermission");
        this.objectPermissionService.deleteObjectPermission(this.makeExecutionContext(), objectPermission);
        this.auditHelper.closeAuditEvent("deletePermission");
    }

    @Override
    public ObjectPermission newObjectPermission() {
        return this.objectPermissionService.newObjectPermission(this.makeExecutionContext());
    }

    @Override
    public int getAppliedPermissionMaskForObjectAndCurrentUser(String targetURI) throws RemoteException {
        Resource resource = this.repositoryService.getResource(this.makeExecutionContext(), targetURI);
        if (resource == null && (resource = this.repositoryService.getFolder(this.makeExecutionContext(), targetURI)) == null) {
            throw new RemoteException("There is no resource or folder for target URI \"" + targetURI + "\"");
        }
        HashSet<Integer> allUserPermissions = null;
        List<Object> currentUserRecipients = this.getCurrentUserRecipients();
        if (currentUserRecipients != null && currentUserRecipients.size() > 0) {
            allUserPermissions = new HashSet<Integer>();
            for (Object recipient : this.getCurrentUserRecipients()) {
                List permissions = this.objectPermissionService.getObjectPermissionsForObjectAndRecipient(this.makeExecutionContext(), (Object)resource, recipient);
                if (permissions != null && !permissions.isEmpty()) {
                    ObjectPermission permissionObject = (ObjectPermission)permissions.get(0);
                    allUserPermissions.add(permissionObject.getPermissionMask());
                    continue;
                }
                allUserPermissions.add(this.objectPermissionService.getInheritedObjectPermissionMask(this.makeExecutionContext(), (Object)resource, recipient));
            }
        }
        if (allUserPermissions != null && allUserPermissions.size() > 0) {
            JasperServerAclEntry jasperServerAclEntry = new JasperServerAclEntry();
            return jasperServerAclEntry.printPermissionsOverlappingBlock(allUserPermissions);
        }
        return 0;
    }

    protected List<Object> getCurrentUserRecipients() {
        Authentication authenticationToken = SecurityContextHolder.getContext().getAuthentication();
        ArrayList<Object> recipients = new ArrayList<Object>();
        if (authenticationToken.getPrincipal() instanceof User) {
            User user = (User)authenticationToken.getPrincipal();
            recipients.add(user);
            recipients.addAll(user.getRoles());
            return recipients;
        }
        return null;
    }

    protected void changePermissionConsistencyCheck(ObjectPermission objectPermission) throws RemoteException {
        if (StringUtils.isBlank((String)objectPermission.getURI())) {
            throw new IllegalParameterValueException("URI is blank", "uri", objectPermission.getURI());
        }
        if (objectPermission.getPermissionRecipient() == null) {
            throw new IllegalParameterValueException("recepient", "null");
        }
        if (!ALLOWED_MASKS.contains(objectPermission.getPermissionMask())) {
            throw new IllegalParameterValueException("mask", new Integer(objectPermission.getPermissionMask()).toString());
        }
        if (objectPermission.getPermissionRecipient() instanceof PermissionsRecipientIdentity) {
            PermissionsRecipientIdentity identity = (PermissionsRecipientIdentity)objectPermission.getPermissionRecipient();
            objectPermission.setPermissionRecipient(this.resolveRecipientObject(identity.getRecipientClass(), identity.getId()));
        }
        this.resolveResource(objectPermission.getURI());
        this.validateRecipientPermissions(objectPermission);
    }

    protected void validateRecipientPermissions(ObjectPermission objectPermission) throws ModificationNotAllowedException {
        String roleName;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        BasicAclEntry[] effectiveAcls = (BasicAclEntry[])this.aclService.getAcls((Object)objectPermission.getURI(), authentication);
        LinkedList<Object> forbiddenRecipients = new LinkedList<Object>();
        for (BasicAclEntry entry : effectiveAcls) {
            if (!entry.isPermitted(JasperServerAclEntry.ADMINISTRATION)) continue;
            forbiddenRecipients.add(entry.getRecipient());
        }
        if (forbiddenRecipients.contains(objectPermission.getPermissionRecipient()) && forbiddenRecipients.size() < 2) {
            throw new ModificationNotAllowedException("");
        }
        if (objectPermission.getPermissionRecipient() instanceof Role && this.administrativeRolesNames.contains(roleName = ((Role)objectPermission.getPermissionRecipient()).getRoleName())) {
            boolean allow = false;
            for (GrantedAuthority authority : authentication.getAuthorities()) {
                if (!authority.getAuthority().equals(roleName)) continue;
                allow = true;
            }
            if (!allow) {
                throw new ModificationNotAllowedException(roleName);
            }
        }
    }

    public void setObjectPermissionService(ObjectPermissionService objectPermissionService) {
        this.objectPermissionService = objectPermissionService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setUserAuthorityService(UserAuthorityService userAuthorityService) {
        this.userAuthorityService = userAuthorityService;
    }

    protected ExecutionContext makeExecutionContext() {
        return ExecutionContextImpl.getRuntimeExecutionContext();
    }

    protected ObjectPermission doPutPermission(ObjectPermission objectPermission, boolean allowUpdate) throws RemoteException {
        String auditEventType;
        this.changePermissionConsistencyCheck(objectPermission);
        ObjectPermission existingObjectPermission = this.objectPermissionService.getObjectPermission(this.makeExecutionContext(), objectPermission);
        if (existingObjectPermission == null) {
            auditEventType = "createPermission";
        } else if (allowUpdate) {
            auditEventType = "updatePermission";
        } else {
            throw new ResourceAlreadyExistsException(objectPermission.getURI() + ";" + ((InternalURI)objectPermission.getPermissionRecipient()).getURI());
        }
        this.auditHelper.createAuditEvent(auditEventType);
        this.objectPermissionService.putObjectPermission(this.makeExecutionContext(), objectPermission);
        this.auditHelper.closeAuditEvent(auditEventType);
        return this.objectPermissionService.getObjectPermission(this.makeExecutionContext(), objectPermission);
    }

    protected List<ObjectPermission> doPutPermissions(String uri, List<ObjectPermission> objectPermissions, boolean addTo) throws RemoteException {
        if (!addTo) {
            List<ObjectPermission> existing = this.getPermissions(uri, null, null, false, false);
            for (ObjectPermission permission : existing) {
                this.deletePermission(permission);
            }
        }
        LinkedList<ObjectPermission> result = new LinkedList<ObjectPermission>();
        for (ObjectPermission permission : objectPermissions) {
            result.add(this.createPermission(permission));
        }
        return result;
    }

    private List<ObjectPermission> toPermission(BasicAclEntry[] acls) {
        AbstractList result;
        if (acls != null) {
            result = new ArrayList(acls.length);
            for (BasicAclEntry entry : acls) {
                if (entry.getRecipient() instanceof String) continue;
                ObjectPermissionImpl permission = new ObjectPermissionImpl();
                permission.setPermissionRecipient(entry.getRecipient());
                permission.setPermissionMask(entry.getMask());
                permission.setURI(((ObjectPermissionServiceImpl.URIObjectIdentity)entry.getAclObjectIdentity()).getURI());
                result.add((ObjectPermission)permission);
            }
        } else {
            result = new LinkedList<ObjectPermission>();
        }
        return result;
    }

    protected Object resolveRecipientObject(Class<?> clazz, String id) throws ResourceNotFoundException {
        RoleImpl res = null;
        if (Role.class.equals(clazz)) {
            RoleImpl role = new RoleImpl();
            role.setRoleName(id);
            res = role;
        }
        if (User.class.equals(clazz)) {
            UserImpl user = new UserImpl();
            user.setUsername(id);
            res = user;
        }
        if (this.persistentObjectResolver.getPersistentObject(res) == null) {
            throw new ResourceNotFoundException(clazz.getSimpleName() + " " + id);
        }
        return res;
    }

    protected Resource resolveResource(String uri) throws RemoteException {
        if (uri.startsWith("repo:")) {
            uri = uri.substring("repo:".length());
        }
        if (!this.objectPermissionService.isObjectAdministrable(null, (Object)uri)) {
            throw new AccessDeniedException("Access denied", uri);
        }
        Resource resource = this.repositoryService.getResource(this.makeExecutionContext(), uri);
        if (resource == null) {
            resource = this.repositoryService.getFolder(this.makeExecutionContext(), uri);
        }
        if (resource == null) {
            throw new ResourceNotFoundException(uri);
        }
        return resource;
    }

    protected boolean isSameId(Object permissionRecipient, String recipientId) {
        return permissionRecipient instanceof User && ((User)permissionRecipient).getUsername().equals(recipientId) || permissionRecipient instanceof Role && ((Role)permissionRecipient).getRoleName().equals(recipientId);
    }

    protected List<ObjectPermission> filterByType(List<ObjectPermission> data, Class<?> recipientType) {
        LinkedList<ObjectPermission> result = new LinkedList<ObjectPermission>();
        for (ObjectPermission permission : data) {
            if (!recipientType.isInstance(permission.getPermissionRecipient())) continue;
            result.add(permission);
        }
        return result;
    }

    protected List<ObjectPermission> filterById(List<ObjectPermission> data, String recipientId) {
        LinkedList<ObjectPermission> result = new LinkedList<ObjectPermission>();
        for (ObjectPermission permission : data) {
            if (!this.isSameId(permission.getPermissionRecipient(), recipientId)) continue;
            result.add(permission);
        }
        return result;
    }

    protected Authentication createAuthentication(Role role) {
        GrantedAuthority[] grantedAuthorities = new GrantedAuthority[]{new GrantedAuthorityImpl(role.getRoleName())};
        MetadataUserDetails dummy = new MetadataUserDetails((User)new UserImpl());
        dummy.setUsername("dummyUserdummyUserdummyUserdummyUserdummyUser");
        return new UsernamePasswordAuthenticationToken((Object)dummy, null, grantedAuthorities);
    }

    protected Authentication createAuthentication(User user) {
        GrantedAuthority[] grantedAuthorities = new GrantedAuthority[user.getRoles().size()];
        Role[] roles = user.getRoles().toArray(new Role[user.getRoles().size()]);
        for (int i = 0; i < roles.length; ++i) {
            grantedAuthorities[i] = new GrantedAuthorityImpl(roles[i].getRoleName());
        }
        return new UsernamePasswordAuthenticationToken((Object)new MetadataUserDetails(user), null, grantedAuthorities);
    }

    private List<ObjectPermission> resolveAll(String resourceURI, Class<?> recipientType, String recipientId, boolean effectivePermissions) throws RemoteException {
        List<ObjectPermission> res;
        if (recipientType == null) {
            res = this.resolveAllUsers(resourceURI, recipientId, effectivePermissions);
            res.addAll(this.resolveAllRoles(resourceURI, recipientId));
        } else {
            res = recipientType.equals(User.class) ? this.resolveAllUsers(resourceURI, recipientId, effectivePermissions) : this.resolveAllRoles(resourceURI, recipientId);
        }
        return res;
    }

    private List<ObjectPermission> resolveAllRoles(String resourceURI, String recipientId) throws RemoteException {
        List roles = this.getRolesForResource(resourceURI, recipientId);
        Resource resource = this.resolveResource(resourceURI);
        LinkedList<ObjectPermission> res = new LinkedList<ObjectPermission>();
        for (Role role : roles) {
            res.add(this.getEffectivePermission(resource, role));
        }
        return res;
    }

    private List<ObjectPermission> resolveAllUsers(String resourceURI, String recipientId, boolean effectivePermissions) throws RemoteException {
        List<User> users = this.getUsersForResource(resourceURI, recipientId);
        Resource resource = this.resolveResource(resourceURI);
        LinkedList<ObjectPermission> res = new LinkedList<ObjectPermission>();
        for (User user : users) {
            ObjectPermission permission;
            if (effectivePermissions) {
                permission = this.getEffectivePermission(resource, user);
            } else {
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)user, null, new GrantedAuthority[0]);
                permission = this.getEffectivePermission(resource, (Authentication)authentication);
            }
            res.add(permission);
        }
        return res;
    }

    protected List<User> getUsersForResource(String resourceURI, String recipientId) {
        return this.userAuthorityService.getTenantUsers(null, null, recipientId);
    }

    protected List getRolesForResource(String resourceURI, String recipientId) {
        return this.userAuthorityService.getTenantRoles(null, null, recipientId);
    }

    static {
        HashSet<Integer> set = new HashSet<Integer>();
        for (Permission perm : Permission.values()) {
            set.add(perm.getMask());
        }
        ALLOWED_MASKS = Collections.unmodifiableSet(set);
    }
}

