/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobIdHolder;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobRuntimeInformation;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSummary;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobNotFoundException;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobsScheduler;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportSchedulingService;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.exception.MandatoryParameterNotFoundException;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.exception.ResourceAlreadyExistsException;
import com.jaspersoft.jasperserver.remote.exception.ResourceNotFoundException;
import com.jaspersoft.jasperserver.remote.services.JobsService;
import com.jaspersoft.jasperserver.remote.services.impl.ReportJobCalendar;
import com.jaspersoft.jasperserver.remote.utils.AuditHelper;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TimeZone;
import javax.annotation.Resource;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.impl.calendar.AnnualCalendar;
import org.quartz.impl.calendar.BaseCalendar;
import org.quartz.impl.calendar.CronCalendar;
import org.quartz.impl.calendar.DailyCalendar;
import org.quartz.impl.calendar.HolidayCalendar;
import org.quartz.impl.calendar.MonthlyCalendar;
import org.quartz.impl.calendar.WeeklyCalendar;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component(value="jobsService")
public class JobsServiceImpl
implements JobsService {
    @Resource(name="concreteReportSchedulingService")
    private ReportSchedulingService scheduler;
    @Resource
    private AuditHelper auditHelper;
    @Resource(name="reportScheduler")
    private ReportJobsScheduler reportScheduler;

    public void setReportScheduler(ReportJobsScheduler reportScheduler) {
        this.reportScheduler = reportScheduler;
    }

    @Override
    public void deleteJob(long id) throws RemoteException {
        this.auditHelper.createAuditEvent("deleteReportScheduling");
        this.scheduler.removeScheduledJob(this.makeExecutionContext(), id);
        this.auditHelper.closeAuditEvent("deleteReportScheduling");
    }

    @Override
    public void deleteJobs(long[] ids) throws RemoteException {
        this.scheduler.removeScheduledJobs(this.makeExecutionContext(), ids);
    }

    @Override
    public ReportJob getJob(long id) throws RemoteException {
        return this.scheduler.getScheduledJob(this.makeExecutionContext(), id);
    }

    @Override
    public ReportJob scheduleJob(ReportJob reportJob) throws RemoteException {
        reportJob.setVersion(-1);
        reportJob.setCreationDate(new Timestamp(GregorianCalendar.getInstance().getTimeInMillis()));
        if (reportJob.getAlert() != null) {
            reportJob.getAlert().setVersion(-1);
        }
        this.auditHelper.createAuditEvent("scheduleReport");
        ReportJob savedJob = this.scheduler.scheduleJob(this.makeExecutionContext(), reportJob);
        this.auditHelper.closeAuditEvent("scheduleReport");
        return savedJob;
    }

    @Override
    public ReportJob updateJob(ReportJob reportJob) throws RemoteException {
        ExecutionContext executionContext = this.makeExecutionContext();
        this.auditHelper.createAuditEvent("updateReportScheduling");
        this.scheduler.updateScheduledJob(executionContext, reportJob);
        this.auditHelper.closeAuditEvent("updateReportScheduling");
        return this.scheduler.getScheduledJob(executionContext, reportJob.getId());
    }

    @Override
    public List<ReportJobSummary> getAllJobs() throws RemoteException {
        return this.scheduler.getScheduledJobSummaries(this.makeExecutionContext());
    }

    @Override
    public List<ReportJobSummary> getJobSummariesByExample(ReportJobModel reportJobCriteria, Integer startIndex, Integer numberOfRows, ReportJobModel.ReportJobSortType sortType, Boolean isAscending) throws RemoteException {
        return this.scheduler.getScheduledJobSummaries(this.makeExecutionContext(), reportJobCriteria, startIndex != null ? startIndex : 0, numberOfRows != null ? numberOfRows : -1, sortType != null ? sortType : ReportJobModel.ReportJobSortType.NONE, isAscending != null ? isAscending : true);
    }

    @Override
    public List<ReportJobSummary> getReportJobs(String reportURI) throws RemoteException {
        return this.scheduler.getScheduledJobSummaries(this.makeExecutionContext(), reportURI);
    }

    @Override
    public ReportJobRuntimeInformation getReportJobState(long jobId) throws RemoteException {
        return this.getJob(jobId) != null ? this.scheduler.getJobRuntimeInformation(this.makeExecutionContext(), jobId) : null;
    }

    @Override
    public void updateReportJobs(List<Long> jobIds, ReportJobModel jobModel, Boolean replaceTriggerIgnoreType) {
        this.scheduler.updateScheduledJobsByID(this.makeExecutionContext(), this.getHolders(jobIds), jobModel, replaceTriggerIgnoreType.booleanValue());
    }

    @Override
    public void pause(List<Long> jobIds) {
        this.scheduler.pauseById(this.getHolders(jobIds), this.isAllJobs(jobIds).booleanValue());
    }

    @Override
    public void resume(List<Long> jobIds) {
        this.scheduler.resumeById(this.getHolders(jobIds), this.isAllJobs(jobIds).booleanValue());
    }

    @Override
    public void scheduleJobsOnceNow(List<Long> jobIds) throws ResourceNotFoundException {
        try {
            this.scheduler.scheduleJobsOnceNowById(this.makeExecutionContext(), this.getHolders(jobIds));
        }
        catch (JSException e) {
            if (e.getCause() instanceof ReportJobNotFoundException) {
                Object[] arguments = ((ReportJobNotFoundException)e.getCause()).getArgs();
                throw new ResourceNotFoundException(arguments != null && arguments.length > 0 ? arguments[0].toString() : "");
            }
            throw e;
        }
    }

    @Override
    public List<String> getCalendarNames() throws RemoteException {
        return this.reportScheduler.getCalendarNames();
    }

    @Override
    public void deleteCalendar(String calendarName) {
        this.reportScheduler.deleteCalendar(calendarName);
    }

    @Override
    public void addCalendar(String calendarName, ReportJobCalendar jobCalendar, Boolean replace, Boolean updateTriggers) throws MandatoryParameterNotFoundException, ResourceAlreadyExistsException, IllegalParameterValueException {
        try {
            this.reportScheduler.addCalendar(calendarName, this.toQuarzCalendar(jobCalendar), replace.booleanValue(), updateTriggers.booleanValue());
        }
        catch (JSException e) {
            if (e.getCause() != null && e.getCause() instanceof ObjectAlreadyExistsException) {
                throw new ResourceAlreadyExistsException(calendarName);
            }
            throw e;
        }
    }

    @Override
    public ReportJobCalendar getCalendar(String calendarName) {
        return this.toServiceObject(this.reportScheduler.getCalendar(calendarName));
    }

    protected ReportJobCalendar toServiceObject(org.quartz.Calendar calendar) {
        ReportJobCalendar jobCalendar = null;
        if (calendar != null) {
            jobCalendar = new ReportJobCalendar();
            ReportJobCalendar.Type calendarType = ReportJobCalendar.Type.getTypeForClass(calendar.getClass());
            jobCalendar.setCalendarType(calendarType);
            jobCalendar.setBaseCalendar(this.toServiceObject(calendar.getBaseCalendar()));
            if (calendar instanceof BaseCalendar) {
                jobCalendar.setTimeZone(((BaseCalendar)calendar).getTimeZone());
            }
            jobCalendar.setDescription(calendar.getDescription());
            switch (calendarType) {
                case annual: {
                    jobCalendar.setExcludeDays(((AnnualCalendar)calendar).getDaysExcluded());
                    break;
                }
                case base: {
                    break;
                }
                case cron: {
                    jobCalendar.setCronExpression(((CronCalendar)calendar).getCronExpression() != null ? ((CronCalendar)calendar).getCronExpression().toString() : null);
                    break;
                }
                case daily: {
                    DailyCalendar dailyCalendar = (DailyCalendar)calendar;
                    Calendar simpleCalendar = dailyCalendar.getTimeZone() == null ? Calendar.getInstance() : Calendar.getInstance(dailyCalendar.getTimeZone());
                    simpleCalendar.setTime(new Date(dailyCalendar.getTimeRangeStartingTimeInMillis(simpleCalendar.getTimeInMillis())));
                    jobCalendar.setRangeStartingCalendar(simpleCalendar);
                    simpleCalendar = dailyCalendar.getTimeZone() == null ? Calendar.getInstance() : Calendar.getInstance(dailyCalendar.getTimeZone());
                    simpleCalendar.setTime(new Date(dailyCalendar.getTimeRangeEndingTimeInMillis(simpleCalendar.getTimeInMillis())));
                    jobCalendar.setRangeEndingCalendar(simpleCalendar);
                    jobCalendar.setInvertTimeRange(dailyCalendar.getInvertTimeRange());
                    break;
                }
                case holiday: {
                    SortedSet dates = ((HolidayCalendar)calendar).getExcludedDates();
                    if (dates == null || dates.isEmpty()) break;
                    ArrayList<Calendar> excludeDays = new ArrayList<Calendar>();
                    for (Date currentDate : dates) {
                        Calendar currentCalendar = Calendar.getInstance();
                        currentCalendar.setTime(currentDate);
                        excludeDays.add(currentCalendar);
                    }
                    jobCalendar.setExcludeDays(excludeDays);
                    break;
                }
                case monthly: {
                    jobCalendar.setExcludeDaysFlags(((MonthlyCalendar)calendar).getDaysExcluded());
                    break;
                }
                case weekly: {
                    boolean[] oneIndexedFlags = ((WeeklyCalendar)calendar).getDaysExcluded();
                    boolean[] zerroIndexedFlags = new boolean[7];
                    for (int i = 0; i < zerroIndexedFlags.length; ++i) {
                        zerroIndexedFlags[i] = oneIndexedFlags[i + 1];
                    }
                    jobCalendar.setExcludeDaysFlags(zerroIndexedFlags);
                }
            }
        }
        return jobCalendar;
    }

    protected org.quartz.Calendar toQuarzCalendar(ReportJobCalendar jobCalendar) throws MandatoryParameterNotFoundException, IllegalParameterValueException {
        CronCalendar result = null;
        if (jobCalendar == null) {
            throw new MandatoryParameterNotFoundException("reportJobCalendar");
        }
        if (jobCalendar.getCalendarType() == null) {
            throw new MandatoryParameterNotFoundException("reportJobCalendar.calendarType");
        }
        org.quartz.Calendar baseCalendar = jobCalendar.getBaseCalendar() != null ? this.toQuarzCalendar(jobCalendar.getBaseCalendar()) : null;
        ReportJobCalendar.Type type = jobCalendar.getCalendarType();
        TimeZone timeZone = jobCalendar.getTimeZone() != null ? jobCalendar.getTimeZone() : TimeZone.getDefault();
        switch (type) {
            case base: {
                BaseCalendar newBaseCalendar = new BaseCalendar(baseCalendar, timeZone);
                newBaseCalendar.setDescription(jobCalendar.getDescription());
                result = newBaseCalendar;
                break;
            }
            case annual: {
                AnnualCalendar annualCalendar = new AnnualCalendar(baseCalendar, timeZone);
                annualCalendar.setDaysExcluded(jobCalendar.getExcludeDays());
                result = annualCalendar;
                break;
            }
            case cron: {
                try {
                    result = new CronCalendar(baseCalendar, jobCalendar.getCronExpression(), timeZone);
                    break;
                }
                catch (ParseException e) {
                    throw new IllegalParameterValueException("Couldn't parse cron expression", "reportJobCalendar.cronExpression", jobCalendar.getCronExpression());
                }
            }
            case daily: {
                if (jobCalendar.getRangeStartingCalendar() == null) {
                    throw new MandatoryParameterNotFoundException("reportJobCalendar.rangeStartingCalendar");
                }
                if (jobCalendar.getRangeEndingCalendar() == null) {
                    throw new MandatoryParameterNotFoundException("reportJobCalendar.rangeEndingCalendar");
                }
                try {
                    DailyCalendar dailyCalendar = new DailyCalendar(jobCalendar.getRangeStartingCalendar(), jobCalendar.getRangeEndingCalendar());
                    dailyCalendar.setBaseCalendar(baseCalendar);
                    dailyCalendar.setTimeZone(timeZone);
                    dailyCalendar.setInvertTimeRange(jobCalendar.isInvertTimeRange() != null ? jobCalendar.isInvertTimeRange() : false);
                    result = dailyCalendar;
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalParameterValueException(e.getMessage(), "reportJobCalendar.rangeStartingCalendar", DateFormat.getDateTimeInstance(2, 2, LocaleContextHolder.getLocale()).format(jobCalendar.getRangeStartingCalendar().getTime()), "reportJobCalendar.rangeEndingCalendar", DateFormat.getDateTimeInstance(2, 2, LocaleContextHolder.getLocale()).format(jobCalendar.getRangeEndingCalendar().getTime()));
                }
            }
            case holiday: {
                HolidayCalendar holidayCalendar = new HolidayCalendar();
                holidayCalendar.setBaseCalendar(baseCalendar);
                if (jobCalendar.getExcludeDays() != null && !jobCalendar.getExcludeDays().isEmpty()) {
                    for (Calendar currentCalendar : jobCalendar.getExcludeDays()) {
                        holidayCalendar.addExcludedDate(currentCalendar.getTime());
                    }
                }
                holidayCalendar.setTimeZone(timeZone);
                result = holidayCalendar;
                break;
            }
            case monthly: {
                if (jobCalendar.getExcludeDaysFlags() == null) {
                    throw new MandatoryParameterNotFoundException("reportJobCalendar.excludeDaysFlags");
                }
                if (jobCalendar.getExcludeDaysFlags() != null && jobCalendar.getExcludeDaysFlags().length < 31) {
                    throw new IllegalParameterValueException("The days parameter must have a length of at least 31 elements.", "reportJobCalendar.excludeDaysFlags", "" + jobCalendar.getExcludeDaysFlags().length);
                }
                MonthlyCalendar monthlyCalendar = new MonthlyCalendar(baseCalendar, timeZone);
                monthlyCalendar.setDaysExcluded(jobCalendar.getExcludeDaysFlags());
                result = monthlyCalendar;
                break;
            }
            case weekly: {
                WeeklyCalendar weeklyCalendar = new WeeklyCalendar(baseCalendar, timeZone);
                if (jobCalendar.getExcludeDaysFlags() == null) {
                    throw new MandatoryParameterNotFoundException("reportJobCalendar.excludeDaysFlags");
                }
                if (jobCalendar.getExcludeDaysFlags() != null && jobCalendar.getExcludeDaysFlags().length < 7) {
                    throw new IllegalParameterValueException("The days parameter must have a length of at least 7 elements.", "reportJobCalendar.excludeDaysFlags", "" + jobCalendar.getExcludeDaysFlags().length);
                }
                boolean[] zerroIndexedFlags = jobCalendar.getExcludeDaysFlags();
                boolean[] oneIndexedFlags = new boolean[8];
                for (int i = 1; i < oneIndexedFlags.length; ++i) {
                    oneIndexedFlags[i] = zerroIndexedFlags[i - 1];
                }
                weeklyCalendar.setDaysExcluded(oneIndexedFlags);
                result = weeklyCalendar;
            }
        }
        if (result != null) {
            result.setDescription(jobCalendar.getDescription());
        }
        return result;
    }

    protected Boolean isAllJobs(List<Long> jobIds) {
        return jobIds == null || jobIds.isEmpty();
    }

    protected List<ReportJobIdHolder> getHolders(List<Long> jobIds) {
        ArrayList<ReportJobIdHolder> holders = new ArrayList<ReportJobIdHolder>();
        if (jobIds != null && !jobIds.isEmpty()) {
            for (Long jobId : jobIds) {
                holders.add(new ReportJobIdHolder(jobId.longValue()));
            }
        }
        return holders;
    }

    protected ExecutionContext makeExecutionContext() {
        ExecutionContextImpl executionContext = new ExecutionContextImpl();
        executionContext.setLocale(this.getLocale());
        return executionContext;
    }

    protected Locale getLocale() {
        return LocaleContextHolder.getLocale();
    }

    public ReportSchedulingService getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(ReportSchedulingService scheduler) {
        this.scheduler = scheduler;
    }

    public AuditHelper getAuditHelper() {
        return this.auditHelper;
    }

    public void setAuditHelper(AuditHelper auditHelper) {
        this.auditHelper = auditHelper;
    }
}

