/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services.async;

import com.jaspersoft.jasperserver.export.service.ImportFailedException;
import com.jaspersoft.jasperserver.remote.services.async.BaseImportExportTaskRunnable;
import com.jaspersoft.jasperserver.remote.services.async.StateDto;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportRunnable
extends BaseImportExportTaskRunnable<StateDto> {
    protected static final Log log = LogFactory.getLog(ImportRunnable.class);

    public ImportRunnable(Map<String, Boolean> exportParams, InputStream stream) throws Exception {
        this.parameters = exportParams;
        this.file = this.copyToTempFile(stream);
        this.state = new StateDto();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.service.doImport(this.file, this.parameters);
            this.state.setPhase("finished");
            this.state.setMessage(this.localize("import.finished"));
        }
        catch (ImportFailedException e) {
            this.state.setPhase("failed");
            this.state.setMessage(e.getMessage());
            log.error((Object)"Import failed: ", (Throwable)e);
        }
        finally {
            if (!this.file.delete()) {
                log.error((Object)("Can't delete temp file " + this.file.getAbsolutePath()));
            }
        }
    }

    protected File copyToTempFile(InputStream input) throws IOException {
        File tmp = File.createTempFile("import_", null);
        FileOutputStream fileStream = new FileOutputStream(tmp);
        byte[] buff = new byte[512];
        int read = input.read(buff);
        while (read > 0) {
            fileStream.write(buff, 0, read);
            read = input.read(buff);
        }
        fileStream.flush();
        fileStream.close();
        return tmp;
    }

    public StateDto getResult() {
        return this.state;
    }

    @Override
    public void prepare() {
        this.state.setMessage(this.localize("import.in.progress"));
    }
}

