/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services.async;

import com.jaspersoft.jasperserver.remote.exception.NoResultException;
import com.jaspersoft.jasperserver.remote.exception.NotReadyResultException;
import com.jaspersoft.jasperserver.remote.services.async.BaseImportExportTaskRunnable;
import com.jaspersoft.jasperserver.remote.services.async.StateDto;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExportRunnable
extends BaseImportExportTaskRunnable<InputStream> {
    protected static final Log log = LogFactory.getLog(ExportRunnable.class);
    private List<String> urisOfResources;
    private List<String> urisOfScheduledJobs;
    private List<String> rolesToExport;
    private List<String> usersToExport;
    private FileOutputStream fileOutputStream;

    public ExportRunnable(Map<String, Boolean> exportParams, List<String> urisOfResources, List<String> urisOfScheduledJobs, List<String> rolesToExport, List<String> usersToExport) {
        this.parameters = exportParams;
        this.urisOfResources = urisOfResources;
        this.urisOfScheduledJobs = urisOfScheduledJobs;
        this.rolesToExport = rolesToExport;
        this.usersToExport = usersToExport;
        this.state = new StateDto();
    }

    @Override
    public void run() {
        block6: {
            if (this.state.getPhase() != null && this.state.getPhase().equals("failed")) {
                return;
            }
            try {
                if (this.file == null) {
                    this.file = File.createTempFile("export_", null);
                    this.fileOutputStream = new FileOutputStream(this.file);
                }
                this.state.setMessage(this.localize("export.in.progress"));
                this.service.doExport((OutputStream)this.fileOutputStream, this.parameters, this.urisOfResources, this.urisOfScheduledJobs, this.rolesToExport, this.usersToExport);
                this.fileOutputStream.close();
                this.state.setPhase("finished");
                this.state.setMessage(this.localize("export.finished"));
            }
            catch (Exception e) {
                log.error((Object)"Export failed: ", (Throwable)e);
                this.state.setPhase("failed");
                this.state.setMessage(this.localize("export.failed"));
                if (this.file == null) break block6;
                try {
                    this.fileOutputStream.close();
                }
                catch (IOException ioe) {
                    log.error((Object)("Can't close output stream " + this.file.getAbsolutePath()));
                }
                if (this.file.delete()) break block6;
                log.error((Object)("Can't delete temp file " + this.file.getAbsolutePath()));
            }
        }
    }

    public InputStream getResult() throws NotReadyResultException, NoResultException {
        FileInputStream inputStream = null;
        if (this.getState().getPhase().equals("finished")) {
            try {
                inputStream = new FileInputStream(this.file);
                return inputStream;
            }
            catch (IOException io) {
                String message = "Can't read temp file" + this.file.getAbsolutePath();
                log.error((Object)message);
                throw new NoResultException("Can't get export result");
            }
        }
        throw new NotReadyResultException("Export hasn't completed yet");
    }

    @Override
    public void prepare() {
        this.state.setMessage(this.localize("export.in.progress"));
    }
}

