/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services.async;

import com.jaspersoft.jasperserver.remote.exception.NoSuchTaskException;
import com.jaspersoft.jasperserver.remote.services.async.StateDto;
import com.jaspersoft.jasperserver.remote.services.async.Task;
import com.jaspersoft.jasperserver.remote.services.async.TasksManager;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Component;

@Component
public class BasicTasksManager
implements TasksManager {
    protected Map<String, Task> tasks = new ConcurrentHashMap<String, Task>();

    public BasicTasksManager(Map<String, Task> tasks) {
        this.tasks = new ConcurrentHashMap<String, Task>(tasks);
    }

    public BasicTasksManager() {
    }

    protected String generateUniqueId() {
        String uuid = UUID.randomUUID().toString();
        if (this.tasks.containsKey(uuid)) {
            uuid = this.generateUniqueId();
        }
        return uuid;
    }

    @Override
    public StateDto startTask(Task task) {
        StateDto stateDto = task.getState();
        stateDto.setPhase("inprogress");
        String uuid = this.generateUniqueId();
        task.setUniqueId(uuid);
        stateDto.setId(uuid);
        this.tasks.put(uuid, task);
        task.start();
        return stateDto;
    }

    @Override
    public Task getTask(String taskId) throws NoSuchTaskException {
        if (this.tasks.containsKey(taskId)) {
            return this.tasks.get(taskId);
        }
        throw new NoSuchTaskException(taskId);
    }

    @Override
    public void finishTask(String taskId) throws NoSuchTaskException {
        this.getTask(taskId).stop();
        this.tasks.remove(taskId);
    }

    @Override
    public StateDto getTaskState(String taskId) throws NoSuchTaskException {
        return this.getTask(taskId).getState();
    }
}

