/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.resources.converters;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.dto.resources.ClientFile;
import com.jaspersoft.jasperserver.dto.resources.ClientReference;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceable;
import com.jaspersoft.jasperserver.dto.resources.ClientResourceLookup;
import com.jaspersoft.jasperserver.dto.resources.ClientUriHolder;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.exception.MandatoryParameterNotFoundException;
import com.jaspersoft.jasperserver.remote.resources.GenericParametersReflectionHelper;
import com.jaspersoft.jasperserver.remote.resources.converters.ClientReferenceRestriction;
import com.jaspersoft.jasperserver.remote.resources.converters.ResourceConverterProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ResourceReferenceConverter<T extends ClientReferenceable> {
    protected final ResourceConverterProvider resourceConverterProvider;
    protected final RepositoryService repositoryService;
    protected final List<ClientReferenceRestriction> restrictions = new ArrayList<ClientReferenceRestriction>();

    public ResourceReferenceConverter(ResourceConverterProvider resourceConverterProvider, RepositoryService repositoryService, ClientReferenceRestriction ... restriction) {
        this.repositoryService = repositoryService;
        this.resourceConverterProvider = resourceConverterProvider;
        if (restriction != null) {
            this.restrictions.addAll(Arrays.asList(restriction));
        }
    }

    public ResourceReferenceConverter<T> addReferenceRestriction(ClientReferenceRestriction restriction) {
        this.restrictions.add(restriction);
        return this;
    }

    public T toClient(ResourceReference serverObject) throws ClassCastException {
        ClientReference result = null;
        if (serverObject != null) {
            if (serverObject.isLocal()) {
                Resource localResource = serverObject.getLocalResource();
                result = (ClientUriHolder)this.resourceConverterProvider.getToClientConverter(localResource).toClient((Resource)localResource);
            } else {
                result = new ClientReference(serverObject.getReferenceURI());
            }
        }
        return (T)((ClientReferenceable)result);
    }

    public ResourceReference toServer(T clientObject) throws IllegalParameterValueException, MandatoryParameterNotFoundException {
        return this.toServer(clientObject, null);
    }

    public ResourceReference toServer(T clientObject, ResourceReference resultToUpdate) throws IllegalParameterValueException, MandatoryParameterNotFoundException {
        ResourceReference resourceReference;
        if (clientObject == null) {
            resourceReference = null;
        } else if (clientObject.getClass() == ClientReference.class) {
            resourceReference = this.toServerReference(clientObject, resultToUpdate);
        } else if (clientObject instanceof ClientResourceLookup) {
            resourceReference = this.toServerLocalResource((ClientResourceLookup)clientObject, resultToUpdate);
        } else {
            throw new IllegalParameterValueException("References of type " + GenericParametersReflectionHelper.extractClientType(clientObject.getClass()) + " are not supported", new String[0]);
        }
        return resourceReference;
    }

    protected ResourceReference toServerReference(T clientObject, ResourceReference resultToUpdate) throws IllegalParameterValueException {
        ResourceReference result;
        String uriFromClient = clientObject.getUri();
        if (resultToUpdate != null && !resultToUpdate.isLocal() && resultToUpdate.getReferenceURI().equals(uriFromClient)) {
            result = resultToUpdate;
        } else {
            this.validateReference(uriFromClient);
            if (resultToUpdate == null) {
                result = new ResourceReference(uriFromClient);
            } else {
                resultToUpdate.setReference(uriFromClient);
                result = resultToUpdate;
            }
        }
        return result;
    }

    protected void validateReference(String referenceUri) throws IllegalParameterValueException {
        if (referenceUri == null) {
            throw new IllegalParameterValueException("resourceLookup.uri", "null");
        }
        Resource resource = this.repositoryService.getResource(null, referenceUri);
        if (resource == null) {
            throw new IllegalParameterValueException("Referenced resource doesn't exist", "resourceLookup.uri", referenceUri);
        }
        if (!this.restrictions.isEmpty()) {
            ClientResourceLookup clientTargetObject = this.resourceConverterProvider.getToClientConverter(resource).toClient((Resource)resource);
            for (ClientReferenceRestriction restriction : this.restrictions) {
                restriction.validateReference(clientTargetObject);
            }
        }
    }

    protected ResourceReference toServerLocalResource(ClientResourceLookup clientObject, ResourceReference resultToUpdate) throws IllegalParameterValueException, MandatoryParameterNotFoundException {
        ResourceReference result;
        Resource localResource = this.resourceConverterProvider.getToServerConverter(clientObject).toServer((ClientResourceLookup)clientObject);
        if (localResource.getName() == null) {
            localResource.setName(clientObject.getLabel());
        }
        if (resultToUpdate != null) {
            result = resultToUpdate;
            result.setLocalResource(localResource);
        } else {
            result = new ResourceReference(localResource);
        }
        return result;
    }

    public static class FileTypeRestriction
    implements ClientReferenceRestriction {
        private final ClientFile.FileType fileType;
        private final String fieldName;

        public FileTypeRestriction(ClientFile.FileType fileType) {
            this(fileType, null);
        }

        public FileTypeRestriction(ClientFile.FileType fileType, String fieldName) {
            this.fileType = fileType;
            this.fieldName = fieldName;
        }

        @Override
        public void validateReference(ClientResourceLookup clientResource) throws IllegalParameterValueException {
            if (clientResource instanceof ClientFile && this.fileType != ((ClientFile)clientResource).getType()) {
                throw new IllegalParameterValueException("Reference target is of wrong type", this.fieldName != null ? this.fieldName : "file.type", clientResource.getUri(), ((ClientFile)clientResource).getType().name());
            }
        }
    }

    public static class ReferenceClassRestriction
    implements ClientReferenceRestriction {
        protected final Class<? extends ClientReferenceable> targetClientClass;

        public ReferenceClassRestriction(Class<? extends ClientReferenceable> targetClientClass) {
            this.targetClientClass = targetClientClass;
        }

        @Override
        public void validateReference(ClientResourceLookup clientResource) throws IllegalParameterValueException {
            if (!this.targetClientClass.isAssignableFrom(clientResource.getClass())) {
                throw new IllegalParameterValueException("Reference target is of wrong type", "resourceLookup.uri", clientResource.getUri(), GenericParametersReflectionHelper.extractClientType(clientResource.getClass()));
            }
        }
    }
}

