/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.resources.converters;

import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.dto.resources.ClientInputControl;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableDataType;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableListOfValues;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableQuery;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.exception.MandatoryParameterNotFoundException;
import com.jaspersoft.jasperserver.remote.resources.converters.ResourceConverterImpl;
import com.jaspersoft.jasperserver.remote.resources.converters.ResourceReferenceConverter;
import com.jaspersoft.jasperserver.remote.resources.converters.ResourceReferenceConverterProvider;
import java.util.Arrays;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class InputControlResourceConverter
extends ResourceConverterImpl<InputControl, ClientInputControl> {
    @Resource(name="resourceReferenceConverterProvider")
    private ResourceReferenceConverterProvider resourceConverterProvider;

    @Override
    protected InputControl resourceSpecificFieldsToServer(ClientInputControl clientObject, InputControl resultToUpdate) throws IllegalParameterValueException, MandatoryParameterNotFoundException {
        ResourceReferenceConverter<ClientReferenceableDataType> dataTypeConverter = this.resourceConverterProvider.getConverterForType(ClientReferenceableDataType.class);
        ResourceReferenceConverter<ClientReferenceableListOfValues> lovConverter = this.resourceConverterProvider.getConverterForType(ClientReferenceableListOfValues.class);
        ResourceReferenceConverter<ClientReferenceableQuery> queryConverter = this.resourceConverterProvider.getConverterForType(ClientReferenceableQuery.class);
        resultToUpdate.setDataType(dataTypeConverter.toServer(clientObject.getDataType()));
        resultToUpdate.setListOfValues(lovConverter.toServer(clientObject.getListOfValues()));
        resultToUpdate.setQuery(queryConverter.toServer(clientObject.getQuery()));
        resultToUpdate.setMandatory(clientObject.isMandatory());
        resultToUpdate.setReadOnly(clientObject.isReadOnly());
        resultToUpdate.setVisible(clientObject.isVisible());
        resultToUpdate.setType(clientObject.getType());
        resultToUpdate.setQueryValueColumn(clientObject.getValueColumn());
        for (String column : clientObject.getVisibleColumns()) {
            resultToUpdate.addQueryVisibleColumn(column);
        }
        return resultToUpdate;
    }

    @Override
    protected ClientInputControl resourceSpecificFieldsToClient(ClientInputControl client, InputControl serverObject) {
        ResourceReferenceConverter<ClientReferenceableDataType> dataTypeConverter = this.resourceConverterProvider.getConverterForType(ClientReferenceableDataType.class);
        ResourceReferenceConverter<ClientReferenceableListOfValues> lovConverter = this.resourceConverterProvider.getConverterForType(ClientReferenceableListOfValues.class);
        ResourceReferenceConverter<ClientReferenceableQuery> queryConverter = this.resourceConverterProvider.getConverterForType(ClientReferenceableQuery.class);
        client.setDataType(dataTypeConverter.toClient(serverObject.getDataType()));
        client.setListOfValues(lovConverter.toClient(serverObject.getListOfValues()));
        client.setQuery(queryConverter.toClient(serverObject.getQuery()));
        client.setMandatory(serverObject.isMandatory());
        client.setReadOnly(serverObject.isReadOnly());
        client.setVisible(serverObject.isVisible());
        client.setType(serverObject.getType());
        client.setValueColumn(serverObject.getQueryValueColumn());
        client.setVisibleColumns(Arrays.asList(serverObject.getQueryVisibleColumns()));
        return client;
    }
}

