/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.resources.converters;

import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.CustomReportDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientCustomDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientProperty;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.resources.converters.ResourceConverterImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class CustomDataSourceResourceConverter
extends ResourceConverterImpl<CustomReportDataSource, ClientCustomDataSource> {
    @Override
    protected CustomReportDataSource resourceSpecificFieldsToServer(ClientCustomDataSource clientObject, CustomReportDataSource resultToUpdate) throws IllegalParameterValueException {
        resultToUpdate.setDataSourceName(clientObject.getDataSourceName());
        resultToUpdate.setServiceClass(clientObject.getServiceClass());
        HashMap<String, String> properties = null;
        if (clientObject.getProperties() != null && !clientObject.getProperties().isEmpty()) {
            properties = new HashMap<String, String>(clientObject.getProperties().size());
            for (ClientProperty property : clientObject.getProperties()) {
                properties.put(property.getKey(), property.getValue());
            }
        }
        resultToUpdate.setPropertyMap(properties);
        return resultToUpdate;
    }

    @Override
    protected ClientCustomDataSource resourceSpecificFieldsToClient(ClientCustomDataSource client, CustomReportDataSource serverObject) {
        client.setDataSourceName(serverObject.getDataSourceName());
        client.setServiceClass(serverObject.getServiceClass());
        ArrayList<ClientProperty> properties = null;
        Map propertyMap = serverObject.getPropertyMap();
        if (propertyMap != null && !propertyMap.isEmpty()) {
            properties = new ArrayList<ClientProperty>(propertyMap.size());
            Set set = propertyMap.keySet();
            for (String key : set) {
                properties.add(new ClientProperty(key, (String)propertyMap.get(key)));
            }
        }
        client.setProperties(properties);
        return client;
    }
}

