/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.handlers;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.VirtualReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.handlers.RepositoryResourceHandler;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="remoteVirtualDataSourceHandler")
public class VirtualDataSourceHandler
extends RepositoryResourceHandler {
    @Override
    public Class getResourceType() {
        return VirtualReportDataSource.class;
    }

    @Override
    protected void doGet(Resource resource, ResourceDescriptor descriptor, Map options) throws ServiceException {
        VirtualReportDataSource dsResource = (VirtualReportDataSource)resource;
        descriptor.setWsType("virtual");
        for (Map.Entry entry : dsResource.getDataSourceUriMap().entrySet()) {
            ResourceDescriptor rdDs = new ResourceDescriptor();
            rdDs.setWsType("datasource");
            rdDs.setReferenceUri(((ResourceReference)entry.getValue()).getReferenceURI());
            rdDs.setIsReference(true);
            rdDs.setResourceProperty("PROP_DATASOURCE_SUB_DS_ID", (String)entry.getKey());
            descriptor.getChildren().add(rdDs);
        }
    }

    @Override
    protected void updateResource(Resource resource, ResourceDescriptor descriptor, Map options) {
        super.updateResource(resource, descriptor, options);
        VirtualReportDataSource dsResource = (VirtualReportDataSource)resource;
        dsResource.getDataSourceUriMap().clear();
        for (ResourceDescriptor subResource : descriptor.getChildren()) {
            String subDsId = subResource.getResourcePropertyValue("PROP_DATASOURCE_SUB_DS_ID");
            if (!"datasource".equals(subResource.getWsType()) || subDsId == null) continue;
            ResourceReference rr = new ResourceReference(subResource.getReferenceUri());
            dsResource.getDataSourceUriMap().put(subDsId, rr);
        }
    }
}

