/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.handlers;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrorFilter;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.common.domain.impl.UniversalValidationErrorFilter;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.api.search.SearchCriteria;
import com.jaspersoft.jasperserver.api.search.SearchFilter;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.handlers.AbstractResourceHandler;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Service;

@Service
public class FolderHandler
extends AbstractResourceHandler {
    private static final Log log = LogFactory.getLog(FolderHandler.class);

    @Override
    public Class getResourceType() {
        return Folder.class;
    }

    @Override
    protected void doGet(Resource resource, ResourceDescriptor descriptor, Map options) throws ServiceException {
        descriptor.setWsType("folder");
        descriptor.setHasData(false);
    }

    @Override
    public SearchFilter getSearchFilter(String uri, String queryString, String wsType, boolean recursive, int maxItems, int startIndex) {
        return new SearchFilter(){

            public void applyRestrictions(String type, ExecutionContext context, SearchCriteria criteria) {
                criteria.add((Criterion)Restrictions.eq((String)"hidden", (Object)false));
            }
        };
    }

    protected void validate(RepositoryService repository, Folder folder) throws ServiceException {
        Object filter = folder.isNew() ? UniversalValidationErrorFilter.getInstance() : null;
        ValidationErrors errors = repository.validateFolder(null, folder, (ValidationErrorFilter)filter);
        if (errors.isError()) {
            throw new ServiceException(403, errors.toString());
        }
    }
}

