/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.handlers;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.AwsReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.handlers.JdbcDataSourceHandler;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class AwsDataSourceHandler
extends JdbcDataSourceHandler {
    @Override
    public Class getResourceType() {
        return AwsReportDataSource.class;
    }

    @Override
    protected void doGet(Resource resource, ResourceDescriptor descriptor, Map options) throws ServiceException {
        super.doGet(resource, descriptor, options);
        AwsReportDataSource dsResource = (AwsReportDataSource)resource;
        descriptor.setAwsAccessKey(dsResource.getAWSAccessKey());
        descriptor.setAwsSecretKey(dsResource.getAWSSecretKey());
        descriptor.setAwsRoleARN(dsResource.getRoleARN());
        descriptor.setAwsRegion(dsResource.getAWSRegion());
        descriptor.setAwsDbName(dsResource.getDbName());
        descriptor.setAwsDbService(dsResource.getDbService());
        descriptor.setAwsDbInstanceIdentifier(dsResource.getDbInstanceIdentifier());
        descriptor.setWsType("aws");
    }

    @Override
    protected void updateResource(Resource resource, ResourceDescriptor descriptor, Map options) {
        super.updateResource(resource, descriptor, options);
        AwsReportDataSource awsReportDataSource = (AwsReportDataSource)resource;
        awsReportDataSource.setAWSAccessKey(descriptor.getAwsAccessKey());
        awsReportDataSource.setAWSSecretKey(descriptor.getAwsSecretKey());
        awsReportDataSource.setRoleARN(descriptor.getAwsRoleARN());
        awsReportDataSource.setAWSRegion(descriptor.getAwsRegion());
        awsReportDataSource.setDbName(descriptor.getAwsDbName());
        awsReportDataSource.setDbService(descriptor.getAwsDbService());
        awsReportDataSource.setDbInstanceIdentifier(descriptor.getAwsDbInstanceIdentifier());
    }
}

