/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.exception.xml;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ErrorDescriptor {
    public static final String ERROR_CODE_UNEXPECTED_ERROR = "unexpected.error";
    private String message;
    private String errorCode;
    private String[] parameters;

    public ErrorDescriptor() {
    }

    public ErrorDescriptor(Throwable cause) {
        this.errorCode = ERROR_CODE_UNEXPECTED_ERROR;
        this.message = "Unexpected error";
        this.parameters = new String[]{cause.getClass().getName() + (cause.getMessage() != null && !"".equals(cause.getMessage()) ? ": " + cause.getMessage() : "")};
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    @XmlElementWrapper(name="parameters")
    @XmlElement(name="parameter")
    public String[] getParameters() {
        return this.parameters;
    }

    public void setParameters(String ... parameters) {
        this.parameters = parameters;
    }

    public void setParameters(Object ... args) {
        if (args != null && args.length > 0) {
            String[] params = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                params[i] = args[i].toString();
            }
            this.parameters = params;
        }
    }

    public static class Builder {
        private ErrorDescriptor errorDescriptor = new ErrorDescriptor();

        public Builder setMessage(String message) {
            this.errorDescriptor.setMessage(message);
            return this;
        }

        public Builder setErrorCode(String errorCode) {
            this.errorDescriptor.setErrorCode(errorCode);
            return this;
        }

        public Builder setParameters(String ... parameters) {
            this.errorDescriptor.setParameters(parameters);
            return this;
        }

        public Builder setParameters(Object ... args) {
            this.errorDescriptor.setParameters(args);
            return this;
        }

        public ErrorDescriptor getErrorDescriptor() {
            return this.errorDescriptor;
        }
    }
}

