/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbmaintainer.script.parsingstate.impl;

import org.unitils.dbmaintainer.script.StatementBuilder;
import org.unitils.dbmaintainer.script.parsingstate.ParsingState;
import org.unitils.dbmaintainer.script.parsingstate.impl.NormalParsingState;

public class OracleNormalParsingState
extends NormalParsingState {
    protected boolean parsingCodeBlock;
    protected StringBuilder lineBuffer = new StringBuilder();
    protected StringBuilder statementBuffer = new StringBuilder();

    protected ParsingState getNextParsingState(char previousChar, char currentChar, char nextChar, StatementBuilder statementBuilder) {
        ParsingState nextParsingState;
        if (currentChar == '\n' || currentChar == '\r') {
            String trimmedLine = this.lineBuffer.toString().trim();
            this.lineBuffer.setLength(0);
            if ("/".equals(trimmedLine)) {
                this.parsingCodeBlock = false;
                this.statementBuffer.setLength(0);
                return null;
            }
        } else {
            this.lineBuffer.append(currentChar);
        }
        if (!this.parsingCodeBlock && this.statementBuffer.length() < 100) {
            if (Character.isWhitespace(currentChar)) {
                int statementBufferLength = this.statementBuffer.length();
                if (statementBufferLength != 0 && this.statementBuffer.charAt(statementBufferLength - 1) != ' ') {
                    this.statementBuffer.append(' ');
                }
            } else if (Character.isLetter(currentChar)) {
                this.statementBuffer.append(Character.toUpperCase(currentChar));
            }
            if (this.isStartOfCodeStatement(this.statementBuffer)) {
                this.parsingCodeBlock = true;
                this.statementBuffer.setLength(0);
                return this;
            }
        }
        if ((nextParsingState = super.getNextParsingState(previousChar, currentChar, nextChar, statementBuilder)) == null) {
            if (this.parsingCodeBlock) {
                return this;
            }
            this.statementBuffer.setLength(0);
            this.lineBuffer.setLength(0);
        }
        return nextParsingState;
    }

    protected boolean isStartOfCodeStatement(StringBuilder statement) {
        return this.matches("CREATE PACKAGE", statement) || this.matches("CREATE OR REPLACE PACKAGE", statement) || this.matches("CREATE LIBRARY", statement) || this.matches("CREATE OR REPLACE LIBRARY", statement) || this.matches("CREATE FUNCTION", statement) || this.matches("CREATE OR REPLACE FUNCTION", statement) || this.matches("CREATE PROCEDURE", statement) || this.matches("CREATE OR REPLACE PROCEDURE", statement) || this.matches("CREATE TRIGGER", statement) || this.matches("CREATE OR REPLACE TRIGGER", statement) || this.matches("CREATE TYPE", statement) || this.matches("CREATE OR REPLACE TYPE", statement) || this.matches("DECLARE", statement) || this.matches("BEGIN", statement);
    }

    protected boolean matches(String text, StringBuilder statement) {
        if (text.length() != statement.length()) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == statement.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

