/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbmaintainer.script.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.core.UnitilsException;
import org.unitils.core.util.BaseConfigurable;
import org.unitils.dbmaintainer.script.ExecutedScript;
import org.unitils.dbmaintainer.script.Script;
import org.unitils.dbmaintainer.script.ScriptContentHandle;
import org.unitils.dbmaintainer.script.ScriptSource;
import org.unitils.dbmaintainer.version.Version;
import org.unitils.util.FileUtils;
import org.unitils.util.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScriptSource
extends BaseConfigurable
implements ScriptSource {
    private static final Log logger = LogFactory.getLog(DefaultScriptSource.class);
    public static final String PROPKEY_SCRIPT_LOCATIONS = "dbMaintainer.script.locations";
    public static final String PROPKEY_SCRIPT_EXTENSIONS = "dbMaintainer.script.fileExtensions";
    public static final String PROPKEY_POSTPROCESSINGSCRIPT_DIRNAME = "dbMaintainer.postProcessingScript.directoryName";
    public static final String PROPKEY_USESCRIPTFILELASTMODIFICATIONDATES = "dbMaintainer.useScriptFileLastModificationDates.enabled";
    protected List<Script> allUpdateScripts;
    protected List<Script> allPostProcessingScripts;

    @Override
    public List<Script> getAllUpdateScripts() {
        if (this.allUpdateScripts == null) {
            this.loadAndOrganizeAllScripts();
        }
        return this.allUpdateScripts;
    }

    protected List<Script> getIncrementalScripts() {
        List<Script> scripts = this.getAllUpdateScripts();
        ArrayList<Script> indexedScripts = new ArrayList<Script>();
        for (Script script : scripts) {
            if (!script.isIncremental()) continue;
            indexedScripts.add(script);
        }
        return indexedScripts;
    }

    protected void assertNoDuplicateIndexes(List<Script> scripts) {
        for (int i = 0; i < scripts.size() - 1; ++i) {
            Script script1 = scripts.get(i);
            Script script2 = scripts.get(i + 1);
            if (!script1.isIncremental() || !script2.isIncremental() || !script1.getVersion().equals(script2.getVersion())) continue;
            throw new UnitilsException("Found 2 database scripts with the same version index: " + script1.getFileName() + " and " + script2.getFileName() + " both have version index " + script1.getVersion().getIndexesString());
        }
    }

    @Override
    public List<Script> getNewScripts(Version currentVersion, Set<ExecutedScript> alreadyExecutedScripts) {
        Map<String, Script> alreadyExecutedScriptMap = this.convertToScriptNameScriptMap(alreadyExecutedScripts);
        ArrayList<Script> result = new ArrayList<Script>();
        List<Script> allScripts = this.getAllUpdateScripts();
        for (Script script : allScripts) {
            Script alreadyExecutedScript = alreadyExecutedScriptMap.get(script.getFileName());
            if (script.isIncremental() && script.getVersion().compareTo(currentVersion) > 0) {
                result.add(script);
                continue;
            }
            if (!script.isIncremental() && alreadyExecutedScript == null) {
                result.add(script);
                continue;
            }
            if (script.isIncremental() || alreadyExecutedScript.isScriptContentEqualTo(script, this.useScriptFileLastModificationDates())) continue;
            logger.info((Object)("Contents of script " + script.getFileName() + " have changed since the last database update: " + script.getCheckSum()));
            result.add(script);
        }
        return result;
    }

    @Override
    public boolean isExistingIndexedScriptModified(Version currentVersion, Set<ExecutedScript> alreadyExecutedScripts) {
        Map<String, Script> alreadyExecutedScriptMap = this.convertToScriptNameScriptMap(alreadyExecutedScripts);
        List<Script> incrementalScripts = this.getIncrementalScripts();
        for (ExecutedScript alreadyExecutedScript : alreadyExecutedScripts) {
            if (!alreadyExecutedScript.getScript().isIncremental() || Collections.binarySearch(incrementalScripts, alreadyExecutedScript.getScript()) >= 0) continue;
            logger.warn((Object)("Existing indexed script found that was executed, which has been removed: " + alreadyExecutedScript.getScript().getFileName()));
            return true;
        }
        for (Script indexedScript : incrementalScripts) {
            if (indexedScript.getVersion().compareTo(currentVersion) > 0) continue;
            Script alreadyExecutedScript = alreadyExecutedScriptMap.get(indexedScript.getFileName());
            if (alreadyExecutedScript == null) {
                logger.warn((Object)("New index script has been added, with at least one already executed script having an higher index." + indexedScript.getFileName()));
                return true;
            }
            if (alreadyExecutedScript.isScriptContentEqualTo(indexedScript, this.useScriptFileLastModificationDates())) continue;
            logger.warn((Object)("Script found of which the contents have changed: " + indexedScript.getFileName()));
            return true;
        }
        return false;
    }

    protected boolean useScriptFileLastModificationDates() {
        return PropertyUtils.getBoolean(PROPKEY_USESCRIPTFILELASTMODIFICATIONDATES, this.configuration);
    }

    @Override
    public List<Script> getPostProcessingScripts() {
        if (this.allPostProcessingScripts == null) {
            this.loadAndOrganizeAllScripts();
        }
        return this.allPostProcessingScripts;
    }

    protected void loadAndOrganizeAllScripts() {
        List<Script> allScripts = this.loadAllScripts();
        this.allUpdateScripts = new ArrayList<Script>();
        this.allPostProcessingScripts = new ArrayList<Script>();
        for (Script script : allScripts) {
            if (this.isPostProcessingScript(script)) {
                this.allPostProcessingScripts.add(script);
                continue;
            }
            this.allUpdateScripts.add(script);
        }
        Collections.sort(this.allUpdateScripts);
        this.assertNoDuplicateIndexes(this.allUpdateScripts);
        Collections.sort(this.allPostProcessingScripts);
        this.assertNoDuplicateIndexes(this.allPostProcessingScripts);
    }

    protected List<Script> loadAllScripts() {
        List<String> scriptLocations = PropertyUtils.getStringList(PROPKEY_SCRIPT_LOCATIONS, this.configuration);
        ArrayList<Script> scripts = new ArrayList<Script>();
        for (String scriptLocation : scriptLocations) {
            if (!new File(scriptLocation).exists()) {
                throw new UnitilsException("File location " + scriptLocation + " defined in property " + PROPKEY_SCRIPT_LOCATIONS + " doesn't exist");
            }
            this.getScriptsAt(scripts, scriptLocation, "");
        }
        return scripts;
    }

    protected void getScriptsAt(List<Script> scripts, String scriptRoot, String relativeLocation) {
        File currentLocation = new File(scriptRoot + "/" + relativeLocation);
        if (currentLocation.isFile() && this.isScriptFile(currentLocation)) {
            Script script = this.createScript(currentLocation, relativeLocation);
            scripts.add(script);
            return;
        }
        if (currentLocation.isDirectory()) {
            for (File subLocation : currentLocation.listFiles()) {
                this.getScriptsAt(scripts, scriptRoot, "".equals(relativeLocation) ? subLocation.getName() : relativeLocation + "/" + subLocation.getName());
            }
        }
    }

    protected boolean isPostProcessingScript(Script script) {
        List<String> startsWiths = PropertyUtils.getStringList(PROPKEY_POSTPROCESSINGSCRIPT_DIRNAME, this.configuration);
        for (String startsWith : startsWiths) {
            if (!script.getFileName().startsWith(startsWith)) continue;
            return true;
        }
        return false;
    }

    protected boolean isScriptFile(File file) {
        String name = file.getName();
        for (String fileExtension : this.getScriptExtensions()) {
            if (!name.endsWith(fileExtension)) continue;
            return true;
        }
        return false;
    }

    protected Script createScript(File scriptFile, String relativePath) {
        return new Script(relativePath, (Long)scriptFile.lastModified(), new ScriptContentHandle.UrlScriptContentHandle(FileUtils.getUrl(scriptFile)));
    }

    protected List<String> getScriptExtensions() {
        List<String> extensions = PropertyUtils.getStringList(PROPKEY_SCRIPT_EXTENSIONS, this.configuration);
        if (extensions.isEmpty()) {
            logger.warn((Object)"No extensions are specificied using the property dbMaintainer.script.fileExtensions. The Unitils database maintainer won't do anyting");
        }
        for (String extension : extensions) {
            if (!extension.startsWith(".")) continue;
            throw new UnitilsException("DefaultScriptSource file extension defined by dbMaintainer.script.fileExtensions should not start with a '.'");
        }
        return extensions;
    }

    protected Map<String, Script> convertToScriptNameScriptMap(Set<ExecutedScript> executedScripts) {
        HashMap<String, Script> scriptMap = new HashMap<String, Script>();
        for (ExecutedScript executedScript : executedScripts) {
            scriptMap.put(executedScript.getScript().getFileName(), executedScript.getScript());
        }
        return scriptMap;
    }
}

