/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.guice;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import java.util.Iterator;
import org.directwebremoting.AjaxFilter;
import org.directwebremoting.extend.AjaxFilterManager;
import org.directwebremoting.guice.DwrGuiceUtil;
import org.directwebremoting.guice.Filtering;
import org.directwebremoting.guice.InternalAjaxFilter;
import org.directwebremoting.impl.DefaultAjaxFilterManager;
import org.directwebremoting.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalAjaxFilterManager
implements AjaxFilterManager {
    private final AjaxFilterManager ajaxFilterManager = InternalAjaxFilterManager.getAjaxFilterManager();
    private static final ThreadLocal<String> typeName = new ThreadLocal();
    private static final Logger log = Logger.getLogger(InternalAjaxFilterManager.class);

    public InternalAjaxFilterManager() {
        this.addAjaxFilters();
    }

    @Override
    public Iterator<AjaxFilter> getAjaxFilters(String scriptname) {
        return this.ajaxFilterManager.getAjaxFilters(scriptname);
    }

    @Override
    public void addAjaxFilter(AjaxFilter filter) {
        this.ajaxFilterManager.addAjaxFilter(filter);
    }

    @Override
    public void addAjaxFilter(AjaxFilter filter, String scriptname) {
        this.ajaxFilterManager.addAjaxFilter(filter, scriptname);
    }

    private void addAjaxFilters() {
        Injector injector = DwrGuiceUtil.getInjector();
        for (Key key : injector.getBindings().keySet()) {
            Class atype = key.getAnnotationType();
            if (atype == null || !Filtering.class.isAssignableFrom(atype)) continue;
            String scriptName = ((Filtering)Filtering.class.cast(key.getAnnotation())).value();
            Provider provider = injector.getProvider(key);
            if ("".equals(scriptName)) {
                this.addAjaxFilter(new InternalAjaxFilter((Provider<AjaxFilter>)provider));
                continue;
            }
            this.addAjaxFilter(new InternalAjaxFilter((Provider<AjaxFilter>)provider), scriptName);
        }
    }

    static void setTypeName(String name) {
        typeName.set(name);
    }

    private static AjaxFilterManager getAjaxFilterManager() {
        String name = typeName.get();
        try {
            Class<?> cls = Class.forName(name);
            return (AjaxFilterManager)cls.newInstance();
        }
        catch (Exception e) {
            if (name != null && !"".equals(name)) {
                log.warn("Couldn't make AjaxFilterManager from type: " + name);
            }
            return new DefaultAjaxFilterManager();
        }
    }
}

