/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.tenant.service.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.logging.diagnostic.domain.DiagnosticAttribute;
import com.jaspersoft.jasperserver.api.logging.diagnostic.helper.DiagnosticAttributeBuilder;
import com.jaspersoft.jasperserver.api.logging.diagnostic.service.Diagnostic;
import com.jaspersoft.jasperserver.api.logging.diagnostic.service.DiagnosticCallback;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDaoImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.util.IlikeEscapeAwareExpression;
import com.jaspersoft.jasperserver.api.metadata.common.util.DatabaseCharactersEscapeResolver;
import com.jaspersoft.jasperserver.api.metadata.tenant.service.TenantPersistenceResolver;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoTenant;
import com.jaspersoft.jasperserver.api.metadata.user.service.TenantService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
public class TenantServiceImpl
extends HibernateDaoImpl
implements TenantService,
TenantPersistenceResolver,
Diagnostic {
    Pattern patternTenantByURI = Pattern.compile("^(?:/organizations/([^/]+))*/?.*");
    protected static final Log log = LogFactory.getLog(TenantServiceImpl.class);
    private ResourceFactory objectMappingFactory;
    private ResourceFactory persistentClassFactory;
    private String userOrgIdDelimiter;
    private DatabaseCharactersEscapeResolver databaseCharactersEscapeResolver;
    private boolean isTenantCaseSensitive;

    public void setDatabaseCharactersEscapeResolver(DatabaseCharactersEscapeResolver databaseCharactersEscapeResolver) {
        this.databaseCharactersEscapeResolver = databaseCharactersEscapeResolver;
    }

    public ResourceFactory getPersistentClassFactory() {
        return this.persistentClassFactory;
    }

    public void setPersistentClassFactory(ResourceFactory persistentClassFactory) {
        this.persistentClassFactory = persistentClassFactory;
    }

    public ResourceFactory getObjectMappingFactory() {
        return this.objectMappingFactory;
    }

    public void setObjectMappingFactory(ResourceFactory objectFactory) {
        this.objectMappingFactory = objectFactory;
    }

    public boolean isTenantCaseSensitive() {
        return this.isTenantCaseSensitive;
    }

    public void setTenantCaseSensitive(boolean tenantCaseSensitive) {
        this.isTenantCaseSensitive = tenantCaseSensitive;
    }

    protected RepoTenant getRepoTenant(String tenantId, boolean required) {
        List tenantList = this.getHibernateTemplate().findByCriteria(this.createTenantSearchCriteria(tenantId, this.isTenantCaseSensitive));
        if (tenantList.size() > 1) {
            log.warn((Object)(tenantList.size() + " tenants were found during case insensitive search for \"" + tenantId + "\". Retrying case sensitive search."));
            tenantList = this.getHibernateTemplate().findByCriteria(this.createTenantSearchCriteria(tenantId, true));
        }
        return this.extractTenant(tenantId, required, tenantList);
    }

    private RepoTenant extractTenant(String tenantId, boolean required, List tenantList) {
        RepoTenant tenant = null;
        if (tenantList.isEmpty()) {
            if (required) {
                throw new JSException("Tenant not found with Tenant ID \"" + tenantId + "\"");
            }
            log.debug((Object)("Tenant not found with Tenant ID \"" + tenantId + "\"."));
        } else if (tenantList.size() == 1) {
            tenant = (RepoTenant)tenantList.get(0);
        }
        return tenant;
    }

    private DetachedCriteria createTenantSearchCriteria(String tenantId, boolean isCaseSensitive) {
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.persistentTenantClass());
        criteria.add((Criterion)(isCaseSensitive ? Restrictions.eq((String)"tenantId", (Object)tenantId) : Restrictions.ilike((String)"tenantId", (Object)tenantId)));
        criteria.getExecutableCriteria(this.getSession()).setCacheable(true);
        return criteria;
    }

    protected RepoTenant getRepoTenantByAlias(String tenantAlias, boolean required) {
        RepoTenant tenant;
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.persistentTenantClass());
        criteria.add((Criterion)Restrictions.eq((String)"tenantAlias", (Object)tenantAlias));
        criteria.getExecutableCriteria(this.getSession()).setCacheable(true);
        List tenantList = this.getHibernateTemplate().findByCriteria(criteria);
        if (tenantList.isEmpty()) {
            if (required) {
                throw new JSException("Tenant not found with Tenant Alias \"" + tenantAlias + "\"");
            }
            log.debug((Object)("Tenant not found with Tenant Alias \"" + tenantAlias + "\""));
            tenant = null;
        } else {
            tenant = (RepoTenant)tenantList.get(0);
        }
        return tenant;
    }

    protected Class persistentTenantClass() {
        return this.getPersistentClassFactory().getImplementationClass(Tenant.class);
    }

    protected RepoTenant getRepoTenantBasedOnTenantUri(ExecutionContext context, String tenantUri) {
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.persistentTenantClass());
        criteria.add((Criterion)Restrictions.eq((String)"tenantUri", (Object)tenantUri));
        criteria.getExecutableCriteria(this.getSession()).setCacheable(true);
        List tenantList = this.getHibernateTemplate().findByCriteria(criteria);
        RepoTenant tenant = null;
        if (tenantList.isEmpty()) {
            log.debug((Object)("Tenant not found with Tenant Name \"" + tenantUri + "\""));
        } else {
            tenant = (RepoTenant)tenantList.get(0);
        }
        return tenant;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void putTenant(ExecutionContext context, Tenant aTenant) {
        RepoTenant existingTenant = this.getRepoTenant(aTenant.getId(), false);
        if (existingTenant == null) {
            existingTenant = (RepoTenant)this.getPersistentClassFactory().newObject(Tenant.class);
        }
        existingTenant.copyFromClient(aTenant, this);
        this.getHibernateTemplate().saveOrUpdate((Object)existingTenant);
    }

    protected List getRepoSubTenants(ExecutionContext context, String parentTenantId) {
        RepoTenant parent = this.getRepoTenant(parentTenantId, false);
        if (parent == null || parent.getSubTenants() == null) {
            return new ArrayList(0);
        }
        return new ArrayList(parent.getSubTenants());
    }

    public List getSubTenantList(ExecutionContext context, Tenant parentTenant) {
        List persistentTenants = this.getRepoSubTenants(context, parentTenant.getId());
        return this.toClientTenantList(persistentTenants);
    }

    public List getSubTenantList(ExecutionContext context, String parnentTenantId) {
        List persistentTenants = this.getRepoSubTenants(context, parnentTenantId);
        return this.toClientTenantList(persistentTenants);
    }

    protected List<Tenant> toClientTenantList(List persistentTenants) {
        if (persistentTenants == null) {
            return null;
        }
        ArrayList<Tenant> tenants = new ArrayList<Tenant>(persistentTenants.size());
        for (Object persistentTenant1 : persistentTenants) {
            RepoTenant persistentTenant = (RepoTenant)persistentTenant1;
            Tenant tenant = this.toClientTenant(persistentTenant);
            tenants.add(tenant);
        }
        return tenants;
    }

    public Tenant getTenant(ExecutionContext context, String tenantId) {
        RepoTenant rTenant = this.getRepoTenant(tenantId, false);
        if (rTenant == null) {
            return null;
        }
        return this.toClientTenant(rTenant);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void deleteTenant(ExecutionContext context, String tenantId) {
        RepoTenant tenant = this.getRepoTenant(tenantId, false);
        if (tenant != null) {
            this.getHibernateTemplate().delete((Object)tenant);
            this.getHibernateTemplate().flush();
        } else if (log.isInfoEnabled()) {
            log.info((Object)("Tenant " + tenantId + " not found for deletion"));
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void updateTenant(ExecutionContext context, Tenant aTenant) {
        this.putTenant(context, aTenant);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public List getAllSubTenantList(ExecutionContext context, String parentTenantId) {
        return this.getAllSubTenantList(context, parentTenantId, null);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public List<String> getAllSubTenantIdList(ExecutionContext context, String parentTenantId) {
        ArrayList<String> subTenantIdList = new ArrayList<String>();
        RepoTenant parent = this.getRepoTenant(parentTenantId, false);
        if (parent != null) {
            DetachedCriteria criteria = this.createSubTenantsCriteria(parent, null, -1);
            criteria.getExecutableCriteria(this.getSession()).setCacheable(true);
            criteria.setProjection((Projection)Projections.property((String)"tenantId"));
            subTenantIdList.addAll(this.getHibernateTemplate().findByCriteria(criteria));
        }
        return subTenantIdList;
    }

    private DetachedCriteria createSubTenantsCriteria(RepoTenant parentTenant, String text, int depth) {
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.persistentTenantClass());
        String value = "/%";
        if ("/".equals(parentTenant.getTenantUri())) {
            criteria.add((Criterion)Restrictions.ne((String)"tenantId", (Object)parentTenant.getTenantId()));
        } else {
            value = parentTenant.getTenantUri() + value;
        }
        criteria.add((Criterion)Restrictions.like((String)"tenantUri", (Object)value));
        if (depth > 0) {
            StringBuilder boundary = new StringBuilder(value);
            while (depth > 0) {
                boundary.append("/%");
                --depth;
            }
            criteria.add(Restrictions.not((Criterion)Restrictions.like((String)"tenantUri", (Object)boundary.toString())));
        }
        if (text != null && (text = this.databaseCharactersEscapeResolver.getEscapedText(text.trim())).length() > 0) {
            Disjunction disjunction = Restrictions.disjunction();
            disjunction.add((Criterion)new IlikeEscapeAwareExpression("tenantId", text, MatchMode.ANYWHERE));
            disjunction.add((Criterion)new IlikeEscapeAwareExpression("tenantAlias", text, MatchMode.ANYWHERE));
            disjunction.add((Criterion)new IlikeEscapeAwareExpression("tenantName", text, MatchMode.ANYWHERE));
            disjunction.add((Criterion)new IlikeEscapeAwareExpression("tenantDesc", text, MatchMode.ANYWHERE));
            criteria.add((Criterion)disjunction);
        }
        return criteria;
    }

    private void getAllSubTenantListPrivate(String parentTenantId, ArrayList allSubTenants) {
        List subTenant = this.getSubTenantList(null, parentTenantId);
        for (int i = 0; i < subTenant.size(); ++i) {
            allSubTenants.add(subTenant.get(i));
            this.getAllSubTenantListPrivate(((Tenant)subTenant.get(i)).getId(), allSubTenants);
        }
    }

    public int getNumberOfTenants(ExecutionContext context) {
        List allTenants = this.getAllSubTenantList(null, "organizations");
        return allTenants.size();
    }

    public Tenant getDefaultTenant(ExecutionContext context) {
        List allTenants = this.getAllSubTenantList(null, "organizations");
        if (allTenants.size() == 1) {
            return (Tenant)allTenants.get(0);
        }
        return null;
    }

    public Tenant getTenantBasedOnTenantUri(ExecutionContext context, String tenantUri) {
        RepoTenant rTenant = this.getRepoTenantBasedOnTenantUri(context, tenantUri);
        if (rTenant == null) {
            return null;
        }
        Tenant tenant = this.toClientTenant(rTenant);
        return tenant;
    }

    protected Tenant toClientTenant(RepoTenant rTenant) {
        Tenant tenant = (Tenant)this.objectMappingFactory.newObject(Tenant.class);
        rTenant.copyToClient(tenant);
        return tenant;
    }

    public String getUserOrgIdDelimiter() {
        return this.userOrgIdDelimiter;
    }

    public void setUserOrgIdDelimiter(String userOrgIdDelimiter) {
        this.userOrgIdDelimiter = userOrgIdDelimiter;
    }

    public String getTenantIdBasedOnRepositoryUri(ExecutionContext context, String uri) {
        Matcher matcher = this.patternTenantByURI.matcher(uri);
        String possibleId = null;
        if (matcher.matches() && "org_template".equals(possibleId = matcher.group(1))) {
            possibleId = this.getTenantIdBasedOnRepositoryUri(context, uri.substring(0, uri.lastIndexOf("organizations")));
        }
        return possibleId;
    }

    public Tenant getTenantBasedOnRepositoryUri(ExecutionContext context, String uri) {
        String tenantId = this.getTenantIdBasedOnRepositoryUri(context, uri);
        if (tenantId != null) {
            return this.getTenant(context, tenantId);
        }
        return null;
    }

    public boolean isMultiTenantEnvironment(ExecutionContext context) {
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.persistentTenantClass());
        criteria.add((Criterion)Restrictions.ne((String)"tenantUri", (Object)"/"));
        criteria.getExecutableCriteria(this.getSession()).setCacheable(true);
        List tenantList = this.getHibernateTemplate().findByCriteria(criteria);
        return tenantList.size() > 1;
    }

    @Override
    public RepoTenant getPersistentTenant(String tenantId, boolean required) {
        if (tenantId == null || tenantId.length() == 0) {
            return null;
        }
        return this.getRepoTenant(tenantId, required);
    }

    @Override
    public RepoTenant getPersistentTenantByAlias(String tenantAlias, boolean required) {
        if (tenantAlias == null || tenantAlias.length() == 0) {
            return null;
        }
        return this.getRepoTenantByAlias(tenantAlias, required);
    }

    public String getUniqueTenantId(String proposedTenantId) {
        List similarTenantIdList;
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.persistentTenantClass());
        criteria.add((Criterion)Restrictions.like((String)"tenantId", (Object)(proposedTenantId + "%")).ignoreCase());
        criteria.getExecutableCriteria(this.getSession()).setCacheable(true);
        List tenantList = this.getHibernateTemplate().findByCriteria(criteria);
        if (tenantList.isEmpty()) {
            similarTenantIdList = Collections.emptyList();
        } else {
            similarTenantIdList = new ArrayList(tenantList.size());
            for (int i = 0; i < tenantList.size(); ++i) {
                similarTenantIdList.add(((RepoTenant)tenantList.get(i)).getTenantId());
            }
        }
        return this.getUniqueItem(proposedTenantId, similarTenantIdList);
    }

    private String getUniqueItem(String proposedItem, List similarItemsList) {
        String orgId;
        if (similarItemsList.size() == 0) {
            return proposedItem;
        }
        for (int i = 0; i < similarItemsList.size() && !(orgId = (String)similarItemsList.get(i)).equalsIgnoreCase(proposedItem); ++i) {
            if (i != similarItemsList.size() - 1) continue;
            return proposedItem;
        }
        int index = 1;
        boolean ready = false;
        block1: while (!ready) {
            for (int i = 0; i < similarItemsList.size(); ++i) {
                String orgId2 = (String)similarItemsList.get(i);
                if ((proposedItem + index).equalsIgnoreCase(orgId2)) {
                    ++index;
                    continue block1;
                }
                if (i != similarItemsList.size() - 1) continue;
                ready = true;
                proposedItem = proposedItem + index;
            }
        }
        return proposedItem;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public String getUniqueTenantAlias(String proposedAlias) {
        List similarAliasesAndTenantIdList;
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.persistentTenantClass());
        criteria.add((Criterion)Restrictions.like((String)"tenantAlias", (Object)(proposedAlias + "%")).ignoreCase());
        criteria.getExecutableCriteria(this.getSession()).setCacheable(true);
        List tenantAliasesList = this.getHibernateTemplate().findByCriteria(criteria);
        if (tenantAliasesList.isEmpty()) {
            similarAliasesAndTenantIdList = Collections.emptyList();
        } else {
            similarAliasesAndTenantIdList = new ArrayList(tenantAliasesList.size());
            for (int i = 0; i < tenantAliasesList.size(); ++i) {
                similarAliasesAndTenantIdList.add(((RepoTenant)tenantAliasesList.get(i)).getTenantAlias());
            }
        }
        criteria = DetachedCriteria.forClass((Class)this.persistentTenantClass());
        criteria.add((Criterion)Restrictions.like((String)"tenantId", (Object)(proposedAlias + "%")));
        criteria.getExecutableCriteria(this.getSession()).setCacheable(true);
        List tenantIdsList = this.getHibernateTemplate().findByCriteria(criteria);
        if (!tenantIdsList.isEmpty()) {
            if (similarAliasesAndTenantIdList.isEmpty()) {
                similarAliasesAndTenantIdList = new ArrayList(tenantIdsList.size());
            }
            for (int i = 0; i < tenantIdsList.size(); ++i) {
                similarAliasesAndTenantIdList.add(((RepoTenant)tenantIdsList.get(i)).getTenantId());
            }
        }
        return this.getUniqueItem(proposedAlias, similarAliasesAndTenantIdList);
    }

    public int getNumberOfUsers(ExecutionContext context, String tenantId) {
        return this.createNumberOfUsersOrRolesCriteria(tenantId, this.getPersistentClassFactory().getImplementationClass(User.class));
    }

    public int getNumberOfRoles(ExecutionContext context, String tenantId) {
        return this.createNumberOfUsersOrRolesCriteria(tenantId, this.getPersistentClassFactory().getImplementationClass(Role.class));
    }

    private int createNumberOfUsersOrRolesCriteria(String tenantId, Class aClass) {
        Integer rowCount = 0;
        RepoTenant tenant = this.getRepoTenant(tenantId, false);
        if (tenant != null) {
            DetachedCriteria criteria = DetachedCriteria.forClass((Class)aClass);
            criteria.createAlias("tenant", "t");
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"t.tenantUri", (Object)tenant.getTenantUri()), (Criterion)Restrictions.like((String)"t.tenantUri", (Object)(tenant.getTenantUri().equals("/") ? "/%" : tenant.getTenantUri() + "/%"))));
            criteria.setProjection((Projection)Projections.count((String)"id"));
            criteria.getExecutableCriteria(this.getSession()).setCacheable(true);
            List results = this.getHibernateTemplate().findByCriteria(criteria);
            if (results != null && !results.isEmpty()) {
                rowCount = (Integer)results.get(0);
            }
        }
        return rowCount;
    }

    public int getSubTenantsCount(ExecutionContext context, String parentTenantId, String text) {
        DetachedCriteria criteria = this.createSearchTenantsCriteria(parentTenantId, text);
        criteria.setProjection(Projections.rowCount());
        criteria.getExecutableCriteria(this.getSession()).setCacheable(true);
        List results = this.getHibernateTemplate().findByCriteria(criteria);
        if (results != null && !results.isEmpty()) {
            return (Integer)results.get(0);
        }
        return 0;
    }

    public List<Tenant> getSubTenants(ExecutionContext context, String parentTenantId, String text, int firstResult, int maxResults) {
        DetachedCriteria criteria = this.createSearchTenantsCriteria(parentTenantId, text);
        criteria.getExecutableCriteria(this.getSession()).setCacheable(true);
        List results = this.getHibernateTemplate().findByCriteria(criteria, firstResult, maxResults);
        return this.toClientTenantList(results);
    }

    private DetachedCriteria createSearchTenantsCriteria(String parentTenantId, String text) {
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.persistentTenantClass());
        criteria.createAlias("parent", "p");
        criteria.add((Criterion)Restrictions.naturalId().set("p.tenantId", (Object)parentTenantId));
        if (text != null && (text = this.databaseCharactersEscapeResolver.getEscapedText(text.trim())).length() > 0) {
            Disjunction disjunction = Restrictions.disjunction();
            disjunction.add((Criterion)new IlikeEscapeAwareExpression("tenantId", text, MatchMode.ANYWHERE));
            disjunction.add((Criterion)new IlikeEscapeAwareExpression("tenantAlias", text, MatchMode.ANYWHERE));
            disjunction.add((Criterion)new IlikeEscapeAwareExpression("tenantName", text, MatchMode.ANYWHERE));
            disjunction.add((Criterion)new IlikeEscapeAwareExpression("tenantDesc", text, MatchMode.ANYWHERE));
            criteria.add((Criterion)disjunction);
        }
        return criteria;
    }

    public Map<String, Integer> getSubTenantsCountMap(List<String> tenantIds) {
        if (tenantIds == null || tenantIds.size() == 0) {
            return Collections.emptyMap();
        }
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.persistentTenantClass());
        criteria.createAlias("parent", "p");
        criteria.add(Restrictions.in((String)"p.tenantId", tenantIds));
        criteria.setProjection((Projection)Projections.projectionList().add(Projections.rowCount()).add((Projection)Projections.groupProperty((String)"p.tenantId")));
        criteria.getExecutableCriteria(this.getSession()).setCacheable(true);
        List results = this.getHibernateTemplate().findByCriteria(criteria);
        HashMap<String, Integer> subTenantCounts = new HashMap<String, Integer>(tenantIds.size(), 1.0f);
        if (results != null && results.size() > 0) {
            for (String result : results) {
                String tenantId = (String)((Object[])result)[1];
                Integer count = (Integer)((Object[])result)[0];
                subTenantCounts.put(tenantId, count);
            }
        }
        for (String tenantId : tenantIds) {
            if (subTenantCounts.containsKey(tenantId)) continue;
            subTenantCounts.put(tenantId, 0);
        }
        return subTenantCounts;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void setTenantActiveTheme(ExecutionContext context, String tenantId, String themeName) {
        if (themeName == null) {
            throw new JSException("Theme name should not be null!");
        }
        Tenant tenant = this.getTenant(context, tenantId);
        if (tenant == null) {
            throw new JSException("Tenant not found : \"" + tenantId + "\"");
        }
        tenant.setTheme(themeName);
        this.putTenant(context, tenant);
    }

    public Map<DiagnosticAttribute, DiagnosticCallback> getDiagnosticData() {
        return new DiagnosticAttributeBuilder().addDiagnosticAttribute("TotalOrganizationsCount", (DiagnosticCallback)new DiagnosticCallback<Integer>(){

            public Integer getDiagnosticAttributeValue() {
                return TenantServiceImpl.this.getSubTenantsCount(null, "organizations", null);
            }
        }).build();
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public List<Tenant> getAllSubTenantList(ExecutionContext context, String parentTenantId, String text) {
        return this.getAllSubTenantList(context, parentTenantId, text, -1);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public List<Tenant> getAllSubTenantList(ExecutionContext context, String parentTenantId, String text, int depth) {
        ArrayList subTenantList = new ArrayList();
        RepoTenant parent = this.getRepoTenant(parentTenantId, false);
        if (parent != null) {
            DetachedCriteria criteria = this.createSubTenantsCriteria(parent, text, depth);
            criteria.getExecutableCriteria(this.getSession()).setCacheable(true);
            subTenantList.addAll(this.getHibernateTemplate().findByCriteria(criteria));
        }
        return this.toClientTenantList(subTenantList);
    }
}

