/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.security;

import com.jaspersoft.jasperserver.api.metadata.security.MethodArgumentAclVoter;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.security.Authentication;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.acl.AclManager;
import org.springframework.security.vote.AccessDecisionVoter;

public class MultiAclEntryVoter
implements AccessDecisionVoter {
    private ConfigAttribute configAttribute;
    private AclManager aclManager;
    private MethodArgumentAclVoter[] argumentVoters;

    public boolean supports(ConfigAttribute attribute) {
        return this.configAttribute.equals(attribute);
    }

    public boolean supports(Class clazz) {
        return MethodInvocation.class.isAssignableFrom(clazz);
    }

    public int vote(Authentication authentication, Object object, ConfigAttributeDefinition config) {
        int access;
        if (config.contains(this.configAttribute)) {
            MethodInvocation call = (MethodInvocation)object;
            access = 1;
            for (int i = 0; i < this.argumentVoters.length; ++i) {
                MethodArgumentAclVoter voter = this.argumentVoters[i];
                if (voter.allow(call, authentication, this.aclManager)) continue;
                access = -1;
                break;
            }
        } else {
            access = 0;
        }
        return access;
    }

    public ConfigAttribute getConfigAttribute() {
        return this.configAttribute;
    }

    public void setConfigAttribute(ConfigAttribute configAttribute) {
        this.configAttribute = configAttribute;
    }

    public MethodArgumentAclVoter[] getArgumentVoters() {
        return this.argumentVoters;
    }

    public void setArgumentVoters(MethodArgumentAclVoter[] argumentVoters) {
        this.argumentVoters = argumentVoters;
    }

    public AclManager getAclManager() {
        return this.aclManager;
    }

    public void setAclManager(AclManager aclManager) {
        this.aclManager = aclManager;
    }
}

