/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.olap.service.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.ValidationDetail;
import com.jaspersoft.jasperserver.api.common.domain.ValidationResult;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationDetailImpl;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationResultImpl;
import com.jaspersoft.jasperserver.api.common.service.JdbcDriverService;
import com.jaspersoft.jasperserver.api.common.util.StaticCharacterEncodingProvider;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.util.JndiFallbackResolver;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapClientConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapUnit;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.XMLAConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.service.OlapConnectionService;
import com.jaspersoft.jasperserver.api.metadata.olap.service.impl.MondrianConnectionDataSourceService;
import com.jaspersoft.jasperserver.api.metadata.olap.service.impl.RepositoryCatalogLocator;
import com.jaspersoft.jasperserver.api.metadata.olap.service.impl.XmlaConnectionDataSourceService;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client.MetadataUserDetails;
import com.jaspersoft.jasperserver.api.metadata.user.service.TenantService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.tonbeller.jpivot.core.Model;
import com.tonbeller.jpivot.core.ModelFactory;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.tags.MondrianOlapModelTag;
import com.tonbeller.jpivot.tags.OlapModelProxy;
import com.tonbeller.jpivot.xmla.XMLA_Model;
import com.tonbeller.jpivot.xmla.XMLA_OlapModelTag;
import com.tonbeller.wcf.controller.RequestContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URL;
import java.sql.DriverManager;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.servlet.http.HttpSession;
import mondrian.olap.Connection;
import mondrian.olap.MondrianException;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.spi.CatalogLocator;
import mondrian.util.Pair;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.olap4j.OlapConnection;
import org.olap4j.driver.xmla.XmlaOlap4jDriver;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
public class OlapConnectionServiceImpl
implements OlapConnectionService,
ReportDataSourceServiceFactory {
    public static final String OLAP4J_DRIVER = "olap4jDriver";
    public static final String OLAP4J_URL_PREFIX = "urlPrefix";
    public static final String XMLA_USER = "user";
    public static final String XMLA_PASSWORD = "password";
    private static final String OLAP_CONNECTION_JNDI_DATA_SOURCE = "DataSource";
    private static final String OLAP_CONNECTION_JDBC = "Jdbc";
    private static final String OLAP_CONNECTION_JDBC_USER = "JdbcUser";
    private static final String OLAP_CONNECTION_JDBC_PASSWORD = "JdbcPassword";
    private static final String DATA_SOURCE_INFO = "DataSourceInfo";
    private static final Log log = LogFactory.getLog(OlapConnectionServiceImpl.class);
    private UserAuthorityService userService;
    private TenantService tenantService;
    private JndiFallbackResolver jndiFallbackResolver;
    private JdbcDriverService jdbcDriverService;
    private CatalogLocator repositoryCatalogLocator = new RepositoryCatalogLocator();
    protected String OLAP4J_CACHE = null;
    protected String OLAP4J_CACHE_NAME = null;
    protected String OLAP4J_CACHE_MODE = null;
    protected String OLAP4J_CACHE_TIMEOUT = null;
    protected String OLAP4J_CACHE_SIZE = null;
    private RepositoryService mRepository;
    private String useContentChecksum;
    private StaticCharacterEncodingProvider encodingProvider;

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public OlapModel createOlapModel(ExecutionContext context, OlapUnit olapUnit) {
        OlapClientConnection clientConn = (OlapClientConnection)this.dereference(context, olapUnit.getOlapClientConnection());
        if (clientConn instanceof XMLAConnection) {
            return this.createXmlaModel(context, olapUnit);
        }
        String mdx = olapUnit.getMdxQuery();
        MondrianConnection conn = (MondrianConnection)clientConn;
        MondrianModel model = null;
        try {
            model = (MondrianModel)ModelFactory.instance((URL)this.getDefaultMondrianConfig());
        }
        catch (Exception e) {
            throw new JSException((Throwable)e);
        }
        model.setMdxQuery(mdx);
        model.setConnectProperties(this.getMondrianConnectProperties(context, conn));
        model.setDynLocale(String.valueOf(LocaleContextHolder.getLocale()));
        model.setCatalogLocator(this.repositoryCatalogLocator);
        return model;
    }

    protected URL getDefaultMondrianConfig() {
        return MondrianOlapModelTag.class.getResource("/com/tonbeller/jpivot/mondrian/config.xml");
    }

    protected URL getDefaultXMLAConfig() {
        return XMLA_OlapModelTag.class.getResource("config.xml");
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public OlapModel createXmlaModel(ExecutionContext context, OlapUnit xmlaUnit) {
        Model model;
        String mdx = xmlaUnit.getMdxQuery();
        XMLAConnection xmlaConn = (XMLAConnection)this.dereference(context, xmlaUnit.getOlapClientConnection());
        URL url = this.getDefaultXMLAConfig();
        try {
            model = ModelFactory.instance((URL)url);
        }
        catch (Exception e) {
            throw new JSException((Throwable)e);
        }
        if (!(model instanceof XMLA_Model)) {
            throw new JSException("jsexception.invalid.class.attribute.for.model.tag", new Object[]{this.getDefaultXMLAConfig()});
        }
        XMLA_Model xmlaModel = (XMLA_Model)model;
        xmlaModel.setCatalog(xmlaConn.getCatalog());
        if (this.lacksAuthentication(xmlaConn)) {
            MetadataUserDetails user = this.getCurrentUserDetails();
            String fullyQualifiedName = user.getUsername();
            if (user.getTenantId() != null) {
                fullyQualifiedName = fullyQualifiedName + this.tenantService.getUserOrgIdDelimiter() + user.getTenantId();
            }
            xmlaModel.setUser(fullyQualifiedName);
            xmlaModel.setPassword(user.getPassword());
        } else {
            xmlaModel.setUser(xmlaConn.getUsername());
            xmlaModel.setPassword(xmlaConn.getPassword());
        }
        xmlaModel.setDataSource(xmlaConn.getDataSource());
        xmlaModel.setMdxQuery(mdx);
        xmlaModel.setID(xmlaConn.getCatalog() + "-" + xmlaUnit.hashCode());
        xmlaModel.setUri(xmlaConn.getURI());
        log.debug((Object)("XMLA USERNAME = " + xmlaModel.getUser()));
        log.debug((Object)("XMLA PASSWORD = " + xmlaModel.getPassword()));
        return xmlaModel;
    }

    protected boolean lacksAuthentication(XMLAConnection xmlaConn) {
        return xmlaConn.getUsername() == null || xmlaConn.getPassword() == null || xmlaConn.getUsername().equals("") || xmlaConn.getPassword().equals("");
    }

    protected MetadataUserDetails getCurrentUserDetails() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null) {
            return (MetadataUserDetails)auth.getPrincipal();
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public ValidationResult validate(ExecutionContext context, OlapUnit unit) {
        return this.validate(context, unit, null, null, null);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public ValidationResult validate(ExecutionContext context, OlapUnit unit, FileResource schema, OlapClientConnection conn, ReportDataSource dataSource) {
        ValidationResultImpl result = new ValidationResultImpl();
        this.validateMDX(context, result, unit, schema, conn, dataSource);
        return result;
    }

    protected void validateMDX(ExecutionContext context, ValidationResultImpl result, OlapUnit unit) {
        this.validateMDX(context, result, unit, null, null, null);
    }

    protected void validateMDX(ExecutionContext context, ValidationResultImpl result, OlapUnit unit, FileResource schema, OlapClientConnection conn, ReportDataSource dataSource) {
        MondrianConnection resource = null;
        if (conn instanceof MondrianConnection) {
            resource = (MondrianConnection)conn;
        }
        if (resource == null) {
            resource = this.getConnectionResource(context, unit);
        }
        if (resource == null) {
            return;
        }
        try {
            Connection monConnection = this.getMondrianConnection(context, resource, dataSource);
            monConnection.parseQuery(unit.getMdxQuery());
        }
        catch (Exception e) {
            ValidationDetailImpl detail = new ValidationDetailImpl();
            detail.setValidationClass(OlapUnit.class);
            detail.setName(unit.getName());
            detail.setLabel(unit.getLabel());
            detail.setResult("ERROR");
            detail.setException(e);
            detail.setMessage(e.getMessage());
            result.addValidationDetail((ValidationDetail)detail);
            log.warn((Object)("Validation Failed for Olap Unit: " + unit.getName()), (Throwable)e);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public MondrianConnection getConnectionResource(ExecutionContext context, OlapUnit unit) {
        Resource clientConn = this.dereference(context, unit.getOlapClientConnection());
        if (clientConn instanceof MondrianConnection) {
            return (MondrianConnection)clientConn;
        }
        if (clientConn instanceof XMLAConnection) {
            // empty if block
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Connection getMondrianConnection(ExecutionContext context, String connResourceName) {
        MondrianConnection conn = (MondrianConnection)this.getRepository().getResource(context, connResourceName);
        if (conn == null) {
            log.error((Object)("missing MondrianConnection resource: " + connResourceName));
            throw new JSException("jsexception.mondrian.no.connection.for.resource", new Object[]{connResourceName});
        }
        return this.getMondrianConnection(context, conn);
    }

    private Connection getMondrianConnection(ExecutionContext context, MondrianConnection conn) {
        return this.getMondrianConnection(context, conn, null);
    }

    protected Connection getMondrianConnection(ExecutionContext context, MondrianConnection conn, ReportDataSource dataSource) {
        Util.PropertyList connectProps = this.getMondrianConnectProperties(context, conn, dataSource);
        if (log.isDebugEnabled()) {
            log.debug((Object)("connection properties prepared: " + connectProps));
        }
        try {
            return mondrian.olap.DriverManager.getConnection((Util.PropertyList)connectProps, (CatalogLocator)this.repositoryCatalogLocator);
        }
        catch (MondrianException e) {
            String dataSourceString = connectProps.get(OLAP_CONNECTION_JNDI_DATA_SOURCE);
            if (ExceptionUtils.indexOfThrowable((Throwable)e, NoInitialContextException.class) > 0 && dataSourceString != null) {
                Map<String, String> jdbcProperties = this.jndiFallbackResolver.getJdbcPropertiesMap(dataSourceString);
                try {
                    connectProps.remove(OLAP_CONNECTION_JNDI_DATA_SOURCE);
                    connectProps.put(OLAP_CONNECTION_JDBC, jdbcProperties.get("url"));
                    connectProps.put(OLAP_CONNECTION_JDBC_USER, jdbcProperties.get("username"));
                    connectProps.put(OLAP_CONNECTION_JDBC_PASSWORD, jdbcProperties.get(XMLA_PASSWORD));
                    return mondrian.olap.DriverManager.getConnection((Util.PropertyList)connectProps, (CatalogLocator)this.repositoryCatalogLocator);
                }
                catch (Throwable t) {
                    throw new JSException("Error getting connection from jndi fallback properties.", t);
                }
            }
            throw e;
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void initializeAndShow(OlapModelProxy omp, String viewUri, OlapModel model, OlapUnit unit) throws Exception {
        omp.initializeAndShow(viewUri, model);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public OlapModel initializeOlapModel(ExecutionContext executionContext, OlapUnit olapUnit, HttpSession sess) {
        RequestContext context = RequestContext.instance();
        OlapModel model = this.createOlapModel(executionContext, olapUnit);
        if (model == null) {
            throw new JSException("jsexception.no.olap.model.created.for", new Object[]{olapUnit.getURIString()});
        }
        model = (OlapModel)model.getTopDecorator();
        model.setLocale(context.getLocale());
        model.setServletContext(sess.getServletContext());
        model.setID(olapUnit.getURIString());
        OlapModelProxy omp = OlapModelProxy.instance((String)olapUnit.getURIString(), (HttpSession)sess, (boolean)false);
        try {
            this.initializeAndShow(omp, olapUnit.getURIString(), model, olapUnit);
        }
        catch (Exception e) {
            throw new JSException((Throwable)e);
        }
        return omp;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public String getFileResourceData(ExecutionContext context, FileResource file) {
        InputStream data;
        RepositoryService rep = this.getRepository();
        StringBuffer fileString = new StringBuffer();
        if (file.hasData()) {
            data = file.getDataStream();
        } else {
            log.debug((Object)("FILE URI STRING = " + file.getURIString()));
            FileResourceData resourceData = rep.getResourceData(context, file.getURIString());
            data = resourceData.getDataStream();
        }
        log.debug((Object)("FILE = " + file));
        String encoding = this.getEncodingProvider().getCharacterEncoding();
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(data, encoding));
            while ((line = in.readLine()) != null) {
                fileString.append(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return fileString.toString();
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Util.PropertyList getOlapConnectProperties(ExecutionContext context, OlapClientConnection conn) {
        if (conn instanceof MondrianConnection) {
            log.debug((Object)"go fetch Mondrian Connection Properties");
            return this.getMondrianConnectProperties(context, (MondrianConnection)conn, null);
        }
        if (conn instanceof XMLAConnection) {
            log.debug((Object)"go fetch XMLConnection Properties");
            return this.getXMLAConnectProperties(context, (XMLAConnection)conn);
        }
        throw new IllegalArgumentException("unknown repo connection type " + conn.getClass().getName());
    }

    private Util.PropertyList getXMLAConnectProperties(ExecutionContext context, XMLAConnection conn) {
        Util.PropertyList connectProps = new Util.PropertyList();
        connectProps.put(XmlaOlap4jDriver.Property.Server.toString(), conn.getURI());
        connectProps.put(XmlaOlap4jDriver.Property.Catalog.toString(), conn.getCatalog());
        String dataSource = conn.getDataSource();
        connectProps.put(XmlaOlap4jDriver.Property.DataSource.toString(), dataSource);
        connectProps.put(XMLA_USER, conn.getUsername());
        connectProps.put(XMLA_PASSWORD, conn.getPassword());
        connectProps.put(OLAP4J_DRIVER, "org.olap4j.driver.xmla.XmlaOlap4jDriver");
        connectProps.put(OLAP4J_URL_PREFIX, "jdbc:xmla:");
        return connectProps;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Util.PropertyList getMondrianConnectProperties(ExecutionContext context, MondrianConnection conn) {
        return this.getMondrianConnectProperties(context, conn, null);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Util.PropertyList getMondrianConnectProperties(ExecutionContext context, MondrianConnection conn, ReportDataSource dataSource) {
        if (dataSource == null && (dataSource = (ReportDataSource)this.dereference(context, conn.getDataSource())) == null) {
            throw new JSException("null data source on dereference of mondrian connection " + conn.getURIString() + " for " + (conn.getDataSource().isLocal() ? "local: " + conn.getDataSource().getLocalResource().getURIString() : conn.getDataSource().getReferenceURI()));
        }
        Util.PropertyList connectProps = new Util.PropertyList();
        connectProps.put(RolapConnectionProperties.Provider.toString(), "mondrian");
        connectProps.put(OLAP4J_DRIVER, "mondrian.olap4j.MondrianOlap4jDriver");
        connectProps.put(OLAP4J_URL_PREFIX, "jdbc:mondrian:");
        String transformedUri = this.repositoryCatalogLocator.locate(this.transformUri(conn.getSchema().getReferenceURI()));
        transformedUri = connectProps.put(RolapConnectionProperties.Catalog.toString(), transformedUri);
        connectProps.put(RolapConnectionProperties.UseContentChecksum.toString(), this.useContentChecksum);
        if (dataSource instanceof JdbcReportDataSource) {
            JdbcReportDataSource jdbcDataSource = (JdbcReportDataSource)dataSource;
            connectProps.put(RolapConnectionProperties.Jdbc.toString(), jdbcDataSource.getConnectionUrl());
            String driverClassName = jdbcDataSource.getDriverClass();
            connectProps.put(RolapConnectionProperties.JdbcDrivers.toString(), driverClassName);
            try {
                log.info((Object)("Loading jdbc driver: " + driverClassName));
                this.jdbcDriverService.register(driverClassName);
            }
            catch (ClassNotFoundException cnfe) {
                log.error((Object)("CANNOT LOAD DRIVER: " + driverClassName));
                throw new JSException((Throwable)cnfe);
            }
            catch (Exception e) {
                throw new JSException((Throwable)e);
            }
            if (jdbcDataSource.getUsername() != null && jdbcDataSource.getUsername().trim().length() > 0) {
                connectProps.put(RolapConnectionProperties.JdbcUser.toString(), jdbcDataSource.getUsername());
            }
            if (jdbcDataSource.getPassword() != null && jdbcDataSource.getPassword().trim().length() > 0) {
                connectProps.put(RolapConnectionProperties.JdbcPassword.toString(), jdbcDataSource.getPassword());
            }
        } else {
            JndiJdbcReportDataSource jndiDataSource = (JndiJdbcReportDataSource)dataSource;
            String jndiURI = "";
            if (jndiDataSource.getJndiName() != null && !jndiDataSource.getJndiName().startsWith("java:")) {
                try {
                    InitialContext ctx = new InitialContext();
                    ctx.lookup("java:comp/env/" + jndiDataSource.getJndiName());
                    jndiURI = "java:comp/env/";
                }
                catch (NamingException e) {
                    try {
                        InitialContext ctx = new InitialContext();
                        ctx.lookup(jndiDataSource.getJndiName());
                        jndiURI = "";
                    }
                    catch (NamingException ex) {
                        // empty catch block
                    }
                }
            }
            jndiURI = jndiURI + jndiDataSource.getJndiName();
            connectProps.put(RolapConnectionProperties.DataSource.toString(), jndiURI);
        }
        return connectProps;
    }

    protected String transformUri(String uri) {
        return uri;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Resource dereference(ExecutionContext context, ResourceReference ref) {
        if (ref.isLocal()) {
            return ref.getLocalResource();
        }
        context = ExecutionContextImpl.getRuntimeExecutionContext((ExecutionContext)context);
        return this.getRepository().getResource(context, ref.getReferenceURI());
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void saveResource(ExecutionContext context, String path, Resource resource) {
        String targetUri;
        RepositoryService rep = this.getRepository();
        if (rep.resourceExists(context, targetUri = path + (path.endsWith("/") ? "" : "/") + resource.getName())) {
            return;
        }
        Folder folder = this.mkdirs(context, path);
        resource.setParentFolder(folder);
        rep.saveResource(context, resource);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public Folder mkdirs(ExecutionContext context, String path) {
        RepositoryService rep = this.getRepository();
        String[] splitPath = path.split("/");
        String folderName = "/";
        Folder parentFolder = null;
        Folder folder = rep.getFolder(context, folderName);
        for (int i = 0; i < splitPath.length; ++i) {
            log.debug((Object)("Current path element is " + splitPath[i]));
            if ("".equals(splitPath[i])) continue;
            log.debug((Object)("Folder name '" + folderName + "' yields folder '" + folder + "'"));
            if (!folderName.equals("/")) {
                folderName = folderName + "/";
            }
            folderName = folderName + splitPath[i];
            parentFolder = folder;
            folder = rep.getFolder(context, folderName);
            if (folder != null) continue;
            folder = new FolderImpl();
            folder.setName(splitPath[i]);
            folder.setLabel(splitPath[i]);
            folder.setDescription(splitPath[i] + " folder");
            folder.setParentFolder(parentFolder);
            rep.saveFolder(context, folder);
        }
        log.debug((Object)("Folder name '" + folderName + "' yields folder '" + folder + "'"));
        return folder;
    }

    public RepositoryService getRepository() {
        return this.mRepository;
    }

    public void setRepository(RepositoryService repository) {
        this.mRepository = repository;
    }

    public String getUseContentChecksum() {
        return this.useContentChecksum;
    }

    public void setUseContentChecksum(String useContentChecksum) {
        this.useContentChecksum = useContentChecksum;
    }

    public StaticCharacterEncodingProvider getEncodingProvider() {
        return this.encodingProvider;
    }

    public void setEncodingProvider(StaticCharacterEncodingProvider encodingProviderIn) {
        this.encodingProvider = encodingProviderIn;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public ReportDataSourceService createService(ReportDataSource dataSource) {
        Object dsService;
        if (dataSource instanceof MondrianConnection) {
            MondrianConnection mondrianConnection = (MondrianConnection)dataSource;
            Connection connection = this.getMondrianConnection(null, mondrianConnection);
            dsService = new MondrianConnectionDataSourceService(connection);
        } else if (dataSource instanceof XMLAConnection) {
            String tenantSeparator;
            XMLAConnection xmlaConnection = (XMLAConnection)dataSource;
            String string = tenantSeparator = this.tenantService != null ? this.tenantService.getUserOrgIdDelimiter() : null;
            if (this.lacksAuthentication(xmlaConnection)) {
                MetadataUserDetails user = this.getCurrentUserDetails();
                dsService = new XmlaConnectionDataSourceService(xmlaConnection, tenantSeparator, user);
            } else {
                dsService = new XmlaConnectionDataSourceService(xmlaConnection, tenantSeparator);
            }
        } else {
            throw new JSException("jsexception.invalid.olap.datasource", new Object[]{dataSource.getClass()});
        }
        return dsService;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public OlapConnection getOlapConnection(ExecutionContext context, String resourceName) {
        OlapClientConnection conn = (OlapClientConnection)this.getRepository().getResource(context, resourceName);
        Util.PropertyList propList = this.getOlapConnectProperties(context, conn);
        Properties props = new Properties();
        String driverClass = null;
        String urlPrefix = null;
        for (Pair pair : propList) {
            if (((String)pair.getKey()).equals(OLAP4J_DRIVER)) {
                driverClass = (String)pair.getValue();
                continue;
            }
            if (((String)pair.getKey()).equals(OLAP4J_URL_PREFIX)) {
                urlPrefix = (String)pair.getValue();
                continue;
            }
            props.put(pair.getKey(), pair.getValue());
        }
        if (this.getOLAP4J_CACHE() != null && this.getOLAP4J_CACHE().length() > 0) {
            props.put("Cache", this.getOLAP4J_CACHE());
            props.put("Cache.Name", this.getOLAP4J_CACHE_NAME());
            props.put("Cache.Mode", this.getOLAP4J_CACHE_MODE());
            props.put("Cache.Timeout", this.getOLAP4J_CACHE_TIMEOUT());
            props.put("Cache.Size", this.getOLAP4J_CACHE_SIZE());
        }
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("OlapConnectionProperties Full Set: ");
            for (Pair pair : propList) {
                sb.append("key='" + (String)pair.getKey() + "', val='" + (String)pair.getValue() + "', ");
            }
            sb.append("\nOlapConnectionProperties Driver Set: ");
            for (Object key : props.keySet()) {
                sb.append("key='" + key + "', val='" + props.get(key) + "', ");
            }
            sb.append("\nDriver Class='" + (driverClass == null ? "NULL" : driverClass) + "'");
            sb.append("\n   urlPrefix='" + (urlPrefix == null ? "NULL" : urlPrefix) + "'");
            log.debug((Object)sb.toString());
        }
        java.sql.Connection rConnection = null;
        try {
            this.jdbcDriverService.register(driverClass);
            rConnection = DriverManager.getConnection(urlPrefix, props);
        }
        catch (MondrianException e) {
            String dataSource = (String)props.get(OLAP_CONNECTION_JNDI_DATA_SOURCE);
            if (ExceptionUtils.indexOfThrowable((Throwable)e, NoInitialContextException.class) > 0 && dataSource != null) {
                Map<String, String> jdbcProperties = this.jndiFallbackResolver.getJdbcPropertiesMap(dataSource);
                try {
                    props.remove(OLAP_CONNECTION_JNDI_DATA_SOURCE);
                    props.put(OLAP_CONNECTION_JDBC, jdbcProperties.get("url"));
                    props.put(OLAP_CONNECTION_JDBC_USER, jdbcProperties.get("username"));
                    props.put(OLAP_CONNECTION_JDBC_PASSWORD, jdbcProperties.get(XMLA_PASSWORD));
                    rConnection = DriverManager.getConnection(urlPrefix, props);
                }
                catch (Throwable t) {
                    throw new JSException("Error getting connection from jndi fallback properties.", t);
                }
            }
            throw e;
        }
        catch (Throwable t) {
            throw new JSException("error loading olap4j driver and getting Connection '" + driverClass + "'", t);
        }
        return (OlapConnection)rConnection;
    }

    public Connection getOlap4jMondrianConnection(ExecutionContext context, String resourceName) {
        OlapConnection oConn = this.getOlapConnection(context, resourceName);
        if (oConn != null) {
            return this.getOlap4jMondrianConnectionFromOlapConnection(oConn);
        }
        return null;
    }

    protected Connection getOlap4jMondrianConnectionFromOlapConnection(OlapConnection oConn) {
        try {
            Object connObj = OlapConnectionServiceImpl.getFieldMemberFromHierarchyByType(oConn, "mondrian.olap.Connection");
            return (Connection)connObj;
        }
        catch (Exception e) {
            throw new JSException("could not obtain mondrian.olap.Connection from '" + oConn + "' " + e.getMessage());
        }
    }

    public UserAuthorityService getUserService() {
        return this.userService;
    }

    public void setUserService(UserAuthorityService userService) {
        this.userService = userService;
    }

    public TenantService getTenantService() {
        return this.tenantService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public static Object getFieldMemberFromHierarchyByType(Object target, String typeName) {
        Field field = OlapConnectionServiceImpl.getFieldFromHierarchyByTypeName(target, typeName);
        if (field == null) {
            return null;
        }
        try {
            field.setAccessible(true);
            return field.get(target);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot access (set) [" + field + "] field in target [" + target + "]. " + "Reason: " + e.getMessage(), e);
        }
    }

    public static Field getFieldFromHierarchyByTypeName(Object target, String typeName) {
        Class<?> cl = target.getClass();
        while (!cl.getName().equals("java.lang.Object")) {
            Field f = OlapConnectionServiceImpl.getFieldByTypeName(cl, typeName);
            if (f != null) {
                return f;
            }
            cl = cl.getSuperclass();
        }
        return null;
    }

    public static Field getFieldByTypeName(Class cl, String typeName) {
        assert (cl != null);
        assert (typeName != null);
        Field[] fields = cl.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!typeName.equals(fields[i].getType().getName())) continue;
            fields[i].setAccessible(true);
            return fields[i];
        }
        return null;
    }

    public void setJndiFallbackResolver(JndiFallbackResolver jndiFallbackResolver) {
        this.jndiFallbackResolver = jndiFallbackResolver;
    }

    public String getOLAP4J_CACHE() {
        return this.OLAP4J_CACHE;
    }

    public void setOLAP4J_CACHE(String oLAP4J_CACHE) {
        this.OLAP4J_CACHE = oLAP4J_CACHE;
    }

    public String getOLAP4J_CACHE_NAME() {
        return this.OLAP4J_CACHE_NAME;
    }

    public void setOLAP4J_CACHE_NAME(String oLAP4J_CACHE_NAME) {
        this.OLAP4J_CACHE_NAME = oLAP4J_CACHE_NAME;
    }

    public String getOLAP4J_CACHE_MODE() {
        return this.OLAP4J_CACHE_MODE;
    }

    public void setOLAP4J_CACHE_MODE(String oLAP4J_CACHE_MODE) {
        this.OLAP4J_CACHE_MODE = oLAP4J_CACHE_MODE;
    }

    public String getOLAP4J_CACHE_TIMEOUT() {
        return this.OLAP4J_CACHE_TIMEOUT;
    }

    public void setOLAP4J_CACHE_TIMEOUT(String oLAP4J_CACHE_TIMEOUT) {
        this.OLAP4J_CACHE_TIMEOUT = oLAP4J_CACHE_TIMEOUT;
    }

    public String getOLAP4J_CACHE_SIZE() {
        return this.OLAP4J_CACHE_SIZE;
    }

    public void setOLAP4J_CACHE_SIZE(String oLAP4J_CACHE_SIZE) {
        this.OLAP4J_CACHE_SIZE = oLAP4J_CACHE_SIZE;
    }

    public JdbcDriverService getJdbcDriverService() {
        return this.jdbcDriverService;
    }

    public void setJdbcDriverService(JdbcDriverService jdbcDriverService) {
        this.jdbcDriverService = jdbcDriverService;
    }
}

