/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.olap.domain.impl.hibernate;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.ReferenceResolver;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResource;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapUnit;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.impl.hibernate.RepoOlapClientConnection;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.sql.SQLException;
import org.hibernate.Hibernate;
import org.hibernate.lob.SerializableBlob;

public class RepoOlapUnit
extends RepoResource {
    private RepoOlapClientConnection olapClientConn = null;
    private String mdxQuery;
    private SerializableBlob olapViewOptions;

    public RepoOlapClientConnection getOlapClientConnection() {
        return this.olapClientConn;
    }

    public void setOlapClientConnection(RepoOlapClientConnection r) {
        this.olapClientConn = r;
    }

    public String getMdxQuery() {
        return this.mdxQuery;
    }

    public void setMdxQuery(String s) {
        this.mdxQuery = s;
    }

    public SerializableBlob getOlapViewOptions() {
        return this.olapViewOptions;
    }

    public void setOlapViewOptions(SerializableBlob sb) {
        this.olapViewOptions = sb;
    }

    @Override
    protected void copyTo(Resource clientRes, ResourceFactory resourceFactory) {
        super.copyTo(clientRes, resourceFactory);
        OlapUnit view = (OlapUnit)clientRes;
        view.setOlapClientConnection(this.getClientReference(this.getOlapClientConnection(), resourceFactory));
        view.setMdxQuery(this.getMdxQuery());
        if (this.getOlapViewOptions() != null) {
            Object state = null;
            try {
                XMLDecoder d = new XMLDecoder(new BufferedInputStream(this.getOlapViewOptions().getBinaryStream()));
                state = d.readObject();
                d.close();
            }
            catch (SQLException e) {
                throw new JSException((Throwable)e);
            }
            view.setOlapViewOptions(state);
        }
    }

    @Override
    protected void copyFrom(Resource clientRes, ReferenceResolver referenceResolver) {
        super.copyFrom(clientRes, referenceResolver);
        OlapUnit view = (OlapUnit)clientRes;
        this.copyOlapClientConnection(referenceResolver, view);
        this.setMdxQuery(view.getMdxQuery());
        this.copyOlapViewOptions(view);
    }

    private void copyOlapClientConnection(ReferenceResolver referenceResolver, OlapUnit view) {
        ResourceReference conn = view.getOlapClientConnection();
        RepoOlapClientConnection repoMC = (RepoOlapClientConnection)this.getReference(conn, RepoOlapClientConnection.class, referenceResolver);
        this.setOlapClientConnection(repoMC);
    }

    private void copyOlapViewOptions(OlapUnit view) {
        if (view.getOlapViewOptions() != null && !(view.getOlapViewOptions() instanceof SerializableBlob)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLEncoder e = new XMLEncoder(new BufferedOutputStream(baos));
            e.writeObject(view.getOlapViewOptions());
            e.flush();
            e.close();
            this.setOlapViewOptions((SerializableBlob)Hibernate.createBlob((byte[])baos.toByteArray()));
        }
    }

    @Override
    protected Class getClientItf() {
        return OlapUnit.class;
    }
}

