/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.olap.domain.impl.hibernate;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.ReferenceResolver;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoFileResource;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.impl.datasource.RepoReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.impl.hibernate.RepoOlapClientConnection;

public class RepoMondrianConnection
extends RepoOlapClientConnection
implements RepoReportDataSource {
    private RepoResource dataSource = null;
    private RepoFileResource schema = null;

    public RepoFileResource getSchema() {
        return this.schema;
    }

    public void setSchema(RepoFileResource f) {
        this.schema = f;
    }

    public RepoResource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(RepoResource ds) {
        this.dataSource = ds;
    }

    @Override
    protected void copyTo(Resource clientRes, ResourceFactory resourceFactory) {
        super.copyTo(clientRes, resourceFactory);
        MondrianConnection conn = (MondrianConnection)clientRes;
        conn.setDataSource(this.getClientReference(this.getDataSource(), resourceFactory));
        conn.setSchema(this.getClientReference(this.getSchema(), resourceFactory));
    }

    @Override
    protected void copyFrom(Resource clientRes, ReferenceResolver referenceResolver) {
        super.copyFrom(clientRes, referenceResolver);
        MondrianConnection conn = (MondrianConnection)clientRes;
        this.copyDataSource(referenceResolver, conn);
        this.copySchema(referenceResolver, conn);
    }

    private void copyDataSource(ReferenceResolver referenceResolver, MondrianConnection conn) {
        ResourceReference ds = conn.getDataSource();
        RepoResource repoDS = this.getReference(ds, RepoReportDataSource.class, referenceResolver);
        if (repoDS != null && !(repoDS instanceof RepoReportDataSource)) {
            throw new JSException("jsexception.mondrian.jdbc.datasource.has.an.invalid.type", new Object[]{repoDS.getClass().getName()});
        }
        this.setDataSource(repoDS);
    }

    private void copySchema(ReferenceResolver referenceResolver, MondrianConnection conn) {
        ResourceReference report = conn.getSchema();
        RepoFileResource repoReport = (RepoFileResource)this.getReference(report, RepoFileResource.class, referenceResolver);
        this.setSchema(repoReport);
    }

    @Override
    protected Class getClientItf() {
        return MondrianConnection.class;
    }
}

