/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.impl.datasource;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.PasswordCipherer;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.ReferenceResolver;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.CustomReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.impl.datasource.RepoReportDataSource;
import java.util.HashMap;
import java.util.Map;

public class RepoCustomDataSource
extends RepoDataSource
implements RepoReportDataSource {
    private static final String CDS_NAME_PROPERTY = "_cds_name";
    private String serviceClass;
    private Map propertyMap;

    @Override
    protected Class getClientItf() {
        return CustomReportDataSource.class;
    }

    public Map getPropertyMap() {
        return this.propertyMap;
    }

    public void setPropertyMap(Map propertyMap) {
        this.propertyMap = propertyMap;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(String serviceClass) {
        this.serviceClass = serviceClass;
    }

    @Override
    protected void copyTo(Resource clientRes, ResourceFactory resourceFactory) {
        super.copyTo(clientRes, resourceFactory);
        CustomReportDataSource ds = (CustomReportDataSource)clientRes;
        HashMap<String, String> aPropertyMap = new HashMap<String, String>(this.getPropertyMap());
        String password = (String)aPropertyMap.get("password");
        if (password != null && password.trim().length() > 0) {
            aPropertyMap.put("password", PasswordCipherer.getInstance().decodePassword(password));
        }
        ds.setDataSourceName((String)aPropertyMap.get(CDS_NAME_PROPERTY));
        ds.setPropertyMap(aPropertyMap);
        ds.setServiceClass(this.getServiceClass());
    }

    @Override
    protected void copyFrom(Resource clientRes, ReferenceResolver referenceResolver) {
        String dsName;
        super.copyFrom(clientRes, referenceResolver);
        CustomReportDataSource ds = (CustomReportDataSource)clientRes;
        String password = (String)ds.getPropertyMap().get("password");
        if (password != null && password.trim().length() > 0) {
            ds.getPropertyMap().put("password", PasswordCipherer.getInstance().encodePassword(password));
        }
        if ((dsName = ds.getDataSourceName()) != null && dsName.trim().length() > 0) {
            ds.getPropertyMap().put(CDS_NAME_PROPERTY, dsName);
        }
        this.setPropertyMap(ds.getPropertyMap());
        this.setServiceClass(ds.getServiceClass());
    }
}

