/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.impl.datasource;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.PasswordCipherer;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.ReferenceResolver;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.AwsReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.impl.datasource.RepoJdbcDataSource;

public class RepoAwsDataSource
extends RepoJdbcDataSource {
    private String accessKey;
    private String secretKey;
    private String roleARN;
    private String region;
    private String dbName;
    private String dbInstanceIdentifier;
    private String dbService;

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getRoleARN() {
        return this.roleARN;
    }

    public String getRegion() {
        return this.region;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setRoleARN(String roleARN) {
        this.roleARN = roleARN;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public void setDbInstanceIdentifier(String dbInstanceIdentifier) {
        this.dbInstanceIdentifier = dbInstanceIdentifier;
    }

    public String getDbService() {
        return this.dbService;
    }

    public void setDbService(String dbService) {
        this.dbService = dbService;
    }

    @Override
    protected Class getClientItf() {
        return AwsReportDataSource.class;
    }

    @Override
    protected void copyTo(Resource clientRes, ResourceFactory resourceFactory) {
        super.copyTo(clientRes, resourceFactory);
        AwsReportDataSource ds = (AwsReportDataSource)clientRes;
        ds.setAWSAccessKey(PasswordCipherer.getInstance().decodePassword(this.getAccessKey()));
        ds.setAWSSecretKey(PasswordCipherer.getInstance().decodePassword(this.getSecretKey()));
        ds.setRoleARN(this.getRoleARN());
        ds.setAWSRegion(this.getRegion());
        ds.setDbName(this.getDbName());
        ds.setDbService(this.getDbService());
        ds.setDbInstanceIdentifier(this.getDbInstanceIdentifier());
    }

    @Override
    protected void copyFrom(Resource clientRes, ReferenceResolver referenceResolver) {
        super.copyFrom(clientRes, referenceResolver);
        AwsReportDataSource ds = (AwsReportDataSource)clientRes;
        this.setAccessKey(PasswordCipherer.getInstance().encodePassword(ds.getAWSAccessKey()));
        this.setSecretKey(PasswordCipherer.getInstance().encodePassword(ds.getAWSSecretKey()));
        this.setRoleARN(ds.getRoleARN());
        this.setRegion(ds.getAWSRegion());
        this.setDbName(ds.getDbName());
        this.setDbService(ds.getDbService());
        this.setDbInstanceIdentifier(ds.getDbInstanceIdentifier());
    }
}

