/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.ReferenceResolver;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.RepoManager;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResource;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResourceBase;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class RepoFolder
extends RepoResourceBase {
    private String uri;
    private boolean hidden;
    private Set children = new HashSet();
    private Set subFolders;

    public String getURI() {
        return this.uri;
    }

    public void setURI(String newURIString) {
        this.uri = newURIString;
    }

    public void set(Folder folder, RepoFolder parent, RepoManager manager) {
        this.setName(folder.getName());
        this.setLabel(folder.getLabel());
        this.setDescription(folder.getDescription());
        this.setParent(parent);
        this.setHidden(false);
        this.refreshURI(manager);
    }

    public void refreshURI(RepoManager manager) {
        String newURI = this.getResourceURI();
        if (!newURI.equals(this.getURI())) {
            this.setURI(newURI);
            manager.lockPath(this);
        }
    }

    @Override
    public String getResourceURI() {
        if (this.parent == null && "/".equals(this.name)) {
            return "/";
        }
        return super.getResourceURI();
    }

    @Override
    protected Class getClientItf() {
        return Folder.class;
    }

    public Set getChildren() {
        return this.children;
    }

    public void setChildren(Set children) {
        this.children = children;
    }

    public void addChild(RepoResource resource) {
        resource.setParent(this);
        this.children.add(resource);
    }

    public boolean removeChild(RepoResource resource) {
        return this.children.remove(resource);
    }

    public Set getSubFolders() {
        return this.subFolders;
    }

    public void setSubFolders(Set subFolders) {
        this.subFolders = subFolders;
    }

    protected void filterChildren(Set newChildren) {
        if (newChildren == null) {
            this.children.clear();
        } else {
            Iterator it = this.children.iterator();
            while (it.hasNext()) {
                RepoResource res = (RepoResource)it.next();
                if (newChildren.contains(res)) continue;
                it.remove();
            }
            for (RepoResource res : newChildren) {
                if (this.children.contains(res)) continue;
                this.children.add(res);
            }
        }
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isRoot() {
        return this.getURI().equals("/");
    }

    public Folder toClient() {
        FolderImpl folder = new FolderImpl();
        this.copyTo((Resource)folder);
        return folder;
    }

    @Override
    public Object toClient(ResourceFactory resourceFactory) {
        return this.toClient();
    }

    protected void copyTo(Resource clientRes, ResourceFactory resourceFactory) {
        throw new JSException("jsexception.resource.copyTo.not.implemented");
    }

    protected void copyFrom(Resource clientRes, ReferenceResolver referenceResolver) {
        throw new JSException("jsexception.resource.copyFrom.not.implemented");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RepoFolder)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.isNew()) {
            return false;
        }
        RepoFolder res = (RepoFolder)obj;
        return new EqualsBuilder().append(this.getId(), res.getId()).isEquals();
    }

    public int hashCode() {
        if (this.isNew()) {
            return super.hashCode();
        }
        return new HashCodeBuilder().append(this.getId()).toHashCode();
    }

    public String toString() {
        return this.getURI();
    }

    @Override
    public void moveTo(RepoFolder parent, RepoManager repoManager) {
        String oldParentURI = this.getParent().getResourceURI();
        this.setParent(parent);
        this.moved(oldParentURI, parent.getResourceURI(), repoManager);
    }

    @Override
    protected void moved(String oldBaseURI, String newBaseURI, RepoManager repoManager) {
        Set resources;
        this.refreshURI(repoManager);
        repoManager.update(this);
        repoManager.folderMoved(this, oldBaseURI, newBaseURI);
        Set subfolders = this.getSubFolders();
        if (subfolders != null && !subfolders.isEmpty()) {
            for (RepoFolder subfolder : subfolders) {
                subfolder.moved(oldBaseURI, newBaseURI, repoManager);
            }
        }
        if ((resources = this.getChildren()) != null && !resources.isEmpty()) {
            for (RepoResource resource : resources) {
                resource.moved(oldBaseURI, newBaseURI, repoManager);
            }
        }
    }
}

