/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ValidationError;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrorFilter;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.common.domain.impl.NullValidationErrorFilter;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationErrorImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.DefaultResourceValidator;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.VirtualReportDataSource;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class VirtualDataSourceValidator
extends DefaultResourceValidator {
    private Pattern subDsIdInvalidChars = Pattern.compile("\\W");

    public boolean validateSubDsId(String value, String nameField, ValidationErrors errors) {
        char firstChar;
        if (!this.validateNameString(value, nameField, errors)) {
            return false;
        }
        if (this.subDsIdInvalidChars.matcher(value).find()) {
            errors.add((ValidationError)new ValidationErrorImpl(this.getErrorMessagePrefix() + "error.invalid.chars", null, "Only letters, digits and underscore allowed in subDsId", nameField));
        }
        if (!StringUtils.isEmpty((String)value) && ((firstChar = value.charAt(0)) == '_' || Character.isDigit(firstChar))) {
            errors.add((ValidationError)new ValidationErrorImpl(this.getErrorMessagePrefix() + "error.first.letter.required", null, "Should start with letter", nameField));
        }
        return true;
    }

    @Override
    public ValidationErrors validate(Resource resource, ValidationErrorFilter filter) {
        String subDsMapFieldName = this.getFieldPrefix() + "subDsMap";
        if (filter == null) {
            filter = NullValidationErrorFilter.getInstance();
        }
        ValidationErrors errors = super.validate(resource, filter);
        VirtualReportDataSource vds = (VirtualReportDataSource)resource;
        if (filter.matchErrorField(subDsMapFieldName) && (vds.getDataSourceUriMap() == null || vds.getDataSourceUriMap().size() < 2)) {
            errors.add((ValidationError)new ValidationErrorImpl(this.getErrorMessagePrefix() + "minimal_subds_count", null, "At least 2 sub-datasources required", "dataSourceUriMap"));
            return errors;
        }
        HashSet<String> visitedUris = new HashSet<String>();
        String subDsIdFieldName = this.getFieldPrefix() + "subDsId";
        for (Map.Entry entry : vds.getDataSourceUriMap().entrySet()) {
            if (filter.matchErrorField(subDsIdFieldName)) {
                this.validateSubDsId((String)entry.getKey(), subDsIdFieldName, errors);
            }
            String uri = ((ResourceReference)entry.getValue()).getReferenceURI();
            if (filter.matchErrorField(subDsMapFieldName) && visitedUris.contains(uri)) {
                errors.add((ValidationError)new ValidationErrorImpl(this.getErrorMessagePrefix() + "duplicate_subds_uri", new Object[]{uri}, "Same resource referenced twice: {0}"));
                continue;
            }
            visitedUris.add(uri);
        }
        return errors;
    }
}

