/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ValidationError;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrorFilter;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationErrorImpl;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationErrorsImpl;
import com.jaspersoft.jasperserver.api.common.service.ServletContextInformation;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceValidator;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.BaseResourceValidator;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;

public class ReportUnitValidator
extends BaseResourceValidator
implements ResourceValidator {
    private RepositoryService repository;
    private ServletContextInformation servletContextInformation;

    @Override
    public RepositoryService getRepositoryService() {
        return this.repository;
    }

    @Override
    public void setRepositoryService(RepositoryService repository) {
        this.repository = repository;
    }

    public ServletContextInformation getServletContextInformation() {
        return this.servletContextInformation;
    }

    public void setServletContextInformation(ServletContextInformation servletContextInformation) {
        this.servletContextInformation = servletContextInformation;
    }

    public ValidationErrors validate(Resource resource, ValidationErrorFilter filter) {
        ValidationErrorsImpl errors = new ValidationErrorsImpl();
        ReportUnit report = (ReportUnit)resource;
        this.validateLabel((Resource)report, filter, (ValidationErrors)errors);
        this.validateName((Resource)report, filter, (ValidationErrors)errors);
        this.validateDescription((Resource)report, filter, (ValidationErrors)errors);
        this.validateInputControlView(report, filter, (ValidationErrors)errors);
        this.validateRenderingView(report, filter, (ValidationErrors)errors);
        this.validateMainReport(report, filter, (ValidationErrors)errors);
        return errors;
    }

    private void validateInputControlView(ReportUnit report, ValidationErrorFilter filter, ValidationErrors errors) {
        String inputControlView;
        if ((filter == null || filter.matchErrorField("reportUnit.inputControlRenderingView")) && (inputControlView = report.getInputControlRenderingView()) != null && inputControlView.length() > 0) {
            if (inputControlView.length() > 100) {
                errors.add((ValidationError)new ValidationErrorImpl("ReportDetailsValidator.error.too.long", new Object[]{new Integer(100)}, null, "reportUnit.inputControlRenderingView"));
            } else if (!this.getServletContextInformation().jspExists(inputControlView)) {
                errors.add((ValidationError)new ValidationErrorImpl("ReportDetailsValidator.error.inexisting.jsp", null, null, "reportUnit.inputControlRenderingView"));
            }
        }
    }

    private void validateRenderingView(ReportUnit report, ValidationErrorFilter filter, ValidationErrors errors) {
        String reportRenderingView;
        if ((filter == null || filter.matchErrorField("reportUnit.reportRenderingView")) && (reportRenderingView = report.getReportRenderingView()) != null && reportRenderingView.length() > 0) {
            if (reportRenderingView.length() > 100) {
                errors.add((ValidationError)new ValidationErrorImpl("ReportDetailsValidator.error.too.long", new Object[]{new Integer(100)}, null, "reportUnit.reportRenderingView"));
            } else if (!this.getServletContextInformation().jspExists(reportRenderingView)) {
                errors.add((ValidationError)new ValidationErrorImpl("ReportDetailsValidator.error.inexisting.jsp", null, null, "reportUnit.reportRenderingView"));
            }
        }
    }

    protected void validateMainReport(ReportUnit report, ValidationErrorFilter filter, ValidationErrors errors) {
        ResourceReference mainReport;
        if ((filter == null || filter.matchErrorField("reportUnit.mainReport")) && ((mainReport = report.getMainReport()) == null || (mainReport.isLocal() ? mainReport.getLocalResource() == null : mainReport.getReferenceURI() == null))) {
            errors.add((ValidationError)new ValidationErrorImpl("ReportDetailsValidator.error.not.empty", null, null, "reportUnit.mainReport"));
        }
    }

    @Override
    protected String getErrorMessagePrefix() {
        return "ReportDetailsValidator.";
    }

    @Override
    protected String getFieldPrefix() {
        return "reportUnit.";
    }
}

