/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.logging.diagnostic.jmx;

import com.jaspersoft.jasperserver.api.logging.diagnostic.domain.DiagnosticAttribute;
import com.jaspersoft.jasperserver.api.logging.diagnostic.domain.DiagnosticAttributeImpl;
import com.jaspersoft.jasperserver.api.logging.diagnostic.service.Diagnostic;
import com.jaspersoft.jasperserver.api.logging.diagnostic.service.DiagnosticCallback;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import org.springframework.beans.factory.InitializingBean;

public class DiagnosticDynamicMBean
implements DynamicMBean,
Diagnostic,
InitializingBean {
    private Set<Diagnostic> diagnosticServices;
    private Set<String> excludedDiagnosticAttributes;
    private Map<DiagnosticAttribute, DiagnosticCallback> diagnosticData = new HashMap<DiagnosticAttribute, DiagnosticCallback>();

    public void setDiagnosticServices(Set<Diagnostic> diagnosticServices) {
        this.diagnosticServices = diagnosticServices;
    }

    public void setExcludedDiagnosticAttributes(Set<String> excludedDiagnosticAttributes) {
        this.excludedDiagnosticAttributes = excludedDiagnosticAttributes;
    }

    public void afterPropertiesSet() throws Exception {
        for (Diagnostic diagnostic : this.diagnosticServices) {
            this.diagnosticData.putAll(diagnostic.getDiagnosticData());
        }
        for (String excludedAttribute : this.excludedDiagnosticAttributes) {
            this.diagnosticData.remove(new DiagnosticAttributeImpl(excludedAttribute, null, null));
        }
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.diagnosticData.get(new DiagnosticAttributeImpl(attribute, null, null)).getDiagnosticAttributeValue();
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (String attribute : attributes) {
            list.add(new Attribute(attribute, this.diagnosticData.get(new DiagnosticAttributeImpl(attribute, null, null)).getDiagnosticAttributeValue()));
        }
        return list;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return null;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[this.diagnosticData.keySet().size()];
        int iterator = 0;
        ArrayList<DiagnosticAttribute> sortedDiagnosticAtributes = new ArrayList<DiagnosticAttribute>(this.diagnosticData.keySet());
        Collections.sort(sortedDiagnosticAtributes, new DiagnosticComparator());
        for (DiagnosticAttribute diagnosticAttribute : sortedDiagnosticAtributes) {
            attrs[iterator++] = new MBeanAttributeInfo(diagnosticAttribute.getAttributeName(), diagnosticAttribute.getAttributeType(), diagnosticAttribute.getAttributeDescription(), true, false, false);
        }
        return new MBeanInfo(this.getClass().getName(), "Property Manager MBean", attrs, null, null, null);
    }

    public Map<DiagnosticAttribute, DiagnosticCallback> getDiagnosticData() {
        return this.diagnosticData;
    }

    public static class DiagnosticComparator
    implements Comparator<DiagnosticAttribute> {
        @Override
        public int compare(DiagnosticAttribute diagnAttribute, DiagnosticAttribute diagnAttribute1) {
            return diagnAttribute.getAttributeName().compareTo(diagnAttribute1.getAttributeName()) < 0 ? -1 : (diagnAttribute.getAttributeName().equals(diagnAttribute1.getAttributeName()) ? 0 : 1);
        }
    }
}

