/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.logging.diagnostic.helper;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;

public class OperatingSystemMXBeanWrapper {
    java.lang.management.OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
    JVMTypes jvmType = JVMTypes.other;

    public OperatingSystemMXBeanWrapper() {
        if (this.osBean.getClass().getName().equals("com.sun.management.OperatingSystem")) {
            this.jvmType = JVMTypes.sun;
        }
        if (this.osBean.getClass().getName().equals("com.ibm.lang.management.OperatingSystem")) {
            this.jvmType = JVMTypes.ibm;
        }
    }

    public String getArch() {
        return this.osBean.getArch();
    }

    public int getAvailableProcessors() {
        return this.osBean.getAvailableProcessors();
    }

    public String getName() {
        return this.osBean.getName();
    }

    public String getVersion() {
        return this.osBean.getVersion();
    }

    public double getSystemLoadAverage() {
        return this.osBean.getSystemLoadAverage();
    }

    public long getTotalPhysicalMemorySize() {
        Long physicalMemorySize = -1L;
        if (this.jvmType.equals((Object)JVMTypes.sun)) {
            physicalMemorySize = ((OperatingSystemMXBean)this.osBean).getTotalPhysicalMemorySize();
        }
        return physicalMemorySize;
    }

    public long getTotalSwapSpaceSize() {
        Long swapSpaceSize = -1L;
        if (this.jvmType.equals((Object)JVMTypes.sun)) {
            swapSpaceSize = ((OperatingSystemMXBean)this.osBean).getTotalSwapSpaceSize();
        }
        return swapSpaceSize;
    }

    public long getFreeSwapSpaceSize() {
        Long freeSwapSpaceSize = -1L;
        if (this.jvmType.equals((Object)JVMTypes.sun)) {
            freeSwapSpaceSize = ((OperatingSystemMXBean)this.osBean).getFreeSwapSpaceSize();
        }
        return freeSwapSpaceSize;
    }

    public long getFreePhysicalMemorySize() {
        Long freePhysicalMemorySize = -1L;
        if (this.jvmType.equals((Object)JVMTypes.sun)) {
            freePhysicalMemorySize = ((OperatingSystemMXBean)this.osBean).getFreePhysicalMemorySize();
        }
        return freePhysicalMemorySize;
    }

    public long getProcessCpuTime() {
        Long processCpuTime = -1L;
        if (this.jvmType.equals((Object)JVMTypes.sun)) {
            processCpuTime = ((OperatingSystemMXBean)this.osBean).getProcessCpuTime();
        }
        return processCpuTime;
    }

    public long getCommittedVirtualMemorySize() {
        Long committedVirtualMemorySize = -1L;
        if (this.jvmType.equals((Object)JVMTypes.sun)) {
            committedVirtualMemorySize = ((OperatingSystemMXBean)this.osBean).getCommittedVirtualMemorySize();
        }
        return committedVirtualMemorySize;
    }

    static enum JVMTypes {
        sun,
        ibm,
        other;

    }
}

