/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.logging.diagnostic.helper;

import com.jaspersoft.jasperserver.api.logging.diagnostic.domain.DiagnosticAttribute;
import com.jaspersoft.jasperserver.api.logging.diagnostic.domain.DiagnosticAttributeImpl;
import com.jaspersoft.jasperserver.api.logging.diagnostic.service.DiagnosticCallback;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;

public class DiagnosticAttributeBuilder {
    private static final Log log = LogFactory.getLog(DiagnosticAttributeBuilder.class);
    public static final String TOTAL_LOGGED_IN_USERS = "LoggedInUsersCount";
    public static final String TOTAL_SESSIONS_BY_USER = "LoggedInUsersList";
    public static final String RUNNING_REPORT_COUNT = "RunningReportsCount";
    public static final String RUNNING_REPORTS_LIST = "RunningReportsList";
    public static final String RUNNING_REPORT_ASYNCTASKCOUNT = "RunningAsyncReportsCountCuml";
    public static final String RUNNING_REPORT_ASYNCPOOLSIZE = "RunningAsyncReportsPoolSize";
    public static final String RUNNING_REPORT_ASYNCACTIVETASKCOUNT = "RunningAsyncReportsActiveTaskCount";
    public static final String RUNNING_REPORT_SYNCTASKCOUNT = "RunningSyncReportsCountCuml";
    public static final String RUNNING_REPORT_ERRORCOUNT = "RunningReportsErrorsCuml";
    public static final String RUNNING_REPORT_COUNT_CUML = "RunningReportsCountCuml";
    public static final String TOTAL_SCHEDULED_JOBS = "ScheduledJobsCount";
    public static final String TOTAL_RUNNING_JOBS = "RunningJobsCount";
    public static final String RUNNING_JOBS_LIST = "RunningJobsList";
    public static final String VERSION = "Version";
    public static final String SOURCE_EDITION = "SourceEdition";
    public static final String BUILD = "Build";
    public static final String IS_LICENSE_VALID = "IsLicenseValid";
    public static final String SUPPORTED_FEATURES = "SupportedFeatures";
    public static final String LICENSE_EXPIRATION_DATE = "LicenseExpirationDate";
    public static final String PRODUCT_EDITION_NAME = "ProductEditionName";
    public static final String LICENSE_TYPE = "LicenseType";
    public static final String LICENSE_USER_COUNT = "LicenseUsersCount";
    public static final String LICENSE_CPUS_COUNT = "LicenseCpusCount";
    public static final String LICENSE_CORES_COUNT = "LicenseCoresCount";
    public static final String LICENSE_ENVIRONMENT_TYPE = "LicenseEnvironmentType";
    public static final String LICENSE_USER_COUNT_EXCEEDED = "LicenseUserCountExceeded";
    public static final String LICENSE_ABOUT_TO_EXPIRE = "LicenseAboutToExpire";
    public static final String NUMBER_OF_RUNS = "NumberOfRuns";
    public static final String NUMBER_OF_AVAILABLE_RUNS = "NumberOfAvailableRuns";
    public static final String NUMBER_OF_DAYS_UNTIL_EXECUTIONS_ALLOWED = "NumberOfDaysUntilExecutionsAllowed";
    public static final String NUMBER_OF_POSSIBLE_VIOLATIONS = "NumberOfPossibleViolations";
    public static final String AWS_SETTINGS = "AwsSettings";
    public static final String OLAP_SETTINGS = "OlapSettings";
    public static final String ADHOC_SETTINGS = "AdhocSettings";
    public static final String LOG_SETTINGS = "LogSettings";
    public static final String GLOBAL_PROPERTIES_LIST = "GlobalPropertiesList";
    public static final String RUNNING_ADHOC_TABLE_VIEW_COUNT = "RunningAdhocTableViewCount";
    public static final String RUNNING_ADHOC_CROSSTAB_VIEW_COUNT = "RunningAdhocCrossTabViewCount";
    public static final String RUNNING_ADHOC_CHART_VIEW_COUNT = "RunningAdhocChartViewCount";
    public static final String RUNNING_ADHOC_VIEW_INFO = "RunningAdhocViewInfo";
    public static final String TOTAL_USERS_COUNT = "TotalUsersCount";
    public static final String TOTAL_ENABLED_USERS_COUNT = "TotalEnabledUsersCount";
    public static final String TOTAL_ROLES_COUNT = "TotalRolesCount";
    public static final String TOTAL_REPORTS_COUNT = "TotalReportsCount";
    public static final String TOTAL_FOLDERS_COUNT = "TotalFoldersCount";
    public static final String TOTAL_DASHBOARDS_COUNT = "TotalDashboardsCount";
    public static final String TOTAL_ADHOC_VIEWS_COUNT = "TotalAdhocViewsCount";
    public static final String TOTAL_REPORT_OUTPUTS_COUNT = "TotalReportOutputsCount";
    public static final String TOTAL_OLAP_VIEWS_COUNT = "TotalOlapViewsCount";
    public static final String TOTAL_DOMAINS_COUNT = "TotalDomainsCount";
    public static final String TOTAL_DATA_SOURCES_COUNT = "TotalDataSourcesCount";
    public static final String TOTAL_ORGANIZATIONS_COUNT = "TotalOrganizationsCount";
    public static final String DATABASE_PRODUCT_NAME = "DatabaseProductName";
    public static final String DATABASE_PRODUCT_VERSION = "DatabaseProductVersion";
    public static final String DRIVER_NAME = "DriverName";
    public static final String SQL_KEYWORDS = "SQLKeywords";
    public static final String DATABASE_URL = "URL";
    public static final String DATABASE_USER_NAME = "UserName";
    public static final String JDBC_MAJOR_VERSION = "JDBCMajorVersion";
    public static final String JDBC_MINOR_VERSION = "JDBCMinorVersion";
    public static final String DATABASE_MAX_ROW_SIZE = "MaxRowSize";
    public static final String DATABASE_MAX_STATEMENT_LENGTH = "MaxStatementLength";
    public static final String DATABASE_MAX_CONNECTIONS = "MaxConnections";
    public static final String DATABASE_MAX_CHAR_LENGTH = "MaxCharLiteralLength";
    public static final String DATABASE_MAX_COLUMNS_TABLE = "MaxColumnsInTable";
    public static final String DATABASE_MAX_COLUMNS_SELECT = "MaxColumnsInSelect";
    public static final String DATABASE_MAX_COLUMNS_GROUP = "MaxColumnsInGroupBy";
    public static final String DATABASE_MAX_COLUMN_NAME_LENGTH = "MaxColumnNameLength";
    public static final String HIBERNATE_START_TIME = "StartTime";
    public static final String HIBERNATE_STATISTICS_ENABLED = "StatisticsEnabled";
    public static final String HIBERNATE_ENTITY_DELETE_COUNT = "EntityDeleteCount";
    public static final String HIBERNATE_ENTITY_INSERT_COUNT = "EntityInsertCount";
    public static final String HIBERNATE_ENTITY_LOAD_COUNT = "EntityLoadCount";
    public static final String HIBERNATE_ENTITY_FETCH_COUNT = "EntityFetchCount";
    public static final String HIBERNATE_ENTITY_UPDATE_COUNT = "EntityUpdateCount";
    public static final String HIBERNATE_QUERY_EXECUTION_COUNT = "QueryExecutionCount";
    public static final String HIBERNATE_QUERY_CACHE_HIT_COUNT = "QueryCacheHitCount";
    public static final String HIBERNATE_QUERY_EXECUTION_MAX_TIME = "QueryExecutionMaxTime";
    public static final String HIBERNATE_QUERY_CACHE_MIS_COUNT = "QueryCacheMissCount";
    public static final String HIBERNATE_QUERY_CACHE_PUT_COUNT = "QueryCachePutCount";
    public static final String HIBERNATE_FLUSH_COUNT = "FlushCount";
    public static final String HIBERNATE_CONNECT_COUNT = "ConnectCount";
    public static final String HIBERNATE_SECOND_LEVEL_CACHE_HIT_COUNT = "SecondLevelCacheHitCount";
    public static final String HIBERNATE_SECOND_LEVEL_CACHE_MISS_COUNT = "SecondLevelCacheMissCount";
    public static final String HIBERNATE_SECOND_LEVEL_CACHE_PUT_COUNT = "SecondLevelCachePutCount";
    public static final String HIBERNATE_SESSION_CLOSE_COUNT = "SessionCloseCount";
    public static final String HIBERNATE_SESSION_OPEN_COUNT = "SessionOpenCount";
    public static final String HIBERNATE_COLLECTION_LOAD_COUNT = "CollectionLoadCount";
    public static final String HIBERNATE_COLLECTION_FETCH_COUNT = "CollectionFetchCount";
    public static final String HIBERNATE_COLLECTION_UPDATE_COUNT = "CollectionUpdateCount";
    public static final String HIBERNATE_COLLECTION_REMOVE_COUNT = "CollectionRemoveCount";
    public static final String HIBERNATE_COLLECTION_RECREATE_COUNT = "CollectionRecreateCount";
    public static final String HIBERNATE_COLLECTION_ROLE_NAMES = "CollectionRoleNames";
    public static final String HIBERNATE_ENTITY_NAMES = "EntityNames";
    public static final String HIBERNATE_QUERIES = "Queries";
    public static final String HIBERNATE_SECOND_LEVEL_CACHE_REGION_NAMES = "SecondLevelCacheRegionNames";
    public static final String HIBERNATE_SUCCESSFUL_TRANSACTION_COUNT = "SuccessfulTransactionCount";
    public static final String HIBERNATE_TRANSACTION_COUNT = "TransactionCount";
    public static final String HIBERNATE_CLOSE_STATEMENT_COUNT = "CloseStatementCount";
    public static final String HIBERNATE_PREPARE_STATEMENT_COUNT = "PrepareStatementCount";
    public static final String HIBERNATE_OPTIMISTIC_FAILURE_COUNT = "OptimisticFailureCount";
    public static final String HIBERNATE_QUERY_EXECUTION_MAX_TIME_QUERY_STRING = "QueryExecutionMaxTimeQueryString";
    public static final String EHCACHE_STAT_CACHEHIT_PERCENTAGE = "CacheHitPercentage";
    public static final String EHCACHE_STAT_CACHEHITS = "CacheHits";
    public static final String EHCACHE_STAT_CACHEMISS_PERCENTAGE = "CacheMissPercentage";
    public static final String EHCACHE_STAT_CACHEMISSES = "CacheMisses";
    public static final String EHCACHE_STAT_DISKSTORECOUNT = "DiskStoreObjectCount";
    public static final String EHCACHE_STAT_DISKHITT_PERCENTAGE = "OnDiskHitPercentage";
    public static final String EHCACHE_STAT_DISKHITS = "OnDiskHits";
    public static final String EHCACHE_STAT_DISKMISSES = "OnDiskMisses";
    public static final String EHCACHE_STAT_MEMORYSTORECOUNT = "MemoryStoreObjectCount";
    public static final String EHCACHE_STAT_MEMORYHITS = "InMemoryHits";
    public static final String EHCACHE_STAT_MEMORYHITT_PERCENTAGE = "InMemoryHitPercentage";
    public static final String EHCACHE_STAT_MEMORYMISSES = "InMemoryMisses";
    public static final String EHCACHE_STAT_OFFHEAPSTORECOUNT = "OffHeapStoreObjectCount";
    public static final String EHCACHE_STAT_OFFHEAPHITS = "OffHeapHits";
    public static final String EHCACHE_STAT_OFFHEAPHITT_PERCENTAGE = "OffHeapHitPercentage";
    public static final String EHCACHE_STAT_OFFHEAPMISSES = "OffHeapMisses";
    public static final String EHCACHE_STAT_OBJECTCOUNT = "ObjectCount";
    public static final String EHCACHE_STAT_WRITEMAXQUEUE = "WriteMaxQueueSize";
    public static final String EHCACHE_STAT_WRITEQUEUELENGTH = "WriteQueueLength";
    public static final String EHCACHE_STAT_ACCURACY = "StatisticsAccuracy";
    public static final String EHCACHE_STAT_ACCURACYDESCR = "StatisticsAccuracyDescription";
    public static final String EHCACHE_CONF_STATISTICS = "Conf.Statistics";
    public static final String EHCACHE_CONF_DISKEXPIRYTHREAD = "Conf.DiskExpiryThreadIntervalSeconds";
    public static final String EHCACHE_CONF_DISKEPERSISTENT = "DiskPersistent";
    public static final String EHCACHE_CONF_DISKSPOOL = "Conf.DiskSpoolBufferSizeMB";
    public static final String EHCACHE_CONF_ETERNAL = "Eternal";
    public static final String EHCACHE_CONF_LOGGING = "Conf.LoggingEnabled";
    public static final String EHCACHE_CONF_MBYTE_LOCALDISK = "Conf.MaxBytesLocalDisk";
    public static final String EHCACHE_CONF_MBYTE_LOCALHEAP = "Conf.MaxBytesLocalHeap";
    public static final String EHCACHE_CONF_MBYTE_LOCALOFFHEAP = "Conf.MaxBytesLocalOffHeap";
    public static final String EHCACHE_CONF_MELEMENTS_LOCALDISK = "Conf.MaxElementsOnDisk";
    public static final String EHCACHE_CONF_MELEMENTS_MEMORY = "Conf.MaxElementsInMemory";
    public static final String EHCACHE_CONF_MENTRYES_MEMORY = "Conf.MaxEntriesLocalDisk";
    public static final String EHCACHE_CONF_MENTRYES_LOCALHEAP = "Conf.MaxEntriesLocalHeap";
    public static final String EHCACHE_CONF_MEMORYSTORE_POLICY = "Conf.MemoryStoreEvictionPolicy";
    public static final String EHCACHE_CONF_OVERFLOW_DISK = "OverflowToDisk";
    public static final String EHCACHE_CONF_OVERFLOW_OFFHEAP = "OverflowToOffHeap";
    public static final String EHCACHE_CONF_TIME_IDLE = "Conf.TimeToIdleSeconds";
    public static final String EHCACHE_CONF_TIME_LIVE = "Conf.TimeToLiveSeconds";
    public static final String DIAGNOSTIC_ATTRIBUTE_MESSAGES_PREFIX = "diagnosticAttribute.desc.";
    public static final String EXT_AVAILABLEPROCESSORS = "AvailableLogicalProcessors";
    public static final String EXT_FREEMEMORY = "FreeMemory";
    public static final String EXT_MAXMEMORY = "MaxMemory";
    public static final String EXT_TOTALMEMORY = "TotalMemory";
    public static final String EXT_ENVIRONMENT = "Environment";
    public static final String EXT_PROPERTIES = "Properties";
    public static final String EXT_JVMHEAPMEMORY = "JvmHeapMemory";
    public static final String EXT_JVMNONHEAPMEMORY = "JvmNonHeapMemory";
    public static final String EXT_OSNAME = "OsName";
    public static final String EXT_OSARCH = "OsArchitecture";
    public static final String EXT_OSVERSION = "OsVersion";
    public static final String EXT_OSSYSTEMLOADAVERAGE = "OsSystemLoadAverage";
    public static final String EXT_OSTOTALPHYSICALMEMORY = "OsTotalPhysicalMemorySize";
    public static final String EXT_OSTOTALSWAPSPACESIZE = "OsTotalSwapSpaceSize";
    public static final String EXT_OSFREESWAPSPACESIZE = "OsFreeSwapSpaceSize";
    public static final String EXT_OSFREEPHYSICALMEMORY = "OsFreePhysicalMemorySize";
    public static final String EXT_OSPROCESSORCPUTIME = "OsProcessCpuTime";
    public static final String EXT_OSCOMMITEDVIRTUALMEMORYSIZE = "OsCommittedVirtualMemorySize";
    public static final String EXT_CLASSLOADERTOTALLOADEDCLASSESCOUNT = "ClTotalLoadedClassCount";
    public static final String EXT_CLASSLOADERUNLOADEDCLASSCOUNT = "ClUnloadedClassCount";
    public static final String EXT_CLASSLOADERLOADEDCLASSCOUNT = "ClLoadedClassCount";
    public static final String EXT_RUNTIMEBOOTCLASSPATH = "RtBootClassPath";
    public static final String EXT_RUNTIMECLASSPATH = "RtClassPath";
    public static final String EXT_RUNTIMELIBRARYPATH = "RtLibraryPath";
    public static final String EXT_RUNTIMEUPTIME = "RtUpTime";
    public static final String EXT_RUNTIMEVMNAME = "RtVmName";
    public static final String EXT_RUNTIMEVMVENDOR = "RtVmVendor";
    public static final String EXT_RUNTIMEVMVERSION = "RtVmVersion";
    public static final String EXT_RUNTIMEINPUTARGUMENTS = "RtInputArguments";
    public static final String EXT_DISKSFREESPACE = "DisksFreeSpace";
    private Map<DiagnosticAttribute, DiagnosticCallback> diagnosticData = new HashMap<DiagnosticAttribute, DiagnosticCallback>();
    private static MessageSource messageSource;

    public DiagnosticAttributeBuilder addDiagnosticAttribute(String diagnosticAttribute, DiagnosticCallback callback) {
        String attributeDescription = "";
        try {
            attributeDescription = messageSource.getMessage(DIAGNOSTIC_ATTRIBUTE_MESSAGES_PREFIX + diagnosticAttribute, new Object[0], Locale.getDefault());
        }
        catch (Exception ex) {
            // empty catch block
        }
        DiagnosticAttributeImpl attributeInfo = new DiagnosticAttributeImpl(diagnosticAttribute, this.getAttributeType(callback), attributeDescription);
        this.diagnosticData.put(attributeInfo, callback);
        return this;
    }

    private String getAttributeType(DiagnosticCallback callback) {
        Type[] genericInterfaces;
        for (Type type : genericInterfaces = callback.getClass().getGenericInterfaces()) {
            if (!(type instanceof ParameterizedType) || ((ParameterizedType)type).getRawType() != DiagnosticCallback.class) continue;
            return ((ParameterizedType)type).getActualTypeArguments()[0].toString();
        }
        return "java.lang.Object";
    }

    public Map<DiagnosticAttribute, DiagnosticCallback> build() {
        return this.diagnosticData;
    }

    public void setMessageSource(MessageSource messageSource) {
        DiagnosticAttributeBuilder.messageSource = messageSource;
    }
}

