/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.MountHandle;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.module.TempFileProviderService;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.SuffixMatchFilter;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.TeiidAttachments;

class VDBDependencyDeployer
implements DeploymentUnitProcessor {
    public static final String LIB = "/lib";
    private static final VirtualFileFilter DEFAULT_JAR_LIB_FILTER = new SuffixMatchFilter(".jar", VisitorAttributes.DEFAULT);

    VDBDependencyDeployer() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!TeiidAttachments.isVDBDeployment(deploymentUnit)) {
            return;
        }
        VDBMetaData deployment = (VDBMetaData)deploymentUnit.getAttachment(TeiidAttachments.VDB_METADATA);
        ArrayList<ModuleDependency> localDependencies = new ArrayList<ModuleDependency>();
        ArrayList<ModuleDependency> userDependencies = new ArrayList<ModuleDependency>();
        String moduleNames = deployment.getPropertyValue("lib");
        if (moduleNames != null) {
            StringTokenizer modules = new StringTokenizer(moduleNames);
            while (modules.hasMoreTokens()) {
                String moduleName = modules.nextToken().trim();
                ModuleIdentifier lib = ModuleIdentifier.create((String)moduleName);
                ModuleLoader moduleLoader = Module.getCallerModuleLoader();
                try {
                    moduleLoader.loadModule(lib);
                    localDependencies.add(new ModuleDependency(moduleLoader, ModuleIdentifier.create((String)moduleName), false, false, false, false));
                }
                catch (ModuleLoadException e) {
                    moduleLoader = (ModuleLoader)deploymentUnit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
                    try {
                        moduleLoader.loadModule(lib);
                        userDependencies.add(new ModuleDependency(moduleLoader, ModuleIdentifier.create((String)moduleName), false, false, false, true));
                    }
                    catch (ModuleLoadException e1) {
                        throw new DeploymentUnitProcessingException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50088, new Object[]{moduleName, deployment.getName(), deployment.getVersion(), e1}));
                    }
                }
            }
        }
        if (!TeiidAttachments.isDynamicVDB(deploymentUnit)) {
            try {
                ResourceRoot deploymentResourceRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
                VirtualFile deploymentRoot = deploymentResourceRoot.getRoot();
                if (deploymentRoot == null) {
                    return;
                }
                VirtualFile libDir = deploymentRoot.getChild(LIB);
                if (libDir.exists()) {
                    List archives = libDir.getChildren(DEFAULT_JAR_LIB_FILTER);
                    for (VirtualFile archive : archives) {
                        try {
                            Closeable closable = VFS.mountZip((VirtualFile)archive, (VirtualFile)archive, (TempFileProvider)TempFileProviderService.provider());
                            ResourceRoot jarArchiveRoot = new ResourceRoot(archive.getName(), archive, new MountHandle(closable));
                            ModuleRootMarker.mark((ResourceRoot)jarArchiveRoot);
                            deploymentUnit.addToAttachmentList(Attachments.RESOURCE_ROOTS, (Object)jarArchiveRoot);
                        }
                        catch (IOException e) {
                            throw new DeploymentUnitProcessingException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50018, new Object[]{archive}), (Throwable)e);
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new DeploymentUnitProcessingException((Throwable)e);
            }
        }
        try {
            ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
            ModuleLoader moduleLoader = Module.getCallerModule().getModule(ModuleIdentifier.create((String)"org.jboss.teiid")).getModuleLoader();
            moduleSpecification.addLocalDependency(new ModuleDependency(moduleLoader, ModuleIdentifier.create((String)"org.jboss.teiid.api"), false, false, false, false));
            moduleSpecification.addLocalDependency(new ModuleDependency(moduleLoader, ModuleIdentifier.create((String)"org.jboss.teiid.common-core"), false, false, false, false));
            moduleSpecification.addLocalDependency(new ModuleDependency(moduleLoader, ModuleIdentifier.create((String)"javax.api"), false, false, false, false));
            if (!localDependencies.isEmpty()) {
                moduleSpecification.addLocalDependencies(localDependencies);
            }
            if (userDependencies.isEmpty()) return;
            moduleSpecification.addUserDependencies(userDependencies);
            return;
        }
        catch (ModuleLoadException e) {
            throw new DeploymentUnitProcessingException(IntegrationPlugin.Event.TEIID50018.name(), (Throwable)e);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

